/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ListDialog;

public class ModelSubclassSelectionDialog
extends ListDialog {
    protected EClass listItemClass;
    protected List<EClass> items;
    protected DiagramEditor diagramEditor;

    public ModelSubclassSelectionDialog(DiagramEditor diagramEditor, EObject object, EStructuralFeature feature) {
        this(diagramEditor, object, feature, null);
    }

    public ModelSubclassSelectionDialog(DiagramEditor diagramEditor, EObject object, EStructuralFeature feature, EClass listItemClass) {
        super(diagramEditor.getSite().getShell());
        this.diagramEditor = diagramEditor;
        if (listItemClass == null) {
            listItemClass = (EClass)feature.getEType();
        }
        this.listItemClass = listItemClass;
        ModelEnablements modelEnablement = (ModelEnablements)diagramEditor.getAdapter(ModelEnablements.class);
        this.items = new ArrayList<EClass>();
        if (listItemClass != null && !listItemClass.isAbstract() && !listItemClass.isInterface() && modelEnablement.isEnabled(listItemClass)) {
            this.items.add(listItemClass);
        }
        for (EClassifier eclassifier : Bpmn2Package.eINSTANCE.getEClassifiers()) {
            EClass eclass;
            if (!(eclassifier instanceof EClass) || !(eclass = (EClass)eclassifier).getEAllSuperTypes().contains((Object)listItemClass) || !modelEnablement.isEnabled(eclass)) continue;
            this.items.add(eclass);
        }
        this.filterList(this.items);
        if (this.items.size() > 1) {
            this.setContentProvider(new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    return ModelSubclassSelectionDialog.this.items.toArray();
                }
            });
            this.setLabelProvider(new ILabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return ModelUtil.toCanonicalString(((EClass)element).getName());
                }
            });
            this.setTitle(NLS.bind((String)Messages.ModelSubclassSelectionDialog_Title, (Object)ModelUtil.toCanonicalString(listItemClass.getName())));
            this.setAddCancelButton(true);
            this.setHelpAvailable(false);
            this.setInput(new Object());
        }
    }

    public TargetRuntime getTargetRuntime() {
        return (TargetRuntime)this.diagramEditor.getAdapter(TargetRuntime.class);
    }

    protected void filterList(List<EClass> items) {
    }

    public int open() {
        if (this.items.size() <= 1) {
            return 0;
        }
        return super.open();
    }

    public Object[] getResult() {
        if (this.items.size() == 0) {
            return new Object[]{this.listItemClass};
        }
        if (this.items.size() == 1) {
            return new Object[]{this.items.get(0)};
        }
        return super.getResult();
    }
}

