/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.providers;

import org.eclipse.bpmn2.modeler.core.merrimac.providers.Messages;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableCursor
extends Canvas {
    Table table;
    int row = -1;
    int column = 0;
    Listener tableListener;
    Listener resizeListener;
    boolean progVisible = false;
    boolean userVisible = true;
    boolean hasFocus = false;
    AccessibleAdapter accessAdapter = null;
    Listener selectionAccessListener = null;
    Listener focusAccessListener = null;
    AccessibleControlAdapter accessControlAdapter = null;
    boolean hasAccessibility = false;

    public TableCursor(Table parent, int style) {
        super((Composite)parent, style);
        ScrollBar vBar;
        this.table = parent;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TableCursor.this.dispose(event);
                        break;
                    }
                    case 1: {
                        TableCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TableCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        TableCursor.this.traverse(event);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(1, listener);
        this.addListener(9, listener);
        this.addListener(31, listener);
        this.tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableCursor.this.tableMouseDown(event);
                        break;
                    }
                    case 15: {
                        TableCursor.this.tableFocusIn(event);
                    }
                }
            }
        };
        this.table.addListener(15, this.tableListener);
        this.table.addListener(3, this.tableListener);
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.resize();
            }
        };
        ScrollBar hBar = this.table.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.resizeListener);
        }
        if ((vBar = this.table.getVerticalBar()) != null) {
            vBar.addListener(13, this.resizeListener);
        }
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TableCursor.this.hasFocus = true;
                TableCursor.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                TableCursor.this.hasFocus = false;
                TableCursor.this.redraw();
            }
        });
        this.refresh();
        this.initAccessible();
    }

    public static TableCursor create(final Table table, final TableViewer tableViewer) {
        final TableCursor cursor = new TableCursor(table, 0);
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableCursor.this.getRow() != null) {
                    table.setSelection(new TableItem[]{TableCursor.this.getRow()});
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem row = TableCursor.this.getRow();
                if (row != null) {
                    int nRow = table.indexOf(row);
                    int column = TableCursor.this.getColumn();
                    Object obj = tableViewer.getElementAt(nRow);
                    tableViewer.editElement(obj, column);
                }
            }
        });
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || e.keyCode == 131072 || (e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    TableCursor.this.setVisible(false);
                }
            }
        });
        cursor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem row = TableCursor.this.getRow();
                if (row != null) {
                    int nRow = table.indexOf(row);
                    int column = TableCursor.this.getColumn();
                    Object obj = tableViewer.getElementAt(nRow);
                    tableViewer.editElement(obj, column);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (table.getItemCount() == 0) {
                    return;
                }
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                cursor.setSelection(row, 0);
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
        return cursor;
    }

    public void refresh() {
        TableItem[] selection;
        TableColumn column;
        int columns = this.table.getColumnCount();
        int i = 0;
        while (i < columns) {
            column = this.table.getColumn(i);
            column.removeListener(11, this.resizeListener);
            ++i;
        }
        i = 0;
        while (i < columns) {
            column = this.table.getColumn(i);
            column.addListener(11, this.resizeListener);
            ++i;
        }
        if (this.row >= this.table.getItemCount()) {
            this.row = this.table.getItemCount() - 1;
        }
        if (this.column >= columns) {
            this.column = columns - 1;
        }
        if ((selection = this.table.getSelection()).length == 0) {
            this.row = -1;
        }
        this.setSelection(this.row, this.column);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void dispose(Event event) {
        Display display = this.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ScrollBar vBar;
                if (TableCursor.this.table.isDisposed()) {
                    return;
                }
                TableCursor.this.table.removeListener(15, TableCursor.this.tableListener);
                TableCursor.this.table.removeListener(3, TableCursor.this.tableListener);
                int columns = TableCursor.this.table.getColumnCount();
                int i = 0;
                while (i < columns) {
                    TableColumn column = TableCursor.this.table.getColumn(i);
                    column.removeListener(11, TableCursor.this.resizeListener);
                    ++i;
                }
                ScrollBar hBar = TableCursor.this.table.getHorizontalBar();
                if (hBar != null) {
                    hBar.removeListener(13, TableCursor.this.resizeListener);
                }
                if ((vBar = TableCursor.this.table.getVerticalBar()) != null) {
                    vBar.removeListener(13, TableCursor.this.resizeListener);
                }
            }
        });
    }

    void keyDown(Event event) {
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        switch (event.keyCode) {
            case 0x1000001: {
                if (this.column < 0) {
                    this.column = 0;
                }
                this.setRowColumn(this.row - 1, this.column, true);
                break;
            }
            case 0x1000002: {
                if (this.column < 0) {
                    this.column = 0;
                }
                this.setRowColumn(this.row + 1, this.column, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int leadKey;
                if (this.column < 0) {
                    this.column = 0;
                }
                int n = leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                if (event.keyCode == leadKey) {
                    this.setRowColumn(this.row, this.column - 1, true);
                    break;
                }
                this.setRowColumn(this.row, this.column + 1, true);
                break;
            }
            case 0x1000007: {
                if (this.column < 0) {
                    this.column = 0;
                }
                this.setRowColumn(0, this.column, true);
                break;
            }
            case 0x1000008: {
                if (this.column < 0) {
                    this.column = 0;
                }
                int row = this.table.getItemCount() - 1;
                this.setRowColumn(row, this.column, true);
            }
        }
    }

    void paint(Event event) {
        GC gc = event.gc;
        Display display = this.getDisplay();
        gc.setBackground(display.getSystemColor(27));
        gc.setForeground(display.getSystemColor(26));
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        TableItem item = null;
        if (this.row >= 0 && this.row < this.table.getItemCount()) {
            item = this.table.getItem(this.row);
        }
        int x = 0;
        int y = 0;
        Point size = this.getSize();
        if (item != null) {
            Image image = item.getImage(this.column);
            if (image != null) {
                Rectangle imageSize = image.getBounds();
                int imageY = y + (int)((double)((float)size.y - (float)imageSize.height) / 2.0);
                gc.drawImage(image, x, imageY);
                x += imageSize.width;
            }
            int n = this.column == 0 ? 2 : 6;
            int textY = y + (int)((double)((float)size.y - (float)gc.getFontMetrics().getHeight()) / 2.0);
            gc.drawString(item.getText(this.column), x += n, textY);
        }
        if (this.isFocusControl()) {
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            this.setFocus();
            this.redraw();
        }
    }

    void tableMouseDown(Event event) {
        event.doit = true;
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        Rectangle clientRect = this.table.getClientArea();
        int columns = this.table.getColumnCount();
        int start = this.table.getTopIndex();
        int end = this.table.getItemCount();
        int row = start;
        while (row < end) {
            TableItem item = this.table.getItem(row);
            int column = 0;
            while (column < columns) {
                Rectangle rect = item.getBounds(column);
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                if (rect.contains(pt)) {
                    this.setRowColumn(row, column, true);
                    return;
                }
                ++column;
            }
            ++row;
        }
    }

    void traverse(Event event) {
        switch (event.detail) {
            case 4: 
            case 32: 
            case 64: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }

    void setRowColumn(int row, int column, boolean notify) {
        if (row >= 0 && row < this.table.getItemCount() && column >= 0 && column < this.table.getColumnCount()) {
            this.row = row;
            this.column = column;
            TableItem item = this.table.getItem(row);
            this.table.showItem(item);
            this.setBounds(item.getBounds(column));
            if (notify) {
                this.notifyListeners(13, new Event());
            }
        }
        this.redraw();
        this.updateVisible();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.userVisible = visible;
        this.resize();
    }

    void resize() {
        if (this.row >= 0 && this.row < this.table.getItemCount()) {
            TableItem item = this.table.getItem(this.row);
            this.setBounds(item.getBounds(this.column));
        }
        this.updateVisible();
    }

    void updateVisible() {
        this.progVisible = false;
        if (this.row >= 0 && this.row < this.table.getItemCount() && this.column >= 0 && this.column < this.table.getColumnCount()) {
            this.progVisible = true;
        }
        super.setVisible(this.progVisible && this.userVisible);
    }

    public int getColumn() {
        this.checkWidget();
        return this.column;
    }

    public TableItem getRow() {
        this.checkWidget();
        if (this.row < 0 || this.row >= this.table.getItemCount()) {
            return null;
        }
        return this.table.getItem(this.row);
    }

    public void setSelection(int row, int column) {
        this.checkWidget();
        this.setRowColumn(row, column, false);
    }

    public void setSelection(TableItem row, int column) {
        this.checkWidget();
        this.setRowColumn(this.table.indexOf(row), column, false);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        if (this.accessAdapter == null) {
            this.accessAdapter = new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    String name = null;
                    TableItem item = null;
                    TableColumn[] tableColumns = TableCursor.this.table.getColumns();
                    TableColumn thisCol = null;
                    if (TableCursor.this.row >= 0 && TableCursor.this.row < TableCursor.this.table.getItemCount() && TableCursor.this.column >= 0 && TableCursor.this.column < TableCursor.this.table.getColumnCount()) {
                        item = TableCursor.this.table.getItem(TableCursor.this.row);
                        if (TableCursor.this.column >= 0 && TableCursor.this.column < tableColumns.length) {
                            thisCol = tableColumns[TableCursor.this.column];
                        }
                    }
                    if (item != null) {
                        if (thisCol != null) {
                            name = thisCol.getText();
                        }
                        name = name != null && name.length() > 0 ? String.valueOf(name) + "=" + item.getText(TableCursor.this.column) : item.getText(TableCursor.this.column);
                    }
                    e.result = name;
                }

                public void getHelp(AccessibleEvent e) {
                    Object help = null;
                    e.result = help;
                }

                public void getKeyboardShortcut(AccessibleEvent e) {
                }
            };
            this.accessControlAdapter = new AccessibleControlAdapter(){

                public void getChildAtPoint(AccessibleControlEvent e) {
                    Point testPoint = TableCursor.this.toControl(new Point(e.x, e.y));
                    int childID = -2;
                    if (childID == -2) {
                        Rectangle location = TableCursor.this.getBounds();
                        location.height -= TableCursor.this.getClientArea().height;
                        if (location.contains(testPoint)) {
                            childID = -1;
                        }
                    }
                    e.childID = childID;
                }

                public void getLocation(AccessibleControlEvent e) {
                    Rectangle location = null;
                    int childID = e.childID;
                    if (childID == -1) {
                        location = TableCursor.this.getBounds();
                    }
                    if (location != null) {
                        Point pt = TableCursor.this.toDisplay(new Point(location.x, location.y));
                        e.x = pt.x;
                        e.y = pt.y;
                        e.width = location.width;
                        e.height = location.height;
                    }
                }

                public void getChildCount(AccessibleControlEvent e) {
                    e.detail = 0;
                }

                public void getDefaultAction(AccessibleControlEvent e) {
                    String action;
                    e.result = action = Messages.TableCursor_Edit;
                }

                public void getFocus(AccessibleControlEvent e) {
                    int childID = -2;
                    if (TableCursor.this.isFocusControl()) {
                        childID = -1;
                    }
                    e.childID = childID;
                }

                public void getRole(AccessibleControlEvent e) {
                    int role = 0;
                    int childID = e.childID;
                    if (childID == -1) {
                        role = 34;
                    }
                    e.detail = role;
                }

                public void getSelection(AccessibleControlEvent e) {
                    e.childID = -2;
                }

                public void getState(AccessibleControlEvent e) {
                    int state = 0;
                    int childID = e.childID;
                    if (childID == -1) {
                        state = 0x200000;
                        if (TableCursor.this.isFocusControl()) {
                            state |= 0x100000;
                            if (TableCursor.this.hasFocus) {
                                state += 6;
                            }
                        }
                    }
                    e.detail = state;
                }

                public void getChildren(AccessibleControlEvent e) {
                    e.children = null;
                }
            };
            this.selectionAccessListener = new Listener(){

                public void handleEvent(Event event) {
                    accessible.setFocus(-1);
                }
            };
            this.focusAccessListener = new Listener(){

                public void handleEvent(Event event) {
                    accessible.setFocus(-1);
                }
            };
        }
        if (this.hasAccessibility) {
            accessible.removeAccessibleListener((AccessibleListener)this.accessAdapter);
            accessible.removeAccessibleControlListener((AccessibleControlListener)this.accessControlAdapter);
            this.removeListener(13, this.selectionAccessListener);
            this.removeListener(15, this.focusAccessListener);
            this.hasAccessibility = false;
        }
        if (!this.hasAccessibility) {
            accessible.addAccessibleListener((AccessibleListener)this.accessAdapter);
            accessible.addAccessibleControlListener((AccessibleControlListener)this.accessControlAdapter);
            this.addListener(13, this.selectionAccessListener);
            this.addListener(15, this.focusAccessListener);
            this.hasAccessibility = true;
        }
    }
}

