/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.cdt.debug.application.ApplicationWorkbenchAdvisor;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    public static final String WORKSPACE_NAME = "workspace-cdtdebug";
    private Location fInstanceLoc = null;

    public Object start(IApplicationContext context) throws Exception {
        Display display = PlatformUI.createDisplay();
        try {
            if (!this.setupWorkspaceLocation(display)) {
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private boolean setupWorkspaceLocation(Display display) throws IOException {
        this.fInstanceLoc = Platform.getInstanceLocation();
        if (!this.fInstanceLoc.allowsDefault() && !this.fInstanceLoc.isSet()) {
            File workspaceRoot = new Path(System.getProperty("user.home")).toFile();
            if (!workspaceRoot.exists()) {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_WorkspaceCreationError, (String)MessageFormat.format(Messages.Application_WorkspaceRootNotExistError, workspaceRoot));
                return false;
            }
            if (!workspaceRoot.canWrite()) {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_WorkspaceCreationError, (String)MessageFormat.format(Messages.Application_WorkspaceRootPermissionError, workspaceRoot));
                return false;
            }
            String workspace = String.valueOf(workspaceRoot.getAbsolutePath()) + File.separator + WORKSPACE_NAME;
            this.fInstanceLoc.set(new URL("file", null, workspace), false);
        }
        if (!this.fInstanceLoc.lock()) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_WorkspaceCreationError, (String)MessageFormat.format(Messages.Application_WorkspaceInUseError, this.fInstanceLoc.getURL().getPath()));
            return false;
        }
        return true;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        this.fInstanceLoc.release();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

