/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIFunctionFinishedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIArg;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackListFramesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackListLocalsInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIStack
extends AbstractDsfService
implements IStack,
ICachingService {
    private static final int DEFAULT_STACK_DEPTH = 5;
    private CommandCache fMICommandCache;
    private CommandFactory fCommandFactory;
    private FramesCache fFramesCache = new FramesCache();
    private MIStoppedEvent fCachedStoppedEvent;
    private IRunControl fRunControl;
    private boolean fTraceVisualization;
    private Map<IMIExecutionDMContext, VariableData> fThreadToReturnVariable = new HashMap<IMIExecutionDMContext, VariableData>();

    public MIStack(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIStack.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)commandControl, this.getExecutor(), 2);
        this.fMICommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fMICommandCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IStack.class.getName(), MIStack.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fMICommandCache.reset();
        super.shutdown(rm);
    }

    public IStack.IFrameDMContext createFrameDMContext(IRunControl.IExecutionDMContext execDmc, int level) {
        return new MIFrameDMC(this.getSession().getId(), execDmc, level);
    }

    public void getFrames(IDMContext ctx, DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        this.getFrames(ctx, 0, -1, rm);
    }

    public void getFrames(IDMContext ctx, final int startIndex, final int endIndex, final DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        if (startIndex < 0 || endIndex > 0 && endIndex < startIndex) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid stack frame range [" + startIndex + ',' + endIndex + ']', null));
            rm.done();
            return;
        }
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context " + ctx, null));
            rm.done();
            return;
        }
        if (!this.fTraceVisualization && !this.fRunControl.isSuspended((IRunControl.IExecutionDMContext)execDmc)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context is running: " + ctx, null));
            rm.done();
            return;
        }
        if (startIndex == 0 && endIndex == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext())) {
            rm.setData((Object)new IStack.IFrameDMContext[]{this.createFrameDMContext(execDmc, this.fCachedStoppedEvent.getFrame().getLevel())});
            rm.done();
            return;
        }
        final String threadId = execDmc.getThreadId();
        int maxDepth = endIndex > 0 ? endIndex + 1 : -1;
        int depth = this.fFramesCache.getThreadFramesCache(threadId).getStackDepth(maxDepth);
        if (depth > 0) {
            rm.setData((Object)this.getDMFrames(execDmc, startIndex, endIndex, depth));
            rm.done();
            return;
        }
        this.getStackDepth((IDMContext)execDmc, maxDepth, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                int stackDepth = MIStack.this.fFramesCache.getThreadFramesCache(threadId).getValidStackDepth();
                rm.done((Object)MIStack.this.getDMFrames(execDmc, startIndex, endIndex, stackDepth));
            }
        });
    }

    private IStack.IFrameDMContext[] getDMFrames(IMIExecutionDMContext execDmc, int startIndex, int endIndex, int stackDepth) {
        if (endIndex > stackDepth - 1 || endIndex < 0) {
            endIndex = stackDepth - 1;
        }
        if (startIndex > endIndex) {
            return new IStack.IFrameDMContext[0];
        }
        int length = endIndex - startIndex + 1;
        IStack.IFrameDMContext[] frameDMCs = new MIFrameDMC[length];
        int i = 0;
        while (i < length) {
            frameDMCs[i] = this.createFrameDMContext(execDmc, i + startIndex);
            ++i;
        }
        return frameDMCs;
    }

    private ICommand<MIStackListFramesInfo> createMIStackListFrames(IMIExecutionDMContext execDmc) {
        return this.fCommandFactory.createMIStackListFrames(execDmc);
    }

    private ICommand<MIStackListFramesInfo> createMIStackListFrames(IMIExecutionDMContext execDmc, int startIndex, int endIndex) {
        ICommand<MIStackListFramesInfo> miStackListCmd = endIndex >= 0 ? this.fCommandFactory.createMIStackListFrames(execDmc, startIndex, endIndex) : this.fCommandFactory.createMIStackListFrames(execDmc);
        return miStackListCmd;
    }

    public void getTopFrame(IDMContext ctx, final DataRequestMonitor<IStack.IFrameDMContext> rm) {
        IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context" + ctx, null));
            rm.done();
            return;
        }
        if (this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext())) {
            rm.setData((Object)this.createFrameDMContext(execDmc, this.fCachedStoppedEvent.getFrame().getLevel()));
            rm.done();
            return;
        }
        this.getFrames(ctx, 0, 0, new DataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)((IStack.IFrameDMContext[])this.getData())[0]);
                rm.done();
            }
        });
    }

    public void getFrameData(final IStack.IFrameDMContext frameDmc, final DataRequestMonitor<IStack.IFrameDMData> rm) {
        if (!(frameDmc instanceof MIFrameDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context type " + frameDmc, null));
            rm.done();
            return;
        }
        MIFrameDMC miFrameDmc = (MIFrameDMC)frameDmc;
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No execution context found in " + frameDmc, null));
            rm.done();
            return;
        }
        final String threadId = execDmc.getThreadId();
        final int frameLevel = miFrameDmc.fLevel;
        FrameData fd = this.fFramesCache.getThreadFramesCache(threadId).getFrameData(frameLevel);
        if (fd != null) {
            rm.setData((Object)fd);
            rm.done();
            return;
        }
        if (frameLevel == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && (execDmc.equals(this.fCachedStoppedEvent.getDMContext()) || this.fTraceVisualization)) {
            try {
                rm.setData((Object)new FrameDataFromStoppedEvent(this.fCachedStoppedEvent));
                return;
            }
            finally {
                rm.done();
            }
        }
        this.fMICommandCache.execute(this.createMIStackListFrames(execDmc), (DataRequestMonitor)new DataRequestMonitor<MIStackListFramesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                FramesCacheInfo info = MIStack.this.fFramesCache.update(threadId, (MIStackListFramesInfo)this.getData());
                FrameData frameData = info.getFrameData(frameLevel);
                if (frameData == null) {
                    rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid frame " + frameDmc, null));
                } else {
                    rm.done((Object)frameData);
                }
            }

            protected void handleError() {
                MIStack.this.fMICommandCache.execute(MIStack.this.createMIStackListFrames(execDmc, frameLevel, frameLevel), (DataRequestMonitor)new DataRequestMonitor<MIStackListFramesInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        FrameData frameData = MIStack.this.fFramesCache.update(threadId, (MIStackListFramesInfo)this.getData()).getFrameData(frameLevel);
                        if (frameData == null) {
                            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid frame " + frameDmc, null));
                        } else {
                            rm.done((Object)frameData);
                        }
                    }
                });
            }
        });
    }

    public void getArguments(final IStack.IFrameDMContext frameDmc, final DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No execution context found in " + frameDmc, null));
            rm.done();
            return;
        }
        if (frameDmc.getLevel() == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext()) && this.fCachedStoppedEvent.getFrame().getArgs() != null) {
            rm.setData((Object)this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.ARGUMENT, this.fCachedStoppedEvent.getFrame().getArgs()));
            rm.done();
            return;
        }
        this.fMICommandCache.execute(this.fCommandFactory.createMIStackListArguments(execDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                int idx = frameDmc.getLevel();
                if (idx == -1 || idx >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid frame " + frameDmc, null));
                    rm.done();
                    return;
                }
                MIArg[] args = ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[idx].getArgs();
                if (args == null) {
                    args = new MIArg[]{};
                }
                rm.setData((Object)MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.ARGUMENT, args));
                rm.done();
            }

            protected void handleError() {
                MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListArguments(execDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        int idx = frameDmc.getLevel();
                        if (idx == -1 || idx >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid frame " + frameDmc, null));
                            rm.done();
                            return;
                        }
                        MIArg[] args = ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[idx].getArgs();
                        if (args == null) {
                            args = new MIArg[]{};
                        }
                        rm.setData((Object)MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.ARGUMENT, args));
                        rm.done();
                    }
                });
            }
        });
    }

    public void getVariableData(IStack.IVariableDMContext variableDmc, final DataRequestMonitor<IStack.IVariableDMData> rm) {
        if (!(variableDmc instanceof MIVariableDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context type " + variableDmc, null));
            rm.done();
            return;
        }
        final MIVariableDMC miVariableDmc = (MIVariableDMC)variableDmc;
        final MIFrameDMC frameDmc = (MIFrameDMC)DMContexts.getAncestorOfType((IDMContext)variableDmc, MIFrameDMC.class);
        if (frameDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No frame context found in " + variableDmc, null));
            rm.done();
            return;
        }
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No execution context found in " + (Object)((Object)frameDmc), null));
            rm.done();
            return;
        }
        if (miVariableDmc.fType == MIVariableDMC.Type.ARGUMENT && frameDmc.fLevel == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext()) && this.fCachedStoppedEvent.getFrame().getArgs() != null) {
            if (miVariableDmc.fIndex >= this.fCachedStoppedEvent.getFrame().getArgs().length) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                rm.done();
                return;
            }
            rm.setData((Object)new VariableData(this.fCachedStoppedEvent.getFrame().getArgs()[miVariableDmc.fIndex]));
            rm.done();
            return;
        }
        if (miVariableDmc.fType == MIVariableDMC.Type.ARGUMENT) {
            this.fMICommandCache.execute(this.fCommandFactory.createMIStackListArguments(execDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (frameDmc.fLevel >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length || miVariableDmc.fIndex >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs().length) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                        rm.done();
                        return;
                    }
                    rm.setData((Object)new VariableData(((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs()[miVariableDmc.fIndex]));
                    rm.done();
                }

                protected void handleError() {
                    MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListArguments(execDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            if (frameDmc.fLevel >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length || miVariableDmc.fIndex >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs().length) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                                rm.done();
                                return;
                            }
                            rm.setData((Object)new VariableData(((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs()[miVariableDmc.fIndex]));
                            rm.done();
                        }
                    });
                }
            });
        } else if (miVariableDmc.fType == MIVariableDMC.Type.LOCAL) {
            this.fMICommandCache.execute(this.fCommandFactory.createMIStackListLocals(frameDmc, !this.fTraceVisualization), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIArg[] locals = ((MIStackListLocalsInfo)this.getData()).getLocals();
                    if (locals.length > miVariableDmc.fIndex) {
                        rm.setData((Object)new VariableData(locals[miVariableDmc.fIndex]));
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                    }
                    rm.done();
                }

                protected void handleError() {
                    MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListLocals(frameDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            MIArg[] locals = ((MIStackListLocalsInfo)this.getData()).getLocals();
                            if (locals.length > miVariableDmc.fIndex) {
                                rm.setData((Object)new VariableData(locals[miVariableDmc.fIndex]));
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                            }
                            rm.done();
                        }
                    });
                }
            });
        } else if (miVariableDmc.fType == MIVariableDMC.Type.RETURN_VALUES) {
            VariableData var = this.fThreadToReturnVariable.get(execDmc);
            if (var != null) {
                rm.setData((Object)var);
            } else {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Return value not found", null));
            }
            rm.done();
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable type " + (Object)((Object)miVariableDmc.fType), null));
        }
    }

    private MIVariableDMC[] makeVariableDMCs(IStack.IFrameDMContext frame, MIVariableDMC.Type type, MIArg[] miArgs) {
        LinkedHashMap<String, MIVariableDMC> variableNames = new LinkedHashMap<String, MIVariableDMC>();
        int i = 0;
        while (i < miArgs.length) {
            String name = miArgs[i].getName();
            MIVariableDMC var = (MIVariableDMC)((Object)variableNames.get(name));
            if (var == null) {
                variableNames.put(name, new MIVariableDMC(this, frame, type, i));
            }
            ++i;
        }
        return variableNames.values().toArray(new MIVariableDMC[0]);
    }

    private void getReturnValues(IStack.IFrameDMContext frameDmc, DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        IMIExecutionDMContext threadDmc;
        VariableData var;
        IStack.IVariableDMContext[] values = new IStack.IVariableDMContext[]{};
        if (!this.fTraceVisualization && frameDmc.getLevel() == 0 && (var = this.fThreadToReturnVariable.get(threadDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class))) != null) {
            values = new IStack.IVariableDMContext[]{new MIVariableDMC(this, frameDmc, MIVariableDMC.Type.RETURN_VALUES, 0)};
        }
        rm.done((Object)values);
    }

    public void getLocals(final IStack.IFrameDMContext frameDmc, DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        final ArrayList localsList = new ArrayList();
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, localsList){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ List val$localsList;
            {
                this.val$rm = dataRequestMonitor;
                this.val$localsList = list;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)this.val$localsList.toArray(new IStack.IVariableDMContext[this.val$localsList.size()]));
                this.val$rm.done();
            }
        };
        countingRm.setDoneCount(3);
        this.getReturnValues(frameDmc, new DataRequestMonitor<IStack.IVariableDMContext[]>((Executor)this.getExecutor(), (RequestMonitor)countingRm){

            protected void handleSuccess() {
                localsList.addAll(Arrays.asList((IStack.IVariableDMContext[])this.getData()));
                countingRm.done();
            }
        });
        this.getArguments(frameDmc, new DataRequestMonitor<IStack.IVariableDMContext[]>((Executor)this.getExecutor(), (RequestMonitor)countingRm){

            protected void handleSuccess() {
                localsList.addAll(Arrays.asList((IStack.IVariableDMContext[])this.getData()));
                countingRm.done();
            }
        });
        this.fMICommandCache.execute(this.fCommandFactory.createMIStackListLocals(frameDmc, !this.fTraceVisualization), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)this.getExecutor(), (RequestMonitor)countingRm){

            protected void handleSuccess() {
                localsList.addAll(Arrays.asList(MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.LOCAL, ((MIStackListLocalsInfo)this.getData()).getLocals())));
                countingRm.done();
            }

            protected void handleError() {
                MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListLocals(frameDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)countingRm){

                    protected void handleSuccess() {
                        localsList.addAll(Arrays.asList(MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.LOCAL, ((MIStackListLocalsInfo)this.getData()).getLocals())));
                        countingRm.done();
                    }
                });
            }
        });
    }

    public void getStackDepth(IDMContext dmc, final int maxDepth, final DataRequestMonitor<Integer> rm) {
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIExecutionDMContext.class);
        if (execDmc != null) {
            if (!this.fTraceVisualization && !this.fRunControl.isSuspended((IRunControl.IExecutionDMContext)execDmc)) {
                rm.setData((Object)0);
                rm.done();
                return;
            }
            final String threadId = execDmc.getThreadId();
            int depth = this.fFramesCache.getThreadFramesCache(threadId).getStackDepth(maxDepth);
            if (depth > 0) {
                rm.setData((Object)depth);
                rm.done();
                return;
            }
            ICommand<MIStackInfoDepthInfo> depthCommand = null;
            depthCommand = maxDepth > 0 ? this.fCommandFactory.createMIStackInfoDepth(execDmc, maxDepth) : this.fCommandFactory.createMIStackInfoDepth(execDmc);
            this.fMICommandCache.execute(depthCommand, (DataRequestMonitor)new DataRequestMonitor<MIStackInfoDepthInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    int stackDepth = ((MIStackInfoDepthInfo)this.getData()).getDepth();
                    MIStack.this.fFramesCache.update(threadId, stackDepth, maxDepth);
                    rm.setData((Object)stackDepth);
                    rm.done();
                }

                protected void handleError() {
                    if (MIStack.this.fTraceVisualization) {
                        rm.setData((Object)1);
                        rm.done();
                    } else {
                        MIStack.this.fMICommandCache.execute(MIStack.this.createMIStackListFrames(execDmc, 0, maxDepth - 1), (DataRequestMonitor)new DataRequestMonitor<MIStackListFramesInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                FramesCacheInfo info = MIStack.this.fFramesCache.update(threadId, (MIStackListFramesInfo)this.getData());
                                int depth = info.getValidStackDepth();
                                MIStack.this.fFramesCache.update(threadId, depth, maxDepth);
                                rm.done((Object)depth);
                            }

                            protected void handleError() {
                                rm.done((Object)MIStack.this.fFramesCache.getThreadFramesCache(threadId).getValidStackDepth());
                            }
                        });
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fMICommandCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fCachedStoppedEvent = null;
            this.fMICommandCache.reset();
            this.fFramesCache.clear();
        }
        this.handleReturnValues(e);
    }

    private void handleReturnValues(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            assert (this.fThreadToReturnVariable.size() <= 1);
            this.fThreadToReturnVariable.clear();
        } else {
            IDMContext ctx = e.getDMContext();
            if (ctx instanceof IMIExecutionDMContext) {
                this.fThreadToReturnVariable.remove(ctx);
            } else if (ctx instanceof IRunControl.IContainerDMContext) {
                this.fThreadToReturnVariable.clear();
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fMICommandCache.setContextAvailable(e.getDMContext(), true);
        this.fMICommandCache.reset();
        this.fFramesCache.clear();
        this.handleReturnValues(e);
    }

    private void handleReturnValues(IRunControl.ISuspendedDMEvent e) {
        Object miEvent;
        if (e instanceof IMIDMEvent && (miEvent = ((IMIDMEvent)e).getMIEvent()) instanceof MIFunctionFinishedEvent) {
            IMIExecutionDMContext finishedEventThread = null;
            if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
                IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContexts();
                if (triggerContexts.length != 0 && triggerContexts[0] instanceof IMIExecutionDMContext) {
                    finishedEventThread = (IMIExecutionDMContext)triggerContexts[0];
                }
            } else {
                IDMContext ctx = e.getDMContext();
                if (ctx instanceof IMIExecutionDMContext) {
                    finishedEventThread = (IMIExecutionDMContext)ctx;
                }
            }
            if (finishedEventThread != null) {
                String name = ((MIFunctionFinishedEvent)((Object)miEvent)).getGDBResultVar();
                String value = ((MIFunctionFinishedEvent)((Object)miEvent)).getReturnValue();
                if (name != null && !name.isEmpty() && value != null && !value.isEmpty()) {
                    this.fThreadToReturnVariable.put(finishedEventThread, new VariableData(new MIArg(name, value)));
                }
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIDMEvent e) {
        if (e.getMIEvent() instanceof MIStoppedEvent) {
            this.fCachedStoppedEvent = (MIStoppedEvent)((Object)e.getMIEvent());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        if (e.isVisualizationModeEnabled()) {
            this.fTraceVisualization = true;
        } else {
            this.fTraceVisualization = false;
            this.fCachedStoppedEvent = null;
        }
    }

    public void flushCache(IDMContext context) {
        this.fMICommandCache.reset(context);
        this.fFramesCache.clear(context);
        this.fCachedStoppedEvent = null;
    }

    private abstract class FrameData
    implements IStack.IFrameDMData {
        private FrameData() {
        }

        protected abstract MIFrame getMIFrame();

        public IAddress getAddress() {
            String addr = this.getMIFrame().getAddress();
            if (addr == null || addr.length() == 0) {
                return new Addr32(0L);
            }
            if (addr.startsWith("0x")) {
                addr = addr.substring(2);
            }
            if (addr.length() <= 8) {
                return new Addr32(this.getMIFrame().getAddress());
            }
            return new Addr64(this.getMIFrame().getAddress());
        }

        public int getColumn() {
            return 0;
        }

        public String getFile() {
            return this.getMIFrame().getFile();
        }

        public int getLine() {
            return this.getMIFrame().getLine();
        }

        public String getFunction() {
            return this.getMIFrame().getFunction();
        }

        public String getModule() {
            return "";
        }

        public String toString() {
            return this.getMIFrame().toString();
        }
    }

    private class FrameDataFromMIStackFrameListInfo
    extends FrameData {
        private MIStackListFramesInfo fFrameDataCacheInfo;
        private int fFrameIndex;

        FrameDataFromMIStackFrameListInfo(MIStackListFramesInfo info, int index) {
            this.fFrameDataCacheInfo = info;
            this.fFrameIndex = index;
        }

        @Override
        protected MIFrame getMIFrame() {
            return this.fFrameDataCacheInfo.getMIFrames()[this.fFrameIndex];
        }
    }

    private class FrameDataFromStoppedEvent
    extends FrameData {
        private final MIStoppedEvent fEvent;

        FrameDataFromStoppedEvent(MIStoppedEvent event) {
            this.fEvent = event;
        }

        @Override
        protected MIFrame getMIFrame() {
            return this.fEvent.getFrame();
        }
    }

    private class FramesCache
    extends HashMap<String, FramesCacheInfo> {
        private FramesCache() {
        }

        public void clear(IDMContext context) {
            IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
            if (execDmc != null) {
                this.remove(execDmc.getThreadId());
            } else {
                this.clear();
            }
        }

        public FramesCacheInfo getThreadFramesCache(String threadId) {
            FramesCacheInfo info = (FramesCacheInfo)this.get(threadId);
            if (info == null) {
                info = new FramesCacheInfo();
                this.put(threadId, info);
            }
            return info;
        }

        public FramesCacheInfo update(String threadId, int stackDepth, int maxRequestedStackDepth) {
            FramesCacheInfo info = this.getThreadFramesCache(threadId);
            info.setStackDepth(stackDepth, maxRequestedStackDepth);
            return info;
        }

        public FramesCacheInfo update(String threadId, MIStackListFramesInfo framesInfo) {
            FramesCacheInfo info = this.getThreadFramesCache(threadId);
            if (framesInfo != null) {
                int len = framesInfo.getMIFrames().length;
                int i = 0;
                while (i < len) {
                    info.updateFrameData(new FrameDataFromMIStackFrameListInfo(framesInfo, i));
                    ++i;
                }
            }
            return info;
        }
    }

    private static class FramesCacheInfo {
        private boolean limited = true;
        private int stackDepth = -1;
        private final List<FrameData> frames = new ArrayList<FrameData>();

        private FramesCacheInfo() {
        }

        public int getStackDepth(int maxDepth) {
            if (!this.limited) {
                return this.stackDepth;
            }
            if (maxDepth > 0 && this.stackDepth >= maxDepth) {
                return this.stackDepth;
            }
            return -1;
        }

        public void setStackDepth(int returned, int requested) {
            if (returned <= 0) {
                return;
            }
            if (returned < requested) {
                this.limited = false;
            } else if (requested <= 0) {
                this.limited = false;
            }
            if (returned > this.stackDepth) {
                this.stackDepth = returned;
            }
        }

        public int getValidStackDepth() {
            if (this.stackDepth <= 0) {
                return 5;
            }
            return this.stackDepth;
        }

        public void updateFrameData(FrameData frame) {
            try {
                int level = frame.getMIFrame().getLevel();
                if (this.stackDepth < level + 1) {
                    this.stackDepth = level + 1;
                }
                while (level >= this.frames.size()) {
                    this.frames.add(null);
                }
                this.frames.set(level, frame);
            }
            catch (Exception e) {
                GdbPlugin.log(e);
            }
        }

        public FrameData getFrameData(int level) {
            block3: {
                try {
                    if (level >= 0 && level < this.frames.size()) break block3;
                    return null;
                }
                catch (Exception e) {
                    GdbPlugin.log(e);
                    return null;
                }
            }
            return this.frames.get(level);
        }
    }

    protected static class MIFrameDMC
    extends AbstractDMContext
    implements IStack.IFrameDMContext {
        private final int fLevel;

        public MIFrameDMC(String sessionId, IRunControl.IExecutionDMContext execDmc, int level) {
            super(sessionId, new IDMContext[]{execDmc});
            this.fLevel = level;
        }

        public int getLevel() {
            return this.fLevel;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MIFrameDMC)) {
                return false;
            }
            return super.baseEquals(other) && ((MIFrameDMC)((Object)other)).fLevel == this.fLevel;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fLevel;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".frame[" + this.fLevel + "]";
        }
    }

    protected static class MIVariableDMC
    extends AbstractDMContext
    implements IStack.IVariableDMContext {
        private final Type fType;
        private final int fIndex;

        public MIVariableDMC(MIStack service, IStack.IFrameDMContext frame, Type type, int index) {
            super((IDsfService)service, new IDMContext[]{frame});
            this.fIndex = index;
            this.fType = type;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Type getType() {
            return this.fType;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MIVariableDMC)) {
                return false;
            }
            return super.baseEquals(other) && ((MIVariableDMC)((Object)other)).fType == this.fType && ((MIVariableDMC)((Object)other)).fIndex == this.fIndex;
        }

        public int hashCode() {
            int typeFactor = 0;
            if (this.fType == Type.LOCAL) {
                typeFactor = 2;
            } else if (this.fType == Type.ARGUMENT) {
                typeFactor = 3;
            } else if (this.fType == Type.RETURN_VALUES) {
                typeFactor = 4;
            }
            return super.baseHashCode() ^ typeFactor ^ this.fIndex;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".variable(" + (Object)((Object)this.fType) + ")[" + this.fIndex + "]";
        }

        public static enum Type {
            ARGUMENT,
            LOCAL,
            RETURN_VALUES;

        }
    }

    private static class VariableData
    implements IStack.IVariableDMData {
        private MIArg fMIArg;

        public VariableData(MIArg arg) {
            this.fMIArg = arg;
        }

        public String getName() {
            return this.fMIArg.getName();
        }

        public String getValue() {
            return this.fMIArg.getValue();
        }

        public String toString() {
            return this.fMIArg.toString();
        }
    }
}

