/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.doctools;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.text.doctools.Messages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwnershipListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class EditorReopener
implements IDocCommentOwnershipListener {
    @Override
    public void ownershipChanged(IResource resource, boolean recursive, IDocCommentOwner old, IDocCommentOwner newOwner) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                IEditorPart[] parts = this.getEditorsToRepon(window, resource);
                if (this.queryIfNeeded(window.getShell(), parts)) {
                    this.reopenEditors(window, parts);
                }
            }
            catch (CoreException ce) {
                CUIPlugin.log(ce);
            }
        }
    }

    @Override
    public void workspaceOwnershipChanged(IDocCommentOwner old, IDocCommentOwner newOwner) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                IEditorPart[] parts = this.getEditorsToRepon(window, null);
                if (this.queryIfNeeded(window.getShell(), parts)) {
                    this.reopenEditors(window, parts);
                }
            }
            catch (CoreException ce) {
                CUIPlugin.log(ce);
            }
        }
    }

    private IEditorPart[] getEditorsToRepon(IWorkbenchWindow window, IResource resource) {
        ArrayList<IEditorPart> needReopening = new ArrayList<IEditorPart>();
        if (window.getActivePage() != null) {
            IEditorReference[] es = window.getActivePage().getEditorReferences();
            int i = 0;
            while (i < es.length) {
                IEditorPart part = es[i].getEditor(false);
                if (part != null) {
                    IEditorInput iei = part.getEditorInput();
                    if (resource != null) {
                        if (iei instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)iei).getFile();
                            IProject project = resource.getProject();
                            if (file.getProject().equals((Object)project) && CoreModel.hasCNature((IProject)project)) {
                                needReopening.add(part);
                            }
                        }
                    } else if (iei instanceof ITranslationUnitEditorInput || iei instanceof IFileEditorInput) {
                        needReopening.add(part);
                    }
                }
                ++i;
            }
        }
        return needReopening.toArray(new IEditorPart[needReopening.size()]);
    }

    private boolean queryIfNeeded(Shell shell, IEditorPart[] editorParts) throws CoreException {
        String msg;
        String title;
        boolean saveAndReopen;
        boolean anyUnsaved = false;
        int j = 0;
        while (j < editorParts.length) {
            if (editorParts[j].isSaveOnCloseNeeded()) {
                anyUnsaved = true;
            }
            ++j;
        }
        boolean bl = saveAndReopen = !anyUnsaved;
        if (anyUnsaved && MessageDialog.openQuestion((Shell)shell, (String)(title = Messages.EditorReopener_ShouldSave_Title), (String)(msg = Messages.EditorReopener_ShouldSave_Message))) {
            saveAndReopen = true;
        }
        return saveAndReopen;
    }

    private void reopenEditors(final IWorkbenchWindow window, final IEditorPart[] editorParts) throws CoreException {
        WorkbenchJob job = new WorkbenchJob(Messages.EditorReopener_ReopenJobStart){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IEditorPart oldActive = window.getActivePage().getActiveEditor();
                IEditorPart newActive = null;
                int j = 0;
                while (j < editorParts.length) {
                    IEditorPart oldPart = editorParts[j];
                    if (oldPart.isDirty()) {
                        oldPart.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    window.getActivePage().closeEditor(oldPart, false);
                    IEditorInput oldInput = oldPart.getEditorInput();
                    try {
                        IEditorPart newPart = null;
                        if (oldInput instanceof IFileEditorInput) {
                            newPart = EditorUtility.openInEditor(((IFileEditorInput)oldInput).getFile());
                        } else if (oldInput instanceof ExternalEditorInput) {
                            ExternalEditorInput eei = (ExternalEditorInput)oldInput;
                            ICElement element = CoreModel.getDefault().create(eei.getMarkerResource());
                            newPart = EditorUtility.openInEditor(eei.getPath(), element);
                        }
                        if (oldPart == oldActive) {
                            newActive = newPart;
                        }
                    }
                    catch (PartInitException pie) {
                        CUIPlugin.log(pie);
                    }
                    catch (CModelException cme) {
                        CUIPlugin.log(cme);
                    }
                    ++j;
                }
                if (newActive != null) {
                    window.getActivePage().activate(newActive);
                }
                return new Status(0, "org.eclipse.cdt.ui", Messages.EditorReopener_ReopenJobComplete);
            }
        };
        job.schedule();
    }
}

