/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.index2;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.AddSourceModuleRequest;
import org.eclipse.dltk.internal.core.index2.ExternalProjectFragmentRequest;
import org.eclipse.dltk.internal.core.index2.ProgressJob;
import org.eclipse.dltk.internal.core.index2.ProjectRequest;
import org.eclipse.dltk.internal.core.index2.ReconcileSourceModuleRequest;
import org.eclipse.dltk.internal.core.index2.RemoveContainerRequest;
import org.eclipse.dltk.internal.core.index2.RemoveSourceModuleRequest;
import org.eclipse.osgi.util.NLS;

public class ProjectIndexer2
implements IProjectIndexer {
    private final IndexManager jobManager = ModelManager.getModelManager().getIndexManager();
    private final ProgressJob progressJob = new ProgressJob(this.jobManager);

    @Override
    public void indexLibrary(IScriptProject project, IPath path) {
        try {
            IProjectFragment fragment = project.findProjectFragment(path);
            if (fragment != null) {
                ExternalProjectFragmentRequest request = new ExternalProjectFragmentRequest(this, fragment, this.progressJob);
                this.jobManager.requestIfNotWaiting(request);
            } else {
                DLTKCore.warn(NLS.bind((String)"Unknown project fragment: ''{0}''", (Object)path));
            }
        }
        catch (Exception e) {
            DLTKCore.error(NLS.bind((String)"An exception is thrown while indexing: ''{0}''", (Object)path), e);
        }
    }

    @Override
    public void indexProject(IScriptProject project) {
        ProjectRequest request = new ProjectRequest(this, project, this.progressJob);
        this.jobManager.requestIfNotWaiting(request);
    }

    @Override
    public void indexProjectFragment(IScriptProject project, IPath path) {
        AbstractIndexRequest request;
        IProjectFragment fragmentToIndex = null;
        try {
            IProjectFragment[] fragments;
            IProjectFragment[] iProjectFragmentArray = fragments = project.getProjectFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment fragment = iProjectFragmentArray[n2];
                if (fragment.getPath().equals((Object)path)) {
                    fragmentToIndex = fragment;
                    break;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error("Failed to index fragment:" + path, (Throwable)((Object)e));
        }
        if (fragmentToIndex == null || !fragmentToIndex.isExternal() || fragmentToIndex.isBuiltin()) {
            request = new ProjectRequest(this, project, this.progressJob);
            this.jobManager.requestIfNotWaiting(request);
            return;
        }
        request = new ExternalProjectFragmentRequest(this, fragmentToIndex, this.progressJob);
        this.jobManager.requestIfNotWaiting(request);
    }

    @Override
    public void indexSourceModule(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        this.jobManager.request(new AddSourceModuleRequest(this, module, this.progressJob));
    }

    @Override
    public void reconciled(ISourceModule workingCopy, IDLTKLanguageToolkit toolkit) {
        this.jobManager.request(new ReconcileSourceModuleRequest(this, workingCopy, this.progressJob));
    }

    @Override
    public void removeLibrary(IScriptProject project, IPath path) {
        RemoveContainerRequest request = new RemoveContainerRequest(this, path, this.progressJob);
        this.jobManager.requestIfNotWaiting(request);
    }

    @Override
    public void removeProject(IPath projectPath) {
        RemoveContainerRequest request = new RemoveContainerRequest(this, projectPath, this.progressJob);
        this.jobManager.requestIfNotWaiting(request);
    }

    @Override
    public void removeProjectFragment(IScriptProject project, IPath path) {
        if (path.equals((Object)project.getPath())) {
            return;
        }
        RemoveContainerRequest request = new RemoveContainerRequest(this, path, this.progressJob);
        this.jobManager.requestIfNotWaiting(request);
    }

    @Override
    public void removeSourceModule(IScriptProject project, String path) {
        this.jobManager.request(new RemoveSourceModuleRequest(this, project.getPath(), path, this.progressJob));
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public boolean wantRefreshOnStart() {
        return true;
    }

    public void request(AbstractIndexRequest request) {
        this.jobManager.request(request);
    }
}

