/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.NewOrgUnitDialog;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CreateOrgUnitAction
extends Action {
    private final AdminBroker adminBroker;
    private final TableViewer tableViewer;
    private final PropertiesForm form;

    public CreateOrgUnitAction(String title, AdminBroker adminBroker, TableViewer tableViewer, PropertiesForm form) {
        super(title);
        this.adminBroker = adminBroker;
        this.tableViewer = tableViewer;
        this.form = form;
    }

    public void run() {
        ACOrgUnitId newUserId = null;
        try {
            Shell shell = Display.getCurrent().getActiveShell();
            NewOrgUnitDialog newUserDialog = new NewOrgUnitDialog(shell, this.getInputFieldNames());
            if (newUserDialog.open() == 1) {
                return;
            }
            boolean hasEmptyField = false;
            for (String fieldName : this.getInputFieldNames()) {
                if (!StringUtils.isBlank((String)newUserDialog.getFieldValue(fieldName))) continue;
                hasEmptyField = true;
                this.openEmptyInputDialog(shell, fieldName);
                break;
            }
            if (hasEmptyField) {
                return;
            }
            Map<String, String> fieldValues = this.getFieldValues(newUserDialog);
            String primaryName = fieldValues.get(this.getPrimaryFieldName());
            if (this.orgUnitExists(primaryName)) {
                this.openOrgUnitExistsDialog(shell, primaryName);
            } else {
                newUserId = this.createOrgUnit(fieldValues);
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        if (newUserId != null) {
            this.tableViewer.refresh();
            TableItem[] items = this.tableViewer.getTable().getItems();
            int index = -1;
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ACOrgUnit orgUnit;
                TableItem tableItem = tableItemArray[n2];
                if (ACOrgUnit.class.isInstance(tableItem.getData()) && (orgUnit = (ACOrgUnit)ACOrgUnit.class.cast(tableItem.getData())).getId().equals(newUserId)) {
                    index = this.tableViewer.getTable().indexOf(tableItem);
                    this.form.setInput((EObject)orgUnit);
                    break;
                }
                ++n2;
            }
            this.form.getTableViewer().refresh();
            this.tableViewer.getTable().deselectAll();
            this.tableViewer.getTable().select(index);
        }
    }

    private Map<String, String> getFieldValues(NewOrgUnitDialog newUserDialog) {
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        for (String fieldName : this.getInputFieldNames()) {
            fieldValues.put(fieldName, newUserDialog.getFieldValue(fieldName));
        }
        return fieldValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean orgUnitExists(String username) {
        try {
            ACUser user;
            Iterator iterator = this.adminBroker.getUsers().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(user = (ACUser)iterator.next()).getName().equals(username));
            return true;
        }
        catch (ESException eSException) {
            return false;
        }
    }

    private void openOrgUnitExistsDialog(Shell shell, String username) {
        MessageDialog.openInformation((Shell)shell, (String)Messages.UserTabContent_User_Exists, (String)(String.valueOf(Messages.UserTabContent_User_With_Given_Name) + "'" + username + "'" + Messages.UserTabContent_Already_Exists));
    }

    private void openEmptyInputDialog(Shell shell, String fieldName) {
        MessageDialog.openWarning((Shell)shell, (String)Messages.CreateOrgUnitAction_EmptyInput, (String)MessageFormat.format(Messages.CreateOrgUnitAction_EmptyField, fieldName));
    }

    public AdminBroker getAdminBroker() {
        return this.adminBroker;
    }

    protected abstract String getPrimaryFieldName();

    protected abstract String orgUnitName();

    protected abstract ACOrgUnitId createOrgUnit(Map<String, String> var1) throws ESException;

    protected abstract Set<String> getInputFieldNames();
}

