/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.IFontPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.exported.ILabelPropertiesHandler;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

public class PropertiesHandler
implements IContentPropertiesHandler,
ILabelPropertiesHandler,
ISelectionPropertiesHandler,
IFontPropertiesHandler {
    private static final String SEPARATOR = "::";
    private static final String CUSTOM_PROPERTIES = "resources/customproperties.efacet";
    private static final String CUSTOM = "CustomizedEObject";
    private static final String TT_CUSTOM = "CustomizedToolTipEObject";
    private static final String IMAGE = "image";
    private static final String LABEL = "label";
    private static final String BACKGROUND = "background";
    private static final String FOREGROUND = "foreground";
    private static final String FONT = "fontName";
    private static final String FONT_SIZE = "fontSize";
    private static final String IS_BOLD = "isBold";
    private static final String IS_ITALIC = "isItalic";
    private static final String IS_VISIBLE = "isVisible";
    private static final String IS_UNDERLINED = "isUnderlined";
    private static final String IS_STRUCKTHROUGH = "isStruckthrough";
    private static final String TOP_L_OVERLAY = "topLeftOverlay";
    private static final String TOP_M_OVERLAY = "topMiddleOverlay";
    private static final String TOP_R_OVERLAY = "topRightOverlay";
    private static final String BOTTOM_L_OVERLAY = "bottomLeftOverlay";
    private static final String BOTTOM_M_OVERLAY = "bottomMiddleOverlay";
    private static final String BOTTOM_R_OVERLAY = "bottomRightOverlay";
    private static final String SELECTION = "selection";
    private static final String CHILDREN = "children";
    private static final String TEXT = "text";
    private static final String TIME_DISPLAYED = "timeDisplayed";
    private static final String DISPLAY_DELAY = "displayDelayTime";
    private static final String SHADOW = "shadow";
    private static final String ALIGNMENT = "alignment";
    private final Resource resource;
    private final Map<String, FacetOperation> map = new HashMap<String, FacetOperation>();

    @Deprecated
    public PropertiesHandler(ResourceSet resourceSet) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        URI propertiesUri = URI.createPlatformPluginURI((String)bundleName, (boolean)true);
        propertiesUri = propertiesUri.appendSegments(CUSTOM_PROPERTIES.split("/"));
        this.resource = resourceSet.getResource(propertiesUri, true);
    }

    public PropertiesHandler(ICustomizationManager customizationMgr) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        URI propertiesUri = URI.createPlatformPluginURI((String)bundleName, (boolean)true);
        propertiesUri = propertiesUri.appendSegments(CUSTOM_PROPERTIES.split("/"));
        ResourceSet resourceSet = customizationMgr.getResourceSet();
        this.resource = resourceSet.getResource(propertiesUri, true);
        FacetSet facetSet = (FacetSet)this.resource.getContents().get(0);
        IFacetManager facetManager = customizationMgr.getFacetManager();
        List facetSets = facetManager.getManagedFacetSets();
        facetSets.add(facetSet);
    }

    private FacetOperation getPropertyByName(String facetName, String propertyName) {
        FacetSet facetSet;
        Facet facet;
        ETypedElement eTypedElement;
        String key = String.valueOf(facetName) + SEPARATOR + propertyName;
        FacetOperation result = this.map.get(key);
        if (result == null && (eTypedElement = FacetUtils.getETypedElement((Facet)(facet = FacetUtils.getFacet((Collection)FacetUtils.getFacets((FacetSet)(facetSet = (FacetSet)this.resource.getContents().get(0))), (String)facetName)), (String)propertyName, ETypedElement.class)) instanceof FacetOperation) {
            result = (FacetOperation)eTypedElement;
            this.map.put(key, result);
        }
        return result;
    }

    public FacetOperation getImageProperty() {
        return this.getPropertyByName(CUSTOM, IMAGE);
    }

    public FacetOperation getLabelProperty() {
        return this.getPropertyByName(CUSTOM, LABEL);
    }

    public FacetOperation getBackgroundProperty() {
        return this.getPropertyByName(CUSTOM, BACKGROUND);
    }

    public FacetOperation getForegroundProperty() {
        return this.getPropertyByName(CUSTOM, FOREGROUND);
    }

    public FacetOperation getFontNameProperty() {
        return this.getPropertyByName(CUSTOM, FONT);
    }

    public FacetOperation getFontSizeProperty() {
        return this.getPropertyByName(CUSTOM, FONT_SIZE);
    }

    public FacetOperation getIsBoldProperty() {
        return this.getPropertyByName(CUSTOM, IS_BOLD);
    }

    public FacetOperation getIsItalicProperty() {
        return this.getPropertyByName(CUSTOM, IS_ITALIC);
    }

    public FacetOperation getIsVisible() {
        return this.getPropertyByName(CUSTOM, IS_VISIBLE);
    }

    public FacetOperation getIsUnderlinedProperty() {
        return this.getPropertyByName(CUSTOM, IS_UNDERLINED);
    }

    public FacetOperation getIsStruckthroughProperty() {
        return this.getPropertyByName(CUSTOM, IS_STRUCKTHROUGH);
    }

    public FacetOperation getTopLeftOverlayProperty() {
        return this.getPropertyByName(CUSTOM, TOP_L_OVERLAY);
    }

    public FacetOperation getTopMiddleOverlayProperty() {
        return this.getPropertyByName(CUSTOM, TOP_M_OVERLAY);
    }

    public FacetOperation getTopRightOverlayProperty() {
        return this.getPropertyByName(CUSTOM, TOP_R_OVERLAY);
    }

    public FacetOperation getBottomLeftOverlayProperty() {
        return this.getPropertyByName(CUSTOM, BOTTOM_L_OVERLAY);
    }

    public FacetOperation getBottomMiddleOverlayProperty() {
        return this.getPropertyByName(CUSTOM, BOTTOM_M_OVERLAY);
    }

    public FacetOperation getBottomRightOverlayProperty() {
        return this.getPropertyByName(CUSTOM, BOTTOM_R_OVERLAY);
    }

    public FacetOperation getSelectionProperty() {
        return this.getPropertyByName(CUSTOM, SELECTION);
    }

    public FacetOperation getToolTipTextProperty() {
        return this.getPropertyByName(TT_CUSTOM, TEXT);
    }

    public FacetOperation getToolTipImageProperty() {
        return this.getPropertyByName(TT_CUSTOM, IMAGE);
    }

    public FacetOperation getToolTipFontNameProperty() {
        return this.getPropertyByName(TT_CUSTOM, FONT);
    }

    public FacetOperation getToolTipFontSizeProperty() {
        return this.getPropertyByName(TT_CUSTOM, FONT_SIZE);
    }

    public FacetOperation getToolTipIsBoldProperty() {
        return this.getPropertyByName(TT_CUSTOM, IS_BOLD);
    }

    public FacetOperation getToolTipIsItalicProperty() {
        return this.getPropertyByName(TT_CUSTOM, IS_ITALIC);
    }

    public FacetOperation getToolTipBackgroundProperty() {
        return this.getPropertyByName(TT_CUSTOM, BACKGROUND);
    }

    public FacetOperation getToolTipForegroundProperty() {
        return this.getPropertyByName(TT_CUSTOM, FOREGROUND);
    }

    public FacetOperation getToolTipTopLeftOverlayProperty() {
        return this.getPropertyByName(TT_CUSTOM, TOP_L_OVERLAY);
    }

    public FacetOperation getToolTipTopMiddleOverlayProperty() {
        return this.getPropertyByName(TT_CUSTOM, TOP_M_OVERLAY);
    }

    public FacetOperation getToolTipTopRightOverlayProperty() {
        return this.getPropertyByName(TT_CUSTOM, TOP_R_OVERLAY);
    }

    public FacetOperation getToolTipBottomLeftOverlayProperty() {
        return this.getPropertyByName(TT_CUSTOM, BOTTOM_L_OVERLAY);
    }

    public FacetOperation getToolTipBottomMiddleOverlayProperty() {
        return this.getPropertyByName(TT_CUSTOM, BOTTOM_M_OVERLAY);
    }

    public FacetOperation getToolTipBottomRightOverlayProperty() {
        return this.getPropertyByName(TT_CUSTOM, BOTTOM_R_OVERLAY);
    }

    public FacetOperation getToolTipTimeDisplayedProperty() {
        return this.getPropertyByName(TT_CUSTOM, TIME_DISPLAYED);
    }

    public FacetOperation getToolTipDisplayDelayTimeProperty() {
        return this.getPropertyByName(TT_CUSTOM, DISPLAY_DELAY);
    }

    public FacetOperation getToolTipAlignmentProperty() {
        return this.getPropertyByName(TT_CUSTOM, ALIGNMENT);
    }

    public FacetOperation getToolTipShadowProperty() {
        return this.getPropertyByName(TT_CUSTOM, SHADOW);
    }

    public FacetOperation getChildren() {
        return this.getPropertyByName(CUSTOM, CHILDREN);
    }
}

