/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.IFacetManagerProvider2;
import org.eclipse.emf.facet.efacet.ui.internal.actions.ShortcutFacetSetAction;
import org.eclipse.emf.facet.util.ui.internal.exported.handler.HandlerUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoadFacetSetShortcutsMenuUtils {
    private LoadFacetSetShortcutsMenuUtils() {
    }

    public static IContributionItem[] getFacetSetItemsFromCurrentPart() {
        IFacetManagerProvider2 facetMgrPrv = LoadFacetSetShortcutsMenuUtils.getProviderFromCurrentPart(IFacetManagerProvider2.class);
        return LoadFacetSetShortcutsMenuUtils.getFacetSetItems(facetMgrPrv);
    }

    public static IContributionItem[] getFacetSetItemsFromCurrentEditor() {
        IFacetManagerProvider2 facetMgrPrv = LoadFacetSetShortcutsMenuUtils.getProviderFromCurrentEditor(IFacetManagerProvider2.class);
        return LoadFacetSetShortcutsMenuUtils.getFacetSetItems(facetMgrPrv);
    }

    private static IContributionItem[] getFacetSetItems(IFacetManagerProvider2 facetMgrPrv) {
        ArrayList<ActionContributionItem> menuList = new ArrayList<ActionContributionItem>();
        if (facetMgrPrv != null) {
            List<IFacetManagerProvider2.IFacetSetShortcut> shortcuts = facetMgrPrv.getFacetSetShortcuts();
            IFacetManager facetManager = facetMgrPrv.getFacetManager();
            for (IFacetManagerProvider2.IFacetSetShortcut shortcut : shortcuts) {
                ActionContributionItem action = LoadFacetSetShortcutsMenuUtils.createFacetSetMenuItem(shortcut, facetManager);
                menuList.add(action);
            }
        }
        return menuList.toArray(new IContributionItem[menuList.size()]);
    }

    public static <T> T getProviderFromCurrentPart(Class<T> providerType) {
        IWorkbenchPart activePart = HandlerUtils.getActivePart();
        return LoadFacetSetShortcutsMenuUtils.getProviderFromCurrentPart(providerType, activePart);
    }

    public static <T> T getProviderFromCurrentEditor(Class<T> providerType) {
        IEditorPart activeEditor;
        T result = null;
        IWorkbenchPage activePage = HandlerUtils.getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) != null) {
            result = LoadFacetSetShortcutsMenuUtils.getProviderFromCurrentPart(providerType, (IWorkbenchPart)activeEditor);
        }
        return result;
    }

    private static <T> T getProviderFromCurrentPart(Class<T> providerType, IWorkbenchPart activePart) {
        Object adapt;
        Object result = null;
        if (activePart != null && (adapt = activePart.getAdapter(providerType)) != null) {
            Object adapted;
            result = adapted = adapt;
        }
        return (T)result;
    }

    private static ActionContributionItem createFacetSetMenuItem(IFacetManagerProvider2.IFacetSetShortcut shortcut, IFacetManager facetManager) {
        FacetSet facetSet = shortcut.getFacetSet();
        String facetSetId = facetSet.getName();
        ShortcutFacetSetAction action = new ShortcutFacetSetAction(facetSetId, shortcut.getLabel(), shortcut.getIcon(), facetManager);
        List activeFacetSets = facetManager.getManagedFacetSets();
        return LoadFacetSetShortcutsMenuUtils.createMenuItem(facetSetId, activeFacetSets, action);
    }

    public static ActionContributionItem createMenuItem(String itemId, List<? extends FacetSet> activeFacetSets, Action newAction) {
        for (FacetSet facetSet : activeFacetSets) {
            String facetSetName = facetSet.getName();
            if (!facetSetName.equals(itemId)) continue;
            newAction.setChecked(true);
            break;
        }
        return new ActionContributionItem((IAction)newAction);
    }
}

