/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui.internal.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerProvider;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialog;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogFactory;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IQuestionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LoadFacetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFacetManagerProvider facetMgrProvider;
        IFacetManager facetManager;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null && (facetManager = (facetMgrProvider = (IFacetManagerProvider)activePart.getAdapter(IFacetManagerProvider.class)).getFacetManager()) != null) {
            ResourceSet resourceSet = facetManager.getResourceSet();
            IFacetSetCatalogManager catalog = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet);
            HashSet<FacetSet> availableFS = new HashSet<FacetSet>();
            availableFS.addAll(catalog.getRegisteredFacetSets());
            IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, IQuestionDialog>(){

                public void committed(List<FacetSet> result, Boolean precommitResult) {
                    ArrayList toBeRemoved = new ArrayList();
                    toBeRemoved.addAll(facetManager.getManagedFacetSets());
                    toBeRemoved.removeAll(result);
                    facetManager.getManagedFacetSets().removeAll(toBeRemoved);
                    facetManager.getManagedFacetSets().addAll(result);
                }

                public IQuestionDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                    return null;
                }
            };
            Shell shell = activePart.getSite().getShell();
            IFacetSetSelectionDialog<IQuestionDialog> dialog = IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(availableFS, Integer.MAX_VALUE, true, callback, shell);
            dialog.setSelectedFacetSets(facetManager.getManagedFacetSets());
        }
        return null;
    }
}

