/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software) - Bug 345730 - Deleting an element in the model breaks the table
 *******************************************************************************/
package org.eclipse.emf.facet.util.junit.core.internal.exported;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.facet.util.junit.core.internal.Activator;
import org.junit.After;
import org.junit.Before;
import org.osgi.framework.Bundle;

/**
 * This class has be extended by test classes that have to listen to the Eclise log.
 */
public abstract class AbstractLogListenerTest {

	private ILogListener listener;
	private final List<IStatus> loggedStatus = new ArrayList<IStatus>();

	/**
	 * This methods add a listener to the Eclipse log.
	 */
	@Before
	public void initLogListener() {
		final List<IStatus> finalLoggedStatus = this.loggedStatus;
		this.listener = new ILogListener() {

			public void logging(final IStatus status, final String plugin) {
				if (status.getSeverity() != IStatus.OK && status.getSeverity() != IStatus.INFO) {
					finalLoggedStatus
							.add(status);
				}

			}
		};
		for (Bundle bundle : getPluginsToListen()) {
			Platform.getLog(bundle).addLogListener(this.listener);
		}
	}
	
	/**
	 * This method checks that no error or warning have been logged and remove the listener. 
	 * @throws CoreException
	 */
	@After
	public void checkLogListener() throws CoreException {
		for (Bundle bundle : this.getPluginsToListen()) {
			Platform.getLog(bundle).removeLogListener(this.listener);
		}
		if (this.loggedStatus.size() > 0) {
			final Bundle bundle = Activator.getDefault().getBundle();
			final String bundleName = bundle.getSymbolicName();
			final IStatus multiStatus = new MultiStatus(bundleName, IStatus.ERROR,
					this.loggedStatus.toArray(new IStatus[] {}),
					"Some error or warning messages have been logged.", new Exception()); //$NON-NLS-1$
			throw new CoreException(multiStatus);
		}
	}

	/**
	 * This methods the bundle that have to be watched by the log listener.
	 * @return
	 */
	protected abstract Bundle[] getPluginsToListen();
	
}
