/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.dataprovider;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;

class GridElement
implements IGridElement {
    private Row row;
    private final Column column;
    private final ITableWidgetInternal controller;

    public GridElement(Row row, Column column) {
        this(row, column, null);
    }

    public GridElement(Row row, Column column, ITableWidgetInternal controller) {
        this.row = row;
        this.column = column;
        this.controller = controller;
    }

    public Object getElement() {
        EObject result = null;
        if (this.row != null) {
            result = this.row.getElement();
        }
        return result;
    }

    public Column getColumn() {
        return this.column;
    }

    public Row getRow() {
        return this.row;
    }

    public String toString() {
        FeatureColumn featureColumn;
        ETypedElement typedElement;
        String string = "";
        EObject element = this.row.getElement();
        if (this.column instanceof FeatureColumn && (typedElement = (featureColumn = (FeatureColumn)this.column).getFeature()) instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)typedElement;
            try {
                this.controller.getCustomizationEngine().getResourceSet();
                IFacetManager facetManager = this.controller.getFacetContext();
                Object value = facetManager.getOrInvoke(element, (ETypedElement)structuralFeature, Object.class);
                ICustomizedLabelProvider labelProvider = this.controller.getTableLabelProvider();
                string = labelProvider.getText(value);
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return string;
    }
}

