/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.DelegatedTableEditor;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.TableEditorInput;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.IDelegatedTableEditorFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class DelegatedTableEditorFactory
implements IDelegatedTableEditorFactory {
    public boolean canHandle(IEditorInput input) {
        boolean canHandle = false;
        if (input instanceof TableEditorInput) {
            canHandle = true;
        } else if (input instanceof FileEditorInput) {
            canHandle = DelegatedTableEditorFactory.canHandle((FileEditorInput)input);
        }
        return canHandle;
    }

    private static boolean canHandle(FileEditorInput input) {
        boolean canHandle = false;
        URI uri = URI.createPlatformResourceURI((String)input.getFile().getFullPath().toString(), (boolean)true);
        if (uri != null) {
            ResourceSetImpl rSet = new ResourceSetImpl();
            Resource resource = rSet.getResource(uri, true);
            try {
                resource.load(Collections.EMPTY_MAP);
                for (EObject eObject : resource.getContents()) {
                    if (!(eObject instanceof Table)) continue;
                    canHandle = true;
                    break;
                }
            }
            catch (IOException e) {
                Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                canHandle = false;
            }
        }
        return canHandle;
    }

    public EditorPart createEditor() {
        return new DelegatedTableEditor();
    }
}

