/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.composite;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class CachedLabelProvider
implements ILabelProvider {
    private final Map<Object, Image> imageCache = new HashMap<Object, Image>();
    private final Map<Object, String> textCache = new HashMap<Object, String>();
    private final ILabelProvider delegate;

    public CachedLabelProvider(ILabelProvider delegate) {
        this.delegate = delegate;
    }

    public Image getImage(Object element) {
        if (!this.imageCache.containsKey(element)) {
            this.imageCache.put(element, this.delegate.getImage(element));
        }
        return this.imageCache.get(element);
    }

    public String getText(Object element) {
        if (!this.textCache.containsKey(element)) {
            this.textCache.put(element, this.delegate.getText(element));
        }
        return this.textCache.get(element);
    }

    public void dispose() {
        this.imageCache.clear();
        this.textCache.clear();
        this.delegate.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegate.isLabelProperty(element, property);
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegate.removeListener(listener);
    }
}

