/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit.ui.provider;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.emf.parsley.util.EmfParsleyUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class ViewerContentProvider
extends AdapterFactoryContentProvider {
    private PolymorphicDispatcher<Object> childrenDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"children", (int)1, (int)1, (Object)((Object)this));
    private PolymorphicDispatcher<Object> elementsDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"elements", (int)1, (int)1, (Object)((Object)this));
    private Set<Object> customElementsParents = new HashSet<Object>();

    public ViewerContentProvider() {
        this(null);
    }

    public ViewerContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Inject
    public void setAdapterFactory(AdapterFactory adapterFactory) {
        super.setAdapterFactory(adapterFactory);
    }

    public boolean hasChildren(Object element) {
        super.hasChildren(element);
        return this.getChildren(element).length > 0;
    }

    public List<Object> children(Object o) {
        return null;
    }

    public List<Object> elements(Object o) {
        return null;
    }

    public Object[] getChildren(Object element) {
        Object children = this.childrenDispatcher.invoke(new Object[]{element});
        if (children != null) {
            return EmfParsleyUtil.ensureCollection(children).toArray();
        }
        return super.getChildren(element);
    }

    public Object[] getElements(Object element) {
        Object polymorphicElements = this.elementsDispatcher.invoke(new Object[]{element});
        if (polymorphicElements != null) {
            Object[] elements = EmfParsleyUtil.ensureCollection(polymorphicElements).toArray();
            this.customElementsParents.clear();
            this.addListenersToTheModel(elements, element);
            return elements;
        }
        return super.getElements(element);
    }

    protected void addListenersToTheModel(Object[] elements, Object main) {
        this.addListenersToTheModel(elements);
        if (elements.length == 0) {
            Object[] defaultElements = super.getElements(main);
            this.addListenersToTheModel(defaultElements);
            Object[] objectArray = defaultElements;
            int n = defaultElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.customElementsParents.add(object);
                ++n2;
            }
        }
    }

    protected void addListenersToTheModel(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.addListenersToTheModel(object);
            ++n2;
        }
    }

    protected void addListenersToTheModel(Object object) {
        Object parent = this.getParent(object);
        while (parent != null) {
            this.customElementsParents.add(parent);
            parent = this.getParent(parent);
        }
    }

    public Object getParent(Object object) {
        Object parent = super.getParent(object);
        if (Objects.equal((Object)parent, (Object)object)) {
            return null;
        }
        return parent;
    }

    public void notifyChanged(Notification notification) {
        if (this.viewerRefresh == null) {
            this.viewerRefresh = new ViewerContentProviderViewerRefresh(this.viewer, this.customElementsParents);
        }
        super.notifyChanged(notification);
    }

    public static class ViewerContentProviderViewerRefresh
    extends AdapterFactoryContentProvider.ViewerRefresh {
        private Viewer viewer;
        private Set<Object> customElementsParents;

        public ViewerContentProviderViewerRefresh(Viewer viewer, Set<Object> customElementsParents) {
            super(viewer);
            this.viewer = viewer;
            this.customElementsParents = customElementsParents;
        }

        protected void refresh(IViewerNotification notification) {
            if (this.viewer instanceof StructuredViewer) {
                StructuredViewer structuredViewer = (StructuredViewer)this.viewer;
                Object element = notification.getElement();
                if (this.customElementsParents.contains(element)) {
                    structuredViewer.refresh(notification.isLabelUpdate());
                    return;
                }
            }
            super.refresh(notification);
        }
    }
}

