/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.internal.viewers;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.util.EmfParsleyUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class GenericFeatureViewerComparator
extends ViewerComparator {
    private int propertyIndex = 0;
    private int direction = 0;
    private List<EStructuralFeature> features;

    public void init(List<EStructuralFeature> features) {
        this.features = features;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public void setPropertyIndex(int column) {
        if (column == this.propertyIndex) {
            switch (this.direction) {
                case 0: {
                    this.direction = 128;
                    break;
                }
                case 128: {
                    this.direction = 1024;
                    break;
                }
                default: {
                    this.direction = 0;
                    break;
                }
            }
        } else {
            this.propertyIndex = column;
            this.direction = 128;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        EObject p1 = (EObject)e1;
        EObject p2 = (EObject)e2;
        if (this.direction == 0) {
            return 0;
        }
        EStructuralFeature feature = this.features.get(this.propertyIndex);
        int rc = this.compareValue(p1, p2, feature);
        if (this.direction == 1024) {
            rc = -rc;
        }
        return rc;
    }

    protected int compareValue(EObject p1, EObject p2, EStructuralFeature feature) {
        Object value1 = p1.eGet(feature);
        Object value2 = p2.eGet(feature);
        return EmfParsleyUtil.compareValues(value1, value2);
    }
}

