/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;

public class LfsPointer
implements Comparable<LfsPointer> {
    public static final String VERSION = "https://git-lfs.github.com/spec/v1";
    public static final String VERSION_LEGACY = "https://hawser.github.com/spec/v1";
    public static final int SIZE_THRESHOLD = 200;
    public static final String HASH_FUNCTION_NAME = "SHA-256".toLowerCase(Locale.ROOT).replace("-", "");
    private AnyLongObjectId oid;
    private long size;

    public LfsPointer(AnyLongObjectId oid, long size) {
        this.oid = oid;
        this.size = size;
    }

    public AnyLongObjectId getOid() {
        return this.oid;
    }

    public long getSize() {
        return this.size;
    }

    public void encode(OutputStream out) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintStream ps = new PrintStream(out, false, StandardCharsets.UTF_8.name());){
                ps.print("version ");
                ps.print("https://git-lfs.github.com/spec/v1\n");
                ps.print("oid " + HASH_FUNCTION_NAME + ":");
                ps.print(String.valueOf(this.oid.name()) + "\n");
                ps.print("size ");
                ps.print(String.valueOf(this.size) + "\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(StandardCharsets.UTF_8.name());
        }
    }

    @Nullable
    public static LfsPointer parseLfsPointer(InputStream in) throws IOException {
        block17: {
            boolean versionLine = false;
            LongObjectId id = null;
            long sz = -1L;
            Throwable throwable = null;
            Object var6_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String s = br.readLine();
                while (s != null) {
                    if (!s.startsWith("#") && s.length() != 0) {
                        if (s.startsWith("version") && s.length() > 8 && (s.substring(8).trim().equals(VERSION) || s.substring(8).trim().equals(VERSION_LEGACY))) {
                            versionLine = true;
                        } else if (s.startsWith("oid sha256:")) {
                            id = LongObjectId.fromString(s.substring(11).trim());
                        } else if (s.startsWith("size") && s.length() > 5) {
                            sz = Long.parseLong(s.substring(5).trim());
                        }
                    }
                    s = br.readLine();
                }
                if (!versionLine || id == null || sz <= -1L) break block17;
                return new LfsPointer(id, sz);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    public String toString() {
        return "LfsPointer: oid=" + this.oid.name() + ", size=" + this.size;
    }

    @Override
    public int compareTo(LfsPointer o) {
        int x = this.getOid().compareTo(o.getOid());
        if (x != 0) {
            return x;
        }
        return (int)(this.getSize() - o.getSize());
    }
}

