/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.SpecifiedOverride;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualOverride;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.resource.java.OverrideAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaOverrideContainer<PA extends JavaOverrideContainer.ParentAdapter, R extends Override_, S extends JavaSpecifiedOverride, V extends JavaVirtualOverride, A extends OverrideAnnotation & NestableAnnotation>
extends AbstractJavaContextModel<JpaContextModel>
implements JavaOverrideContainer2_0 {
    protected final PA parentAdapter;
    protected final Vector<S> specifiedOverrides = new Vector();
    protected final SpecifiedOverrideContainerAdapter specifiedOverrideContainerAdapter = new SpecifiedOverrideContainerAdapter();
    protected final Vector<V> virtualOverrides = new Vector();
    protected final VirtualOverrideContainerAdapter virtualOverrideContainerAdapter = new VirtualOverrideContainerAdapter();

    protected AbstractJavaOverrideContainer(JpaContextModel parent) {
        super(parent);
        this.parentAdapter = null;
    }

    protected AbstractJavaOverrideContainer(PA parentAdapter) {
        super(parentAdapter.getOverrideContainerParent());
        this.parentAdapter = parentAdapter;
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.synchronizeModelsWithResourceModel((Iterable<? extends JpaContextModel>)this.getSpecifiedOverrides(), monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateSpecifiedOverrides(monitor);
        this.updateVirtualOverrides(monitor);
    }

    public ListIterable<R> getOverrides() {
        return IterableTools.concatenate((ListIterable[])new ListIterable[]{this.getReadOnlySpecifiedOverrides(), this.getReadOnlyVirtualOverrides()});
    }

    @Override
    public int getOverridesSize() {
        return this.specifiedOverrides.size() + this.virtualOverrides.size();
    }

    public R getOverrideNamed(String name) {
        return this.selectOverrideNamed((Iterable<R>)this.getOverrides(), name);
    }

    @Override
    public Iterable<String> getOverrideNames() {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getOverrides(), Override_.NAME_TRANSFORMER));
    }

    public V convertOverrideToVirtual(SpecifiedOverride override) {
        if (override.isVirtual()) {
            throw new IllegalArgumentException("Override is already virtual: " + override);
        }
        JavaSpecifiedOverride specifiedOverride = (JavaSpecifiedOverride)override;
        int virtualIndex = this.virtualOverrides.size();
        String overrideName = specifiedOverride.getName();
        Object virtualOverride = null;
        if (this.overrideWillBeVirtual(overrideName, specifiedOverride)) {
            virtualOverride = this.buildVirtualOverride(overrideName);
            this.virtualOverrides.add(virtualIndex, virtualOverride);
        }
        this.removeSpecifiedOverride(specifiedOverride);
        if (virtualOverride != null) {
            this.fireItemAdded("virtualOverrides", virtualIndex, virtualOverride);
        }
        return (V)virtualOverride;
    }

    protected boolean overrideWillBeVirtual(String overrideName, S specifiedOverrideToBeRemoved) {
        return IterableTools.contains(this.getAllOverridableNames(), (Object)overrideName) && this.getSpecifiedOverrideNamed(overrideName, specifiedOverrideToBeRemoved) == null;
    }

    public S convertOverrideToSpecified(VirtualOverride override) {
        if (!override.isVirtual()) {
            throw new IllegalArgumentException("Override is already specified: " + override);
        }
        JavaVirtualOverride virtualOverride = (JavaVirtualOverride)override;
        int virtualIndex = this.virtualOverrides.indexOf(virtualOverride);
        this.virtualOverrides.remove(virtualIndex);
        int specifiedIndex = this.specifiedOverrides.size();
        S specifiedOverride = this.buildSpecifiedOverride(this.buildOverrideAnnotation(specifiedIndex));
        this.specifiedOverrides.add(specifiedIndex, specifiedOverride);
        this.initializeSpecifiedOverride(specifiedOverride, virtualOverride);
        this.fireItemRemoved("virtualOverrides", virtualIndex, virtualOverride);
        this.fireItemAdded("specifiedOverrides", specifiedIndex, specifiedOverride);
        return specifiedOverride;
    }

    protected abstract void initializeSpecifiedOverride(S var1, V var2);

    public ListIterable<S> getSpecifiedOverrides() {
        return IterableTools.cloneLive(this.specifiedOverrides);
    }

    protected ListIterable<R> getReadOnlySpecifiedOverrides() {
        return this.getSpecifiedOverrides();
    }

    @Override
    public int getSpecifiedOverridesSize() {
        return this.specifiedOverrides.size();
    }

    public S getSpecifiedOverride(int index) {
        return (S)((JavaSpecifiedOverride)this.specifiedOverrides.get(index));
    }

    public S getSpecifiedOverrideNamed(String name) {
        return this.getSpecifiedOverrideNamed(name, null);
    }

    protected S getSpecifiedOverrideNamed(String name, S exclude) {
        return (S)((JavaSpecifiedOverride)this.selectOverrideNamed((Iterable<R>)this.getReadOnlySpecifiedOverrides(), name, exclude));
    }

    protected S addSpecifiedOverride() {
        return this.addSpecifiedOverride(this.specifiedOverrides.size());
    }

    protected S addSpecifiedOverride(int index) {
        A annotation = this.buildOverrideAnnotation(index);
        return this.addSpecifiedOverride_(index, annotation);
    }

    protected A buildOverrideAnnotation(int index) {
        int annotationIndex = this.calculateNewAnnotationIndex(index);
        return (A)((OverrideAnnotation)this.getResourceMember().addAnnotation(annotationIndex, this.getOverrideAnnotationName()));
    }

    protected int calculateNewAnnotationIndex(int index) {
        if (index == this.specifiedOverrides.size()) {
            return IterableTools.size(this.getOverrideAnnotations());
        }
        if (index == 0) {
            return 0;
        }
        return this.translateToAnnotationIndex(index - 1) + 1;
    }

    protected int translateToAnnotationIndex(int index) {
        return IterableTools.indexOf(this.getOverrideAnnotations(), (Object)((JavaSpecifiedOverride)this.specifiedOverrides.get(index)).getOverrideAnnotation());
    }

    protected abstract String getOverrideAnnotationName();

    protected void removeSpecifiedOverride(S override) {
        this.removeSpecifiedOverride(this.specifiedOverrides.indexOf(override));
    }

    protected void removeSpecifiedOverride(int index) {
        this.removeOverrideAnnotation(index);
        this.removeSpecifiedOverride_(index);
    }

    protected void removeOverrideAnnotation(int index) {
        int annotationIndex = this.translateToAnnotationIndex(index);
        this.getResourceMember().removeAnnotation(annotationIndex, this.getOverrideAnnotationName());
    }

    protected void removeSpecifiedOverride_(int index) {
        this.removeItemFromList(index, this.specifiedOverrides, "specifiedOverrides");
    }

    @Override
    public void moveSpecifiedOverride(int targetIndex, int sourceIndex) {
        this.moveOverrideAnnotation(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedOverrides, "specifiedOverrides");
    }

    protected void moveOverrideAnnotation(int targetIndex, int sourceIndex) {
        int targetAnnotationIndex = this.translateToAnnotationIndex(targetIndex);
        int sourceAnnotationIndex = this.translateToAnnotationIndex(sourceIndex);
        this.getResourceMember().moveAnnotation(targetAnnotationIndex, sourceAnnotationIndex, this.getOverrideAnnotationName());
    }

    protected abstract S buildSpecifiedOverride(A var1);

    protected void updateSpecifiedOverrides(IProgressMonitor monitor) {
        ContextContainerTools.update(this.specifiedOverrideContainerAdapter, monitor);
    }

    protected Iterable<A> getRelevantOverrideAnnotations() {
        return IterableTools.filter(this.getOverrideAnnotations(), (Predicate)new AnnotationIsRelevant());
    }

    protected Iterable<A> getOverrideAnnotations() {
        return new SubIterableWrapper(this.overrideAnnotations());
    }

    protected Iterable<NestableAnnotation> overrideAnnotations() {
        return this.parentAdapter == null ? EmptyIterable.instance() : this.overrideAnnotations_();
    }

    protected Iterable<NestableAnnotation> overrideAnnotations_() {
        return this.getResourceMember().getAnnotations(this.getOverrideAnnotationName());
    }

    protected void moveSpecifiedOverride_(int index, S override) {
        this.moveItemInList(index, override, this.specifiedOverrides, "specifiedOverrides");
    }

    protected S addSpecifiedOverride_(int index, A overrideAnnotation) {
        S override = this.buildSpecifiedOverride(overrideAnnotation);
        this.addItemToList(index, override, this.specifiedOverrides, "specifiedOverrides");
        return override;
    }

    protected void removeSpecifiedOverride_(S override) {
        this.removeSpecifiedOverride_(this.specifiedOverrides.indexOf(override));
    }

    public ListIterable<V> getVirtualOverrides() {
        return IterableTools.cloneLive(this.virtualOverrides);
    }

    @Override
    public int getVirtualOverridesSize() {
        return this.virtualOverrides.size();
    }

    protected ListIterable<R> getReadOnlyVirtualOverrides() {
        return this.getVirtualOverrides();
    }

    protected void updateVirtualOverrides(IProgressMonitor monitor) {
        ContextContainerTools.update(this.virtualOverrideContainerAdapter, monitor);
    }

    protected Iterable<String> getVirtualOverrideNames() {
        return IterableTools.filter(this.getAllOverridableNames(), (Predicate)new OverrideIsVirtual());
    }

    protected boolean overrideIsVirtual(String name) {
        return this.getSpecifiedOverrideNamed(name) == null;
    }

    protected void moveVirtualOverride(int index, V override) {
        this.moveItemInList(index, override, this.virtualOverrides, "virtualOverrides");
    }

    protected V addVirtualOverride(int index, String name) {
        V override = this.buildVirtualOverride(name);
        this.addItemToList(index, override, this.virtualOverrides, "virtualOverrides");
        return override;
    }

    protected abstract V buildVirtualOverride(String var1);

    protected void removeVirtualOverride(V override) {
        this.removeItemFromList(override, this.virtualOverrides, "virtualOverrides");
    }

    protected JavaOverrideContainer2_0.ParentAdapter getParentAdapter2_0() {
        return (JavaOverrideContainer2_0.ParentAdapter)this.parentAdapter;
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.parentAdapter.getTypeMapping();
    }

    protected JavaResourceMember getResourceMember() {
        return this.parentAdapter.getResourceMember();
    }

    @Override
    public TypeMapping getOverridableTypeMapping() {
        return this.parentAdapter.getOverridableTypeMapping();
    }

    @Override
    public Iterable<String> getAllOverridableNames() {
        return this.parentAdapter != null ? this.parentAdapter.getAllOverridableNames() : EmptyIterable.instance();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.parentAdapter.tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.parentAdapter.getCandidateTableNames();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.parentAdapter.resolveDbTable(tableName);
    }

    @Override
    public String getDefaultTableName() {
        return this.parentAdapter.getDefaultTableName();
    }

    @Override
    public JpaValidator buildOverrideValidator(Override_ override) {
        return this.parentAdapter.buildOverrideValidator(override, this);
    }

    @Override
    public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter tableParentAdapter) {
        return this.parentAdapter.buildColumnValidator(override, column, tableParentAdapter);
    }

    @Override
    public String getPossiblePrefix() {
        return this.getParentAdapter2_0().getPossiblePrefix();
    }

    @Override
    public String getWritePrefix() {
        return this.getParentAdapter2_0().getWritePrefix();
    }

    protected R selectOverrideNamed(Iterable<R> overrides, String name) {
        return this.selectOverrideNamed(overrides, name, null);
    }

    protected R selectOverrideNamed(Iterable<R> overrides, String name, S exclude) {
        for (Override_ override : overrides) {
            if (override == exclude || !ObjectTools.equals((Object)override.getName(), (Object)name)) continue;
            return (R)override;
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        StringBuilderTools.append((StringBuilder)sb, this.getOverrides());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (Override_ override : this.getOverrides()) {
            result = override.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (Override_ override : this.getOverrides()) {
            override.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getValidationAnnotationTextRange();
        return textRange != null ? textRange : this.parentAdapter.getValidationTextRange();
    }

    protected TextRange getValidationAnnotationTextRange() {
        Annotation annotation = this.getValidationAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }

    protected Annotation getValidationAnnotation() {
        JavaResourceMember resourceMember = this.getResourceMember();
        return resourceMember.getAnnotation(this.getOverrideAnnotationName());
    }

    public class AnnotationIsRelevant
    extends PredicateAdapter<A> {
        public boolean evaluate(A annotation) {
            String overrideName = annotation.getName();
            return overrideName != null && this.getParentAdapter().isRelevant(overrideName);
        }

        protected JavaOverrideContainer2_0.ParentAdapter getParentAdapter() {
            return AbstractJavaOverrideContainer.this.getParentAdapter2_0();
        }
    }

    public class OverrideIsVirtual
    extends PredicateAdapter<String> {
        public boolean evaluate(String overrideName) {
            return AbstractJavaOverrideContainer.this.overrideIsVirtual(overrideName);
        }
    }

    protected class SpecifiedOverrideContainerAdapter
    implements ContextContainerTools.Adapter<S, A> {
        protected SpecifiedOverrideContainerAdapter() {
        }

        @Override
        public Iterable<S> getContextElements() {
            return AbstractJavaOverrideContainer.this.getSpecifiedOverrides();
        }

        @Override
        public Iterable<A> getResourceElements() {
            return AbstractJavaOverrideContainer.this.getRelevantOverrideAnnotations();
        }

        @Override
        public A getResourceElement(S contextElement) {
            return contextElement.getOverrideAnnotation();
        }

        @Override
        public void moveContextElement(int index, S element) {
            AbstractJavaOverrideContainer.this.moveSpecifiedOverride_(index, element);
        }

        @Override
        public void addContextElement(int index, A resourceElement) {
            AbstractJavaOverrideContainer.this.addSpecifiedOverride_(index, resourceElement);
        }

        @Override
        public void removeContextElement(S element) {
            AbstractJavaOverrideContainer.this.removeSpecifiedOverride_(element);
        }
    }

    protected class VirtualOverrideContainerAdapter
    implements ContextContainerTools.Adapter<V, String> {
        protected VirtualOverrideContainerAdapter() {
        }

        @Override
        public Iterable<V> getContextElements() {
            return AbstractJavaOverrideContainer.this.getVirtualOverrides();
        }

        @Override
        public Iterable<String> getResourceElements() {
            return AbstractJavaOverrideContainer.this.getVirtualOverrideNames();
        }

        @Override
        public String getResourceElement(V contextElement) {
            return contextElement.getName();
        }

        @Override
        public void moveContextElement(int index, V element) {
            AbstractJavaOverrideContainer.this.moveVirtualOverride(index, element);
        }

        @Override
        public void addContextElement(int index, String resourceElement) {
            AbstractJavaOverrideContainer.this.addVirtualOverride(index, resourceElement);
        }

        @Override
        public void removeContextElement(V element) {
            AbstractJavaOverrideContainer.this.removeVirtualOverride(element);
        }
    }
}

