/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.jee.model.internal.mergers.JNDIRefsMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBeanMerger
extends ModelElementMerger {
    public EntityBeanMerger(EntityBean _base, EntityBean _toMergeBean, int _kind) {
        super((JavaEEObject)_base, (JavaEEObject)_toMergeBean, _kind);
    }

    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        if (this.getToMerge() == null) {
            return warnings;
        }
        String beanClass = this.getBaseBean().getEjbClass();
        if (beanClass == null) {
            beanClass = this.getToMergeBean().getEjbClass();
        }
        this.getBaseBean().setEjbClass(beanClass);
        this.mergeInterfaces(warnings);
        this.mergeSecurityRoleRefs(warnings);
        this.mergeJNDIRefs(warnings);
        return warnings;
    }

    EntityBean getBaseBean() {
        return (EntityBean)this.getBase();
    }

    EntityBean getToMergeBean() {
        return (EntityBean)this.getToMerge();
    }

    private void mergeSecurityRoleRefs(List warnings) throws ModelException {
        List toMergeList = this.getToMergeBean().getSecurityRoleRefs();
        this.addAllRoleRefs(toMergeList, warnings);
    }

    private void addAllRoleRefs(List<SecurityRoleRef> roleRefs, List warnings) {
        for (SecurityRoleRef roleRef : roleRefs) {
            if (this.existingSecRoleRef(this.getBaseBean().getSecurityRoleRefs(), roleRef)) continue;
            this.getBaseBean().getSecurityRoleRefs().add(roleRef);
        }
    }

    private boolean existingSecRoleRef(List roles, SecurityRoleRef secRole) {
        for (Object object : roles) {
            SecurityRoleRef cRole = (SecurityRoleRef)object;
            cRole.getRoleName().equals(secRole.getRoleName());
        }
        return false;
    }

    private void mergeInterfaces(List warnings) throws ModelException {
        EntityBean baseBean = this.getBaseBean();
        EntityBean toMergeBean = this.getToMergeBean();
        if (baseBean.getLocal() == null) {
            String toMergeLocal = toMergeBean.getLocal();
            baseBean.setLocal(toMergeLocal);
        }
        if (baseBean.getLocalHome() == null) {
            String toMergeLocalHome = toMergeBean.getLocalHome();
            baseBean.setLocalHome(toMergeLocalHome);
        }
        if (baseBean.getRemote() == null) {
            String toMergeRemote = toMergeBean.getRemote();
            baseBean.setRemote(toMergeRemote);
        }
        if (baseBean.getRemote() == null) {
            String toMergeRemoteHome = toMergeBean.getRemote();
            baseBean.setRemote(toMergeRemoteHome);
        }
    }

    private void mergeJNDIRefs(List warnings) throws ModelException {
        JNDIRefsMerger jndiRefsMerger = new JNDIRefsMerger((JavaEEObject)this.getBaseBean(), (JavaEEObject)this.getToMergeBean(), this.getKind());
        warnings.addAll(jndiRefsMerger.process());
    }
}

