/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.listener.AbstractAutSwtEventListener;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.RecordActionsSWT;
import org.eclipse.jubula.rc.swt.listener.RecordHelperSWT;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class RecordListener
extends AbstractAutSwtEventListener {
    private static AutServerLogger log = new AutServerLogger(RecordListener.class);
    private Widget m_popupSource = null;
    private int m_popupMouseBtn = 0x200000;
    private Widget m_ccombo = null;
    private Widget m_selectedWidget;
    private Widget m_selectedWidgetParent;
    private RecordHelperSWT m_recordHelperSWT = new RecordHelperSWT();
    private RecordActionsSWT m_recordActionsSWT = new RecordActionsSWT();

    public long[] getEventMask() {
        return new long[]{5L, 4L, 6L, 3L, 1L, 18L, 17L, 35L, 22L, 13L, 15L, 16L, 31L};
    }

    public void handleEvent(final Event event) {
        Display display;
        if (!(event.widget instanceof MenuItem || event.widget instanceof Menu || event.type != 4 && event.type != 3)) {
            this.m_popupMouseBtn = event.button;
            this.m_recordActionsSWT.setPopupMouseButton(this.m_popupMouseBtn);
        }
        if ((display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay()) != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (event.equals(RecordListener.this.getLastEvent()) || event.widget == null || RecordListener.this.eventShouldBeIgnored(event) || !RecordListener.this.m_recordHelperSWT.isSupportedWidget(event.widget) && event.type != 1 && event.type != 31) {
                        return;
                    }
                    if (event.type == 22) {
                        RecordListener.this.handleShowEvent(event);
                    }
                    if (event.type == 15 || event.type == 16) {
                        RecordListener.this.handleFocusEvent(event);
                    }
                    if (event.widget instanceof CCombo) {
                        CCombo ccbx = (CCombo)event.widget;
                        RecordListener.this.m_ccombo = (Widget)ccbx;
                    }
                    if (RecordListener.this.getSelectedWidget() == event.widget || RecordListener.this.getSelectedWidgetParent() == event.widget) {
                        if (event.type == 17) {
                            RecordListener.this.m_recordActionsSWT.collExpTree("CompSystem.ExpandByTextPath", event);
                        } else if (event.type == 18) {
                            RecordListener.this.m_recordActionsSWT.collExpTree("CompSystem.CollapseByTextPath", event);
                        }
                    }
                    if (event.type == 13) {
                        RecordListener.this.handleSelectionEvent(event);
                    }
                    if ((event.type == 4 || event.type == 3) && RecordListener.this.getLastEvent().type != 35) {
                        Widget src = event.widget;
                        if (src instanceof ToolBar || src instanceof CoolBar) {
                            src = SwtUtils.getWidgetAtCursorLocation();
                        }
                        RecordListener.this.handleMouseEvent(event, src);
                    }
                    if (event.type == 6) {
                        RecordListener.this.handleMouseEnterEvent(event);
                    }
                    if (event.type == 1 && event.keyCode != 0x1000002 && event.keyCode != 0x1000003 && event.keyCode != 0x1000004 && event.keyCode != 0x1000001 && event.keyCode != 27 && event.keyCode != 13 || event.type == 31 && event.detail != 128 && event.detail != 0) {
                        RecordListener.this.setSelectedWidget(event.widget);
                        RecordListener.this.setSelectedWidgetParent(RecordListener.this.m_recordHelperSWT.getWidgetParent(event.widget));
                        RecordListener.this.handleKeyEvent(event);
                    }
                    RecordListener.this.setLastEvent(event);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleKeyEvent(Event event) {
        Object object = this.getComponentLock();
        synchronized (object) {
            int accepted = this.getAcceptor().accept(event);
            boolean isSingleTrigger = this.getAcceptor().isSingleLineTrigger(event);
            boolean isMultiTrigger = this.getAcceptor().isMultiLineTrigger(event);
            IComponentIdentifier id = null;
            int keycode = event.keyCode;
            Widget source = event.widget;
            id = this.m_recordHelperSWT.getApplicationCompID();
            if (event.type == 31 && event.widget instanceof Shell && this.getLastEvent().type == 31 && !(this.getLastEvent().widget instanceof Shell)) {
                return;
            }
            if (accepted != 2 && accepted != 3) {
                Text txt;
                if (!(source instanceof Text || source instanceof Combo || source instanceof CCombo || keycode == 65536 || keycode == 262144 || keycode == 262144 || keycode == 131072 || event.stateMask == 196608 || event.stateMask == 458752)) {
                    this.m_recordActionsSWT.keyComboApp(id, event, keycode);
                }
                if ((source instanceof Combo || source instanceof CCombo) && isSingleTrigger) {
                    this.m_recordActionsSWT.replaceText(source);
                    this.m_recordActionsSWT.keyComboApp(id, event, keycode);
                }
                if (source instanceof Text && !this.belongsToCCombo(source) && (((txt = (Text)source).getStyle() & 2) != 0 && isMultiTrigger || (txt.getStyle() & 2) == 0 && isSingleTrigger)) {
                    this.m_recordActionsSWT.replaceText(source);
                    if (event.stateMask != 196608 && event.stateMask != 458752) {
                        this.m_recordActionsSWT.keyComboApp(id, event, keycode);
                    }
                }
            }
            if (accepted == 2) {
                if (source instanceof Text || source instanceof Combo || source instanceof CCombo) {
                    this.m_recordActionsSWT.replaceText(source);
                }
                this.changeCheckModeState(4);
            }
        }
    }

    protected void handleMouseEvent(Event event, Widget widget) {
        Text txt;
        this.setCurrentComponent(widget);
        boolean isCell = false;
        if (this.getCurrentComponent() instanceof Text && (txt = (Text)this.getCurrentComponent()).getParent() instanceof Table) {
            isCell = true;
        }
        try {
            if (!(event.type != 4 || this.getCurrentComponent() instanceof Shell || this.getCurrentComponent() instanceof Group || isCell || this.getCurrentComponent() == null)) {
                IComponentIdentifier id = ComponentHandler.getIdentifier(this.getCurrentComponent());
                if (!(widget == null || event.widget instanceof TabFolder || event.widget instanceof CTabFolder || event.widget instanceof List || event.widget instanceof Tree || event.widget instanceof Combo || event.widget instanceof CCombo || event.widget instanceof Text && ((Text)event.widget).getEditable() || this.belongsToCCombo(event.widget))) {
                    if (event.widget instanceof Table) {
                        Table tbl = (Table)event.widget;
                        int[] cell = this.m_recordHelperSWT.getSelectedCell(tbl);
                        if (cell[0] != -1 && cell[1] != -1) {
                            int clickcount = event.count != 0 ? event.count : this.getLastEvent().count;
                            Action a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectCellNew");
                            this.m_recordActionsSWT.selectTableCell(tbl, id, clickcount, a, cell);
                        } else {
                            this.m_recordActionsSWT.clickGraphComp(id, event, widget);
                        }
                    } else if (!(this.belongsToCCombo(this.getLastEvent().widget) && this.getLastEvent().widget instanceof Button && event.widget instanceof CCombo || this.getLastEvent().type == 13 || this.getLastEvent().type == 17 || this.getLastEvent().type == 18)) {
                        this.m_recordActionsSWT.clickGraphComp(id, event, widget);
                    }
                }
            }
        }
        catch (NoIdentifierForComponentException noIdentifierForComponentException) {
            log.error((Object)("no identifier for '" + this.getCurrentComponent()));
        }
    }

    protected void handleMouseEnterEvent(Event event) {
        if (event.widget instanceof List && this.m_recordHelperSWT.isDropdownList((List)event.widget, this.m_ccombo)) {
            this.setSelectedWidget(this.m_ccombo);
        } else {
            this.setSelectedWidget(event.widget);
        }
        this.setSelectedWidgetParent(this.m_recordHelperSWT.getWidgetParent(event.widget));
    }

    protected void handleShowEvent(Event event) {
        Shell shell;
        int style;
        Composite parent;
        if (this.getLastEvent().type == 35 || this.getLastEvent().widget instanceof ToolItem || this.getLastEvent().widget instanceof ToolBar || this.getLastEvent().widget instanceof CoolBar || this.getLastEvent().type == 3 || this.getLastEvent().type == 4) {
            this.m_popupSource = this.getLastEvent().widget;
            if (this.m_popupSource instanceof ToolBar || this.m_popupSource instanceof CoolBar) {
                this.m_popupSource = SwtUtils.getWidgetAtCursorLocation();
            }
        }
        boolean isCCombo = false;
        if (this.getLastEvent().widget instanceof Button) {
            Button btn = (Button)this.getLastEvent().widget;
            parent = btn.getParent();
            if (parent instanceof CCombo) {
                isCCombo = true;
                this.m_ccombo = parent;
            }
        } else if (this.getLastEvent().widget instanceof Text) {
            Text txt = (Text)this.getLastEvent().widget;
            parent = txt.getParent();
            if (parent instanceof CCombo) {
                isCCombo = true;
                this.m_ccombo = parent;
            }
        } else if (this.getLastEvent().widget instanceof CCombo) {
            CCombo ccbx = (CCombo)this.getLastEvent().widget;
            isCCombo = true;
            this.m_ccombo = ccbx;
        }
        if (event.widget instanceof Shell && !isCCombo && (((style = (shell = (Shell)event.widget).getStyle()) & 0x20) == 32 || (style & 0x40) == 64 || (style & 0x80) == 128 || (style & 0x400) == 1024)) {
            final IComponentIdentifier id = this.m_recordHelperSWT.getApplicationCompID();
            Action wfw = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.WaitForWindow");
            final Action wfwtc = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.WaitForWindowToClose");
            int[] closeEvents = new int[]{12, 21, 23};
            int i = 0;
            while (i < closeEvents.length) {
                shell.addListener(closeEvents[i], new Listener(){

                    public void handleEvent(Event e) {
                        RecordListener.this.m_recordActionsSWT.waitForWindow(shell, id, wfwtc);
                    }
                });
                ++i;
            }
            this.m_recordActionsSWT.waitForWindow(shell, id, wfw);
        }
    }

    protected void handleSelectionEvent(Event event) {
        Widget widget = event.widget;
        IComponentIdentifier id = null;
        Action a = new Action();
        if (!(widget instanceof MenuItem || this.getSelectedWidget() != widget && this.getSelectedWidgetParent() != widget)) {
            try {
                id = ComponentHandler.getIdentifier(widget);
                if (widget instanceof List) {
                    List lst = (List)widget;
                    if (this.m_recordHelperSWT.isDropdownList(lst, this.m_ccombo)) {
                        return;
                    }
                    if (lst.getSelectionCount() != 0) {
                        a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectValues");
                        this.m_recordActionsSWT.selectListValues(lst, id, a);
                    }
                } else if (widget instanceof Tree) {
                    int clickcount;
                    Tree tre = (Tree)widget;
                    int n = clickcount = event.count != 0 ? event.count : this.getLastEvent().count;
                    if (tre.getSelectionCount() != 0) {
                        if (tre.getColumnCount() < 1) {
                            a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectByTextPath");
                            this.m_recordActionsSWT.selectNode(tre, id, a, clickcount);
                        } else {
                            a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectByTextPathAtColumn");
                            this.m_recordActionsSWT.selectTableTreeCell(tre, id, a, clickcount);
                        }
                    }
                } else if (widget instanceof Combo) {
                    Combo cbx = (Combo)widget;
                    a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectValue");
                    this.m_recordActionsSWT.selectCbxValue(cbx, id, a);
                } else if (widget instanceof CCombo) {
                    CCombo ccbx = (CCombo)widget;
                    a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectValue");
                    this.m_recordActionsSWT.selectCCbxValue(ccbx, id, a);
                } else if (widget instanceof CTabFolder) {
                    CTabFolder ctf = (CTabFolder)widget;
                    a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectTab");
                    this.m_recordActionsSWT.selectCTab(ctf, id, a);
                } else if (widget instanceof TabFolder) {
                    TabFolder tf = (TabFolder)widget;
                    a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectTab");
                    this.m_recordActionsSWT.selectTab(tf, id, a);
                }
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + widget));
            }
        } else if (widget instanceof MenuItem) {
            this.selectMenuItem(widget);
        }
    }

    protected void handleFocusEvent(Event event) {
        Widget source = event.widget;
        if (event.type == 15 && (source instanceof Text || source instanceof Combo || source instanceof CCombo)) {
            String content = null;
            if (source instanceof Text) {
                Text textComp = (Text)source;
                content = textComp.getText();
            }
            if (source instanceof Combo) {
                Combo cbx = (Combo)source;
                content = cbx.getText();
            }
            if (source instanceof CCombo) {
                CCombo ccbx = (CCombo)source;
                content = ccbx.getText();
            }
            this.m_recordActionsSWT.addTextCompContent(source, content);
        }
        if (event.type == 16 && (source instanceof Text || source instanceof Combo || source instanceof CCombo)) {
            this.m_recordActionsSWT.replaceText(source);
        }
    }

    private boolean eventShouldBeIgnored(Event event) {
        boolean ignore = false;
        if (!(event.type != 16 && event.type != 15 || event.widget instanceof Text || event.widget instanceof Combo || event.widget instanceof CCombo)) {
            ignore = true;
        }
        if (event.type == 22 && !(event.widget instanceof Menu) && !(event.widget instanceof Shell)) {
            ignore = true;
        }
        return ignore;
    }

    private void selectMenuItem(Widget widget) {
        MenuItem mni = (MenuItem)widget;
        if ((mni.getStyle() & 0x10) == 16 && !mni.getSelection()) {
            return;
        }
        String logName = null;
        IComponentIdentifier id = null;
        Action a = new Action();
        if (this.m_recordHelperSWT.isMenuBarItem(mni.getParent())) {
            id = this.m_recordHelperSWT.getMenuCompID();
            a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectMenuItem");
        } else {
            try {
                if (this.m_popupSource == null) {
                    return;
                }
                id = ComponentHandler.getIdentifier(this.m_popupSource);
                a = this.m_popupSource instanceof ToolItem && (this.m_popupSource.getStyle() & 4) != 0 ? this.m_recordHelperSWT.compSysToAction(id, "CompSystem.SelectMenuItem") : this.m_recordHelperSWT.compSysToAction(id, "CompSystem.PopupSelectByTextPathNew");
                logName = this.m_recordHelperSWT.generateLogicalName(this.m_popupSource, id);
                this.m_popupSource = null;
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + widget));
            }
        }
        this.m_recordActionsSWT.selectMenuItem(mni, id, a, logName);
    }

    protected boolean belongsToCCombo(Widget w) {
        Text txt;
        Composite parent;
        boolean isCCbxChild = false;
        if (w instanceof Button) {
            Button btn = (Button)w;
            Composite parent2 = btn.getParent();
            if (parent2 instanceof CCombo) {
                isCCbxChild = true;
                this.m_ccombo = parent2;
            }
        } else if (w instanceof Text && (parent = (txt = (Text)w).getParent()) instanceof CCombo) {
            isCCbxChild = true;
            this.m_ccombo = parent;
        }
        return isCCbxChild;
    }

    protected boolean belongsToCombo(Widget w) {
        Text txt;
        Composite parent;
        boolean isCbxChild = false;
        if (w instanceof Button) {
            Button btn = (Button)w;
            Composite parent2 = btn.getParent();
            if (parent2 instanceof Combo) {
                isCbxChild = true;
                this.m_ccombo = parent2;
            }
        } else if (w instanceof Text && (parent = (txt = (Text)w).getParent()) instanceof Combo) {
            isCbxChild = true;
            this.m_ccombo = parent;
        }
        return isCbxChild;
    }

    protected Widget getSelectedWidget() {
        return this.m_selectedWidget;
    }

    protected void setSelectedWidget(Widget selectedWidget) {
        this.m_selectedWidget = selectedWidget;
    }

    protected Widget getSelectedWidgetParent() {
        return this.m_selectedWidgetParent;
    }

    protected void setSelectedWidgetParent(Widget selectedWidgetParent) {
        this.m_selectedWidgetParent = selectedWidgetParent;
    }

    protected Color getBorderColor() {
        return new Color(null, 200, 0, 0);
    }
}

