/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.resource.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;
import org.eclipse.jwt.we.conf.model.plugin.internal.EMFUtils;
import org.eclipse.jwt.we.conf.model.resource.ConfResourceException;
import org.eclipse.jwt.we.conf.model.resource.internal.EMFResourceUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfModelPatchingContext {
    private static DocumentBuilder db;
    private static XPathExpression profileXpathExpr;
    private static XPathExpression aspectInstanceETypeXpathExpr;
    private static XPathExpression aspectInstanceXpathExpr;
    private static TransformerFactory tf;
    private URI confModelUri;
    private ResourceSet modelResourceSet;
    private String confModelAbsoluteFilePath = null;
    private String confModelRelativePlatformPath = null;
    private IFile confModelIFile;
    private Document confModelDoc;
    private ArrayList<Node> nokProfileNodes = new ArrayList(3);
    private HashSet<String> nokProfileNameSet = new HashSet(3);
    private HashSet<String> nokAspectIdSet = new HashSet(3);

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        XPathFactory xpf = XPathFactory.newInstance();
        try {
            profileXpathExpr = xpf.newXPath().compile("/ConfModel/profiles");
            aspectInstanceETypeXpathExpr = xpf.newXPath().compile("aspects/aspectInstanceEType");
            aspectInstanceXpathExpr = xpf.newXPath().compile("/ConfModel/aspectInstances");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        tf = TransformerFactory.newInstance();
    }

    public ConfModelPatchingContext(URI confModelUri, ResourceSet modelResourceSet) {
        this.confModelUri = confModelUri;
        this.modelResourceSet = modelResourceSet;
    }

    public HashSet<String> getNokProfileNameSet() {
        return this.nokProfileNameSet;
    }

    public HashSet<String> getNokAspectIdSet() {
        return this.nokAspectIdSet;
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        return tf.newTransformer();
    }

    public void auditConfModel() throws ConfResourceException {
        if (this.confModelUri.isPlatformResource()) {
            this.confModelRelativePlatformPath = this.confModelUri.toPlatformString(false);
            this.confModelIFile = ConfPlugin.getWorkspaceRoot().getFile((IPath)new Path(this.confModelRelativePlatformPath));
            File workspaceFile = ConfPlugin.getWorkspaceRoot().getLocation().toFile();
            File confModelFile = new File(workspaceFile, this.confModelRelativePlatformPath);
            this.confModelAbsoluteFilePath = confModelFile.getAbsolutePath();
        } else if (this.confModelUri.isFile()) {
            this.confModelAbsoluteFilePath = new File(this.confModelUri.toFileString()).getAbsolutePath();
            this.confModelIFile = null;
        } else {
            throw new ConfResourceException("Unsupported URI type for " + this.confModelUri);
        }
        InputStream confModelIs = null;
        try {
            try {
                confModelIs = new BufferedInputStream(new FileInputStream(this.confModelAbsoluteFilePath));
                this.confModelDoc = db.parse(confModelIs);
            }
            catch (FileNotFoundException cex) {
                throw new ConfResourceException("Unable to audit confModel " + this.confModelAbsoluteFilePath + " : file not found", cex);
            }
            catch (IOException ioex) {
                throw new ConfResourceException("Unable to audit confModel " + this.confModelAbsoluteFilePath + " : IO error loading conf", ioex);
            }
            catch (SAXException sex) {
                throw new ConfResourceException("Unable to audit confModel " + this.confModelAbsoluteFilePath + " : error loading conf XML", sex);
            }
        }
        catch (Throwable throwable) {
            try {
                if (confModelIs != null) {
                    confModelIs.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (confModelIs != null) {
                confModelIs.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.checkForInvalidAspectsAndProfiles();
        }
        catch (XPathExpressionException xpeex) {
            throw new ConfResourceException("Unable to audit confModel " + this.confModelAbsoluteFilePath + " : bad xpath", xpeex);
        }
    }

    public void patchConfModel() throws ConfResourceException {
        try {
            this.backupConfModel();
        }
        catch (CoreException cex) {
            throw new ConfResourceException("Unable to patch confModel " + this.confModelAbsoluteFilePath + " : error backuping it", cex);
        }
        try {
            this.removeInvalidProfilesAndAspectInstances();
        }
        catch (XPathExpressionException xpeex) {
            throw new ConfResourceException("Unable to patch confModel " + this.confModelAbsoluteFilePath + " : bad xpath", xpeex);
        }
        DOMSource source = new DOMSource(this.confModelDoc);
        StreamResult result = new StreamResult(this.confModelAbsoluteFilePath);
        try {
            ConfModelPatchingContext.getTransformer().transform(source, result);
        }
        catch (TransformerConfigurationException tcex) {
            throw new ConfResourceException("Unable to patch confModel " + this.confModelAbsoluteFilePath + " : error writing patched XML", tcex);
        }
        catch (TransformerException tex) {
            throw new ConfResourceException("Unable to patch confModel " + this.confModelAbsoluteFilePath + " : error writing patched XML", tex);
        }
        try {
            if (this.confModelIFile != null) {
                this.confModelIFile.refreshLocal(0, null);
            }
            EMFResourceUtils.removeResourceFromResourceSet(this.confModelUri, this.modelResourceSet);
            if (this.confModelIFile != null) {
                ConfPlugin.getWorkspaceRoot().getFile((IPath)new Path(this.confModelRelativePlatformPath)).refreshLocal(0, null);
            }
        }
        catch (CoreException cex) {
            throw new ConfResourceException("Unable to patch confModel " + this.confModelAbsoluteFilePath + " : error refreshing resource", cex);
        }
    }

    private void checkForInvalidAspectsAndProfiles() throws XPathExpressionException {
        NodeList profileNodes = (NodeList)profileXpathExpr.evaluate(this.confModelDoc, XPathConstants.NODESET);
        int profileInd = 0;
        while (profileInd < profileNodes.getLength()) {
            Node profileNode = profileNodes.item(profileInd);
            NodeList aspectInstanceETypeNodes = (NodeList)aspectInstanceETypeXpathExpr.evaluate(profileNode, XPathConstants.NODESET);
            boolean isProfileOk = true;
            int eTypeNodeInd = 0;
            while (eTypeNodeInd < aspectInstanceETypeNodes.getLength()) {
                Node aspectInstanceETypeNode = aspectInstanceETypeNodes.item(eTypeNodeInd);
                String aspectInstanceEType = ((Attr)aspectInstanceETypeNode.getAttributes().getNamedItem("href")).getValue();
                URI aspectInstanceETypeUri = URI.createPlatformResourceURI((String)aspectInstanceEType, (boolean)false);
                EClassifier aspectInstanceEClassifier = null;
                try {
                    aspectInstanceEClassifier = EMFUtils.getETypeEClassifier(aspectInstanceETypeUri);
                }
                catch (Throwable throwable) {}
                if (aspectInstanceEClassifier == null) {
                    isProfileOk = false;
                    String nokAspectId = ((Attr)aspectInstanceETypeNode.getParentNode().getAttributes().getNamedItem("id")).getValue();
                    this.nokAspectIdSet.add(nokAspectId);
                }
                ++eTypeNodeInd;
            }
            if (!isProfileOk) {
                this.nokProfileNodes.add(profileNode);
                this.nokProfileNameSet.add(((Attr)profileNode.getAttributes().getNamedItem("name")).getValue());
            }
            ++profileInd;
        }
        if (this.nokAspectIdSet.isEmpty()) {
            return;
        }
    }

    private void backupConfModel() throws CoreException, ConfResourceException {
        if (this.confModelIFile != null) {
            this.backupConfModelInWorkspace();
        } else {
            this.backupConfModelOutsideWorkspace();
        }
    }

    private void backupConfModelInWorkspace() throws CoreException, ConfResourceException {
        Path confModelBackupPlatformPath = new Path(String.valueOf(this.confModelRelativePlatformPath) + ".bak");
        IFile confModelBackupIFile = ConfPlugin.getWorkspaceRoot().getFile((IPath)confModelBackupPlatformPath);
        confModelBackupIFile.getRawLocation().toFile().delete();
        confModelBackupIFile.delete(true, null);
        this.confModelIFile.copy((IPath)confModelBackupPlatformPath, true, null);
    }

    private void backupConfModelOutsideWorkspace() throws CoreException, ConfResourceException {
        String confModelBackupAbsoluteFilePath = String.valueOf(this.confModelAbsoluteFilePath) + ".bak";
        File confModelBackupFile = new File(confModelBackupAbsoluteFilePath);
        if (confModelBackupFile.exists()) {
            throw new ConfResourceException("Can't write over existing  file at " + confModelBackupAbsoluteFilePath);
        }
        BufferedInputStream confModelBis = null;
        FilterOutputStream confModelBackupBos = null;
        try {
            try {
                int nbRead;
                if (!confModelBackupFile.createNewFile()) {
                    throw new ConfResourceException("Can't write over existing  file at " + confModelBackupAbsoluteFilePath);
                }
                confModelBis = new BufferedInputStream(new FileInputStream(this.confModelAbsoluteFilePath));
                confModelBackupBos = new BufferedOutputStream(new FileOutputStream(confModelBackupFile));
                byte[] buf = new byte[1024];
                while ((nbRead = confModelBis.read(buf)) != -1) {
                    ((BufferedOutputStream)confModelBackupBos).write(buf, 0, nbRead);
                }
                ((BufferedOutputStream)confModelBackupBos).flush();
            }
            catch (IOException ioex) {
                throw new ConfResourceException("Error backing up conf model to " + confModelBackupAbsoluteFilePath, ioex);
            }
        }
        catch (Throwable throwable) {
            try {
                if (confModelBis != null) {
                    confModelBis.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (confModelBackupBos != null) {
                    confModelBackupBos.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (confModelBis != null) {
                confModelBis.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (confModelBackupBos != null) {
                confModelBackupBos.close();
            }
        }
        catch (Exception exception) {}
    }

    private void removeInvalidProfilesAndAspectInstances() throws XPathExpressionException {
        Element confModelConfNode = this.confModelDoc.getDocumentElement();
        for (Node nokProfileNode : this.nokProfileNodes) {
            confModelConfNode.removeChild(nokProfileNode);
        }
        NodeList aspectInstanceNodes = (NodeList)aspectInstanceXpathExpr.evaluate(this.confModelDoc, XPathConstants.NODESET);
        ArrayList<Node> nokAspectInstanceNodes = new ArrayList<Node>(3);
        int aspectInstanceInd = 0;
        while (aspectInstanceInd < aspectInstanceNodes.getLength()) {
            Node aspectInstanceNode = aspectInstanceNodes.item(aspectInstanceInd);
            String nokAspectId = ((Attr)aspectInstanceNode.getAttributes().getNamedItem("id")).getValue();
            if (this.nokAspectIdSet.contains(nokAspectId)) {
                nokAspectInstanceNodes.add(aspectInstanceNode);
                confModelConfNode.removeChild(aspectInstanceNode);
            }
            ++aspectInstanceInd;
        }
    }
}

