/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.pages.activityEditor.internal;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jwt.meta.model.core.NamedElement;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.parts.processes.policies.ScopeLayoutEditPolicy;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;

public class WEMouseMoveTrackListener
implements MouseMoveListener,
MouseTrackListener {
    private static WEMouseMoveTrackListener myinstance = null;
    private IStatusLineManager statusLineManager;

    private WEMouseMoveTrackListener() {
    }

    public static WEMouseMoveTrackListener getInstance() {
        if (myinstance == null) {
            myinstance = new WEMouseMoveTrackListener();
        }
        return myinstance;
    }

    public void acquireStatusLineManager() {
        WEEditor weEditor = GeneralHelper.getActiveInstance();
        if (weEditor != null) {
            IActionBars actionBars = null;
            if (weEditor.getSite() instanceof IViewSite) {
                actionBars = ((IViewSite)weEditor.getSite()).getActionBars();
            } else if (weEditor.getSite() instanceof IEditorSite) {
                actionBars = ((IEditorSite)weEditor.getSite()).getActionBars();
            }
            this.statusLineManager = actionBars.getStatusLineManager();
        }
    }

    public void mouseMove(MouseEvent e) {
        this.acquireStatusLineManager();
        if (this.statusLineManager != null) {
            String text = "";
            Point absolutePosition = new Point(e.x, e.y);
            if (GeneralHelper.getActiveInstance() == null || GeneralHelper.getActiveInstance().getCurrentActivitySheet() == null) {
                return;
            }
            GraphicalViewer editPartViewer = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getGraphicalViewer();
            EditPolicy layoutPolicy = editPartViewer.getContents().getEditPolicy((Object)"LayoutEditPolicy");
            if (layoutPolicy instanceof ScopeLayoutEditPolicy) {
                CreateRequest request = new CreateRequest();
                request.setLocation(absolutePosition);
                Rectangle relativePos = (Rectangle)((ScopeLayoutEditPolicy)layoutPolicy).getConstraintFor(request);
                text = String.valueOf(text) + "(x:" + relativePos.x + " y:" + relativePos.y + ")";
                Object mouseOverObject = null;
                EditPart editPart = editPartViewer.findObjectAt(absolutePosition);
                if (editPart != null) {
                    mouseOverObject = editPart.getModel();
                }
                if (mouseOverObject instanceof NamedElement) {
                    IItemLabelProvider lP = (IItemLabelProvider)GeneralHelper.getActiveInstance().getAdapterFactory().adapt(editPart.getModel(), IItemLabelProvider.class);
                    text = String.valueOf(text) + " | " + lP.getText(mouseOverObject);
                }
            }
            text = text.replaceAll("\\n", " ");
            text = text.replaceAll("\\r", "");
            this.statusLineManager.setMessage(text);
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.statusLineManager == null) {
            this.acquireStatusLineManager();
        }
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(null);
        }
    }

    public void mouseHover(MouseEvent e) {
    }
}

