/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.preferences.pages;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.outline.ModelOutlinePage;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WEPreferencesOutline
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Logger logger = Logger.getLogger(WEPreferencesOutline.class);

    public WEPreferencesOutline() {
        super(1);
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
        this.setDescription("JWT Workflow Editor - " + PluginProperties.preferences_outline_label);
    }

    public void init(IWorkbench workbench) {
    }

    private void addLabel(String label) {
        Label textLabel = new Label(this.getFieldEditorParent(), 16384);
        textLabel.setText(label);
        Font font = textLabel.getFont();
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(fontData.getStyle() | 1);
        textLabel.setFont(new Font(font.getDevice(), fontData));
    }

    private void addSpacing() {
        new Label(this.getFieldEditorParent(), 16384);
        new Label(this.getFieldEditorParent(), 16384);
    }

    public void createFieldEditors() {
        try {
            this.addSpacing();
            this.addLabel(PluginProperties.preferences_outlineviews_label);
            new Label(this.getFieldEditorParent(), 16384);
            String[][] showOutlineAreaEntries = new String[][]{{PluginProperties.preferences_outlinebothview_label, ModelOutlinePage.OUTLINE_AREA_BOTH}, {PluginProperties.preferences_outlineoverview_label, ModelOutlinePage.OUTLINE_AREA_OVERVIEW}, {PluginProperties.preferences_outlinetreeview_label, ModelOutlinePage.OUTLINE_AREA_TREEVIEW}};
            ComboFieldEditor outline_show_area_field = new ComboFieldEditor("WEoutlineShowArea", PluginProperties.preferences_outlineshowareas_label, showOutlineAreaEntries, this.getFieldEditorParent());
            this.addSpacing();
            this.addLabel(PluginProperties.preferences_outlinetreeoptions_label);
            BooleanFieldEditor outline_sort_elements_field = new BooleanFieldEditor("WEoutlineSort", PluginProperties.preferences_outlinesort_label, this.getFieldEditorParent());
            BooleanFieldEditor outline_hide_actedges_field = new BooleanFieldEditor("WEoutlineActEdges", PluginProperties.preferences_outlineactedges_label, this.getFieldEditorParent());
            this.addField((FieldEditor)outline_show_area_field);
            this.addField((FieldEditor)outline_sort_elements_field);
            this.addField((FieldEditor)outline_hide_actedges_field);
        }
        catch (Exception ex) {
            this.logger.debug(ex);
        }
    }
}

