/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.properties.extension.internal;

import java.lang.reflect.Constructor;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.properties.extension.internal.PropertySheetPageDescriptor;
import org.eclipse.jwt.we.editors.properties.extension.internal.PropertySheetPageExtensionPoint;
import org.eclipse.jwt.we.editors.properties.singlePage.ModelPropertySheetPage;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertySheetPageDescriptor
implements PropertySheetPageDescriptor {
    private static Logger log = Logger.getLogger(ClassPropertySheetPageDescriptor.class);
    private Class<?> propertySheetPageClass;

    public ClassPropertySheetPageDescriptor(Class<?> propertySheetPageClass) {
        this.propertySheetPageClass = propertySheetPageClass;
    }

    @Override
    public final IPropertySheetPage createPropertySheetPage(WEEditor weEditor) {
        IPropertySheetPage propertySheetPage = null;
        try {
            if (TabbedPropertySheetPage.class.isAssignableFrom(this.propertySheetPageClass)) {
                Constructor<?> pageCons = this.propertySheetPageClass.getConstructors()[0];
                propertySheetPage = (IPropertySheetPage)pageCons.newInstance(new Object[]{weEditor});
            } else if (ModelPropertySheetPage.class.isAssignableFrom(this.propertySheetPageClass)) {
                Constructor<?> pageCons = this.propertySheetPageClass.getConstructors()[0];
                propertySheetPage = (IPropertySheetPage)pageCons.newInstance(weEditor.getAdapterFactory());
            } else if (IPropertySheetPage.class.isAssignableFrom(this.propertySheetPageClass)) {
                propertySheetPage = (IPropertySheetPage)this.propertySheetPageClass.newInstance();
            } else {
                log.warning("JWT Property Sheet Extension - at " + PropertySheetPageExtensionPoint.EXTENSION_POINT + ": " + this.propertySheetPageClass + " is not a custom property sheet page class");
            }
        }
        catch (Exception e) {
            log.severe("Error loading custom property sheet", e);
        }
        return propertySheetPage;
    }
}

