/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.util;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontUtil {
    public static Font getSystemDefault() {
        Display current = Display.getCurrent();
        if (current == null) {
            Shell shell = new Shell();
            FontData fontData = shell.getFont().getFontData()[0];
            shell.dispose();
            Font font = new Font(null, fontData);
            return font;
        }
        Font font = new Font(null, current.getSystemFont().getFontData()[0]);
        return font;
    }

    public static Font getSystemStyle(int style) {
        Display current = Display.getCurrent();
        if (current == null) {
            Shell shell = new Shell();
            FontData fontData = shell.getFont().getFontData()[0];
            shell.dispose();
            fontData.setStyle(fontData.getStyle() | style);
            Font font = new Font(null, fontData);
            return font;
        }
        FontData fontData = current.getSystemFont().getFontData()[0];
        fontData.setStyle(fontData.getStyle() | style);
        Font font = new Font(null, fontData);
        return font;
    }

    public static Font getResizedFont(Font font, int newSize) {
        FontData fontdata = font.getFontData()[0];
        fontdata.setHeight(newSize);
        return new Font(font.getDevice(), fontdata);
    }

    public static String serializeFont(Font font) {
        FontData fontData = font.getFontData()[0];
        String fontDataString = String.valueOf(fontData.getName()) + "," + fontData.getHeight() + "," + fontData.getStyle();
        return fontDataString;
    }

    public static Font deSerializeFont(String fontDataString) {
        String[] splittedFontDataString = fontDataString.split(",");
        FontData fontData = new FontData(splittedFontDataString[0], new Integer(splittedFontDataString[1]).intValue(), new Integer(splittedFontDataString[2]).intValue());
        return new Font(null, fontData);
    }
}

