/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.view.pages;

import java.util.HashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.FontUtil;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.misc.views.ViewDescriptor;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class ImportViewConfWizardPage
extends WizardPage {
    static final Logger logger = Logger.getLogger(ImportViewConfWizardPage.class);
    private String selectedViewID;
    private boolean importOnlyMissingLayoutData;

    public ImportViewConfWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    public String getSelectedViewID() {
        return this.selectedViewID;
    }

    public boolean isImportOnlyMissingLayoutData() {
        return this.importOnlyMissingLayoutData;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)WizardHelper.createData(4, 4, true, false, -1, -1));
        HashMap scoreImport = LayoutDataManager.computeViewScore(GeneralHelper.getActiveInstance());
        Label viewLabel1 = new Label(composite, 16384);
        viewLabel1.setText(PluginProperties.wizards_ViewConfCurrentView_label);
        viewLabel1.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 2));
        Label viewLabel2 = new Label(composite, 16384);
        viewLabel2.setText(String.valueOf(Views.getInstance().getSelectedView().getOfficialName()) + " (" + Views.getInstance().getSelectedView().getInternalName() + ")");
        viewLabel2.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 1));
        viewLabel2.setFont(FontUtil.getSystemStyle(3));
        Label dummyLabel = new Label(composite, 16384);
        dummyLabel.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        Label dummyLabel2 = new Label(composite, 16384);
        dummyLabel2.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        Label selectLabel = new Label(composite, 16448);
        selectLabel.setText(PluginProperties.wizards_ViewConfImportSelect_label);
        selectLabel.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, 1, 3));
        Label dummyLabel3 = new Label(composite, 16384);
        dummyLabel3.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        boolean firstViewFound = false;
        for (ViewDescriptor viewD : Views.getInstance().getAvailableViews()) {
            if (viewD.getInternalName().equals(Views.getInstance().getSelectedView().getInternalName())) continue;
            Button viewButton = new Button(composite, 16);
            viewButton.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 1));
            viewButton.setText(viewD.getOfficialName());
            viewButton.setData((Object)viewD.getInternalName());
            viewButton.setFont(FontUtil.getSystemStyle(1));
            viewButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ImportViewConfWizardPage.this.selectedViewID = ((Button)e.widget).getData().toString();
                }
            });
            Label buttonLabel = new Label(composite, 16384);
            buttonLabel.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 2));
            buttonLabel.setFont(FontUtil.getSystemStyle(2));
            Integer score = scoreImport.get(viewD.getInternalName()) != null ? scoreImport.get(viewD.getInternalName()) : Integer.valueOf(0);
            buttonLabel.setText(PluginProperties.bind((String)PluginProperties.wizards_ViewConfImportRelevant_label, (Object)viewD.getInternalName(), (Object)score));
            if (firstViewFound) continue;
            viewButton.setSelection(true);
            firstViewFound = true;
            this.selectedViewID = viewD.getInternalName();
        }
        Label dummyLabel4 = new Label(composite, 16384);
        dummyLabel4.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        final Button onlyNewButton = new Button(composite, 32);
        onlyNewButton.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        onlyNewButton.setText(PluginProperties.wizards_ViewConfImportOnlyNew_label);
        onlyNewButton.setSelection(true);
        onlyNewButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportViewConfWizardPage.this.importOnlyMissingLayoutData = onlyNewButton.getSelection();
            }
        });
        this.importOnlyMissingLayoutData = onlyNewButton.getSelection();
        if (!firstViewFound) {
            this.setPageComplete(false);
        }
        this.setMessage(PluginProperties.wizards_ViewConfImport_message);
        this.setControl((Control)composite);
        this.getShell().pack();
        WizardHelper.resizeDialog(this.getShell());
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage("activity");
    }

    public void dispose() {
        super.dispose();
    }
}

