/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.commands.JWTCreateChildCommand;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.core.NamedElement;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.core.PackageableElement;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.Guard;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.meta.model.processes.StructuredActivityNode;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.commands.gefEmfAdapter.EmfToGefCommandAdapter;
import org.eclipse.jwt.we.commands.scope.InsertScopeCommand;
import org.eclipse.jwt.we.commands.view.SetGraphicalElementConstraintCommand;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.figures.internal.IWEFigure;
import org.eclipse.jwt.we.misc.factories.CreateReferenceFactory;
import org.eclipse.jwt.we.misc.factories.TransferFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ViewPackage;

public class ScopeLayoutEditPolicy
extends XYLayoutEditPolicy {
    private static final Logger logger = Logger.getLogger(ScopeLayoutEditPolicy.class);
    protected IFigure feedbackFigure;

    protected org.eclipse.gef.commands.Command getCreateCommand(CreateRequest request) {
        Object childClass = request.getNewObjectType();
        Object model = this.getHost().getModel();
        Object constraint = this.getConstraintFor(request);
        EditingDomain editingDomain = (EditingDomain)this.getHost().getAdapter(EditingDomain.class);
        if (this.feedbackFigure != null) {
            ((Rectangle)constraint).x -= this.feedbackFigure.getBounds().width / 2;
            ((Rectangle)constraint).y -= this.feedbackFigure.getBounds().height / 2;
        }
        if (childClass instanceof Class && model instanceof Scope && constraint instanceof Rectangle) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating new " + ((Class)childClass).getSimpleName());
            }
            if (ActivityNode.class.isAssignableFrom((Class)childClass)) {
                EmfToGefCommandAdapter creationCommand = new EmfToGefCommandAdapter((Command)new JWTCreateChildCommand(editingDomain, model, (Object)ProcessesPackage.Literals.SCOPE__NODES, request.getNewObject()));
                SetGraphicalElementConstraintCommand graphicalConstraintCommand = new SetGraphicalElementConstraintCommand(GeneralHelper.getInstanceForEObject((EObject)model), request, (Rectangle)constraint);
                return creationCommand.chain(graphicalConstraintCommand);
            }
            if (ReferenceableElement.class.isAssignableFrom((Class)childClass) && (model instanceof PackageableElement || model instanceof StructuredActivityNode)) {
                Package packageModel = (Package)GeneralHelper.getInstanceForEObject((EObject)model).getModel();
                if (model instanceof PackageableElement) {
                    packageModel = ((PackageableElement)model).getPackage();
                } else if (GeneralHelper.getInstanceForEObject((EObject)model) != null) {
                    packageModel = GeneralHelper.getInstanceForEObject((EObject)model).getDisplayedActivityModel().getPackage();
                }
                EmfToGefCommandAdapter creationCommand = new EmfToGefCommandAdapter((Command)new JWTCreateChildCommand(editingDomain, (Object)packageModel, (Object)CorePackage.Literals.PACKAGE__ELEMENTS, request.getNewObject()));
                CreateRequest createReferenceRequest = new CreateRequest();
                createReferenceRequest.setFactory((CreationFactory)new CreateReferenceFactory((ReferenceableElement)request.getNewObject()));
                createReferenceRequest.setLocation(request.getLocation());
                createReferenceRequest.setSize(request.getSize());
                org.eclipse.gef.commands.Command createReferenceCommand = this.getCreateCommand(createReferenceRequest);
                return creationCommand.chain(createReferenceCommand);
            }
            if (Reference.class.isAssignableFrom((Class)childClass)) {
                Object newObject = request.getNewObject();
                EmfToGefCommandAdapter setCommand = new EmfToGefCommandAdapter(SetCommand.create((EditingDomain)editingDomain, (Object)newObject, (Object)ViewPackage.Literals.REFERENCE__CONTAINED_IN, (Object)model));
                EmfToGefCommandAdapter addCommand = new EmfToGefCommandAdapter(AddCommand.create((EditingDomain)editingDomain, (Object)EMFHelper.getDiagram(GeneralHelper.getInstanceForEObject((EObject)model)), (Object)ViewPackage.Literals.DIAGRAM__REFERENCES, (Object)newObject));
                SetGraphicalElementConstraintCommand graphicalConstraintCommand = new SetGraphicalElementConstraintCommand(GeneralHelper.getInstanceForEObject((EObject)model), request, (Rectangle)constraint);
                return setCommand.chain(addCommand).chain((org.eclipse.gef.commands.Command)graphicalConstraintCommand);
            }
            if (Scope.class.isAssignableFrom((Class)childClass)) {
                return new InsertScopeCommand(GeneralHelper.getInstanceForEObject((EObject)model), editingDomain, request, (Scope)model, ((Rectangle)constraint).getLocation());
            }
            if (Iterable.class.isAssignableFrom((Class)childClass)) {
                CompoundCommand command = new CompoundCommand();
                for (Object requestobject : (Iterable)request.getNewObject()) {
                    CreateRequest createRequest = new CreateRequest();
                    if (requestobject instanceof ReferenceableElement) {
                        createRequest.setFactory((CreationFactory)new CreateReferenceFactory((ReferenceableElement)requestobject));
                    } else {
                        createRequest.setFactory((CreationFactory)new TransferFactory(requestobject));
                    }
                    createRequest.setLocation(request.getLocation());
                    createRequest.setSize(request.getSize());
                    command.add(this.getCreateCommand(createRequest));
                }
                return command;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected org.eclipse.gef.commands.Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Object childModel = child.getModel();
        if (childModel instanceof GraphicalElement && constraint instanceof Rectangle) {
            return new SetGraphicalElementConstraintCommand(GeneralHelper.getInstanceForEObject((EObject)childModel), (GraphicalElement)childModel, (Rectangle)constraint);
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected org.eclipse.gef.commands.Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return UnexecutableCommand.INSTANCE;
    }

    protected void decorateChild(EditPart child) {
        if (child.getEditPolicy((Object)"PrimaryDrag Policy") == null) {
            super.decorateChild(child);
        }
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!PreferenceReader.appearanceFeedbackVisible.get()) {
            return;
        }
        if (request instanceof CreateRequest) {
            if (this.feedbackFigure == null) {
                this.feedbackFigure = this.createFeedbackFigure(request);
                this.addFeedback(this.feedbackFigure);
            }
            GraphicalViewer editPartViewer = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getGraphicalViewer();
            ScopeLayoutEditPolicy layoutPolicy = (ScopeLayoutEditPolicy)editPartViewer.getContents().getEditPolicy((Object)"LayoutEditPolicy");
            Rectangle bounds = (Rectangle)layoutPolicy.getConstraintFor((CreateRequest)request);
            bounds.setSize(bounds.getSize().union(this.feedbackFigure.getPreferredSize()));
            this.feedbackFigure.setBounds(bounds);
            this.feedbackFigure.getBounds().x -= this.feedbackFigure.getBounds().width / 2;
            this.feedbackFigure.getBounds().y -= this.feedbackFigure.getBounds().height / 2;
            this.feedbackFigure.revalidate();
        }
    }

    protected IFigure createFeedbackFigure(Request request) {
        IFigure fbFigure = null;
        Object objectType = ((CreateRequest)request).getNewObjectType();
        Object newObject = ((CreateRequest)request).getNewObject();
        if (!(newObject instanceof EObject)) {
            return new RectangleFigure();
        }
        if (newObject instanceof Reference) {
            ReferenceableElement refElem = ((Reference)newObject).getReference();
            AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)refElem)).getAdapterFactory();
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)refElem, IItemLabelProvider.class);
            fbFigure = Plugin.getInstance().getFactoryRegistry().getFigureFactory().createFigure(ReferenceableElement.class);
            if (fbFigure instanceof IWEFigure) {
                ((IWEFigure)fbFigure).setName(refElem.getName());
                ((IWEFigure)fbFigure).setImageFactory(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()));
                ((IWEFigure)fbFigure).setIcon((ImageDescriptor)itemLabelProvider.getImage((Object)refElem));
            }
        } else if (newObject instanceof ReferenceableElement) {
            fbFigure = Plugin.getInstance().getFactoryRegistry().getFigureFactory().createFigure(ReferenceableElement.class);
            if (fbFigure instanceof IWEFigure) {
                ((IWEFigure)fbFigure).setImageFactory(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()));
                ((IWEFigure)fbFigure).setIcon(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(newObject));
            }
        } else if (newObject instanceof Guard) {
            fbFigure = Plugin.getInstance().getFactoryRegistry().getFigureFactory().createFigure(GeneralHelper.getObjectClass(objectType));
        } else {
            fbFigure = Plugin.getInstance().getFactoryRegistry().getFigureFactory().createFigure(GeneralHelper.getObjectClass(objectType));
            if (fbFigure instanceof IWEFigure) {
                ((IWEFigure)fbFigure).setName(((NamedElement)newObject).getName());
                ((IWEFigure)fbFigure).setImageFactory(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()));
                ((IWEFigure)fbFigure).setIcon(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createModelTypeImageDescriptor(newObject));
            }
        }
        if (fbFigure instanceof IWEFigure) {
            ((IWEFigure)fbFigure).setAlpha(true);
        }
        return fbFigure;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.feedbackFigure != null) {
            this.removeFeedback(this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
        this.removeFeedback(this.feedbackFigure);
        this.feedbackFigure = null;
        super.showSizeOnDropFeedback(request);
    }

    public Object getConstraintFor(CreateRequest request) {
        return super.getConstraintFor(request);
    }
}

