/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.launchbar.ui.controls.internal.CSelector;
import org.eclipse.launchbar.ui.controls.internal.LaunchBarButtonImageDescriptor;
import org.eclipse.launchbar.ui.controls.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ModeSelector
extends CSelector {
    private static final String[] noModes = new String[]{"---"};
    private final ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);
    private Map<String, Image> modeButtonImages = new HashMap<String, Image>();

    public ModeSelector(Composite parent, int style) {
        super(parent, style);
        this.setToolTipText(Messages.ModeSelector_0);
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                try {
                    Object[] modes = ModeSelector.this.manager.getLaunchModes();
                    if (modes.length > 0) {
                        return modes;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                return noModes;
            }
        });
        this.setLabelProvider((ILabelProvider)new LabelProvider(){
            private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

            public void dispose() {
                super.dispose();
                for (Image image : this.images.values()) {
                    image.dispose();
                }
            }

            public Image getImage(Object element) {
                ILaunchMode mode;
                ILaunchGroup group;
                if (element instanceof ILaunchMode && (group = ModeSelector.this.getLaunchGroup(mode = (ILaunchMode)element)) != null) {
                    ImageDescriptor imageDesc = group.getImageDescriptor();
                    if (imageDesc == null) {
                        return null;
                    }
                    Image image = this.images.get(imageDesc);
                    if (image == null) {
                        image = imageDesc.createImage();
                        this.images.put(imageDesc, image);
                    }
                    return image;
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                ILaunchMode mode;
                ILaunchGroup group;
                if (element instanceof ILaunchMode && (group = ModeSelector.this.getLaunchGroup(mode = (ILaunchMode)element)) != null) {
                    return group.getLabel().replace("&", "");
                }
                return super.getText(element);
            }
        });
        this.setSorter(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof ILaunchMode && o2 instanceof ILaunchMode) {
                    String mode1 = ((ILaunchMode)o1).getIdentifier();
                    String mode2 = ((ILaunchMode)o2).getIdentifier();
                    if (mode1.equals("run")) {
                        if (mode2.equals("run")) {
                            return 0;
                        }
                        return -1;
                    }
                    if (mode2.equals("run")) {
                        return 1;
                    }
                    if (mode1.equals("debug")) {
                        if (mode2.equals("debug")) {
                            return 0;
                        }
                        return -1;
                    }
                    if (mode2.equals("debug")) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Image image : this.modeButtonImages.values()) {
            image.dispose();
        }
    }

    protected ILaunchGroup getDefaultLaunchGroup(String mode) {
        String groupId = mode.equals("debug") ? "org.eclipse.debug.ui.launchGroup.debug" : (mode.equals("profile") ? "org.eclipse.debug.ui.launchGroup.profile" : "org.eclipse.debug.ui.launchGroup.run");
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupId);
    }

    protected ILaunchGroup getLaunchGroup(String mode) throws CoreException {
        ILaunchConfigurationType type = this.manager.getLaunchConfigurationType(this.manager.getActiveLaunchDescriptor(), this.manager.getActiveLaunchTarget());
        if (type == null) {
            return null;
        }
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(type, mode);
    }

    @Override
    protected void fireSelectionChanged() {
        Object selected = this.getSelection();
        if (selected instanceof ILaunchMode) {
            ILaunchMode mode = (ILaunchMode)selected;
            try {
                this.manager.setActiveLaunchMode(mode);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(150, hHint, changed);
    }

    @Override
    public void setSelection(Object element) {
        if (element == null) {
            element = noModes[0];
        }
        if (this.isDisposed()) {
            return;
        }
        super.setSelection(element);
        this.updateLaunchButton(this.findLaunchButton());
    }

    private ToolItem findLaunchButton() {
        String commandId = "org.eclipse.launchbar.ui.command.launchActive";
        Control[] controlArray = this.getParent().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof ToolBar) {
                ToolItem[] toolItemArray = ((ToolBar)control).getItems();
                int n3 = toolItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ToolItem toolItem = toolItemArray[n4];
                    if (commandId.equals(toolItem.getData("command"))) {
                        return toolItem;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        Activator.log(new RuntimeException("Launch button is not found in toolbar"));
        return null;
    }

    private void updateLaunchButton(ToolItem toolItem) {
        if (toolItem == null || this.isDisposed()) {
            return;
        }
        Object selection = this.getSelection();
        if (selection instanceof ILaunchMode) {
            ILaunchMode mode = (ILaunchMode)selection;
            toolItem.setToolTipText(NLS.bind((String)Messages.ModeSelector_ToolTip, (Object)mode.getLabel()));
            ILaunchGroup group = this.getLaunchGroup(mode);
            String id = group.getIdentifier();
            Image image = this.modeButtonImages.get(id);
            if (image == null) {
                Image bgImage = Activator.getDefault().getImageRegistry().get("bgButton");
                Image modeImage = this.getLabelProvider().getImage((Object)mode);
                LaunchBarButtonImageDescriptor imageDesc = new LaunchBarButtonImageDescriptor(modeImage, bgImage);
                image = imageDesc.createImage();
                this.modeButtonImages.put(id, image);
            }
            toolItem.setImage(image);
        }
    }

    public ILaunchGroup getLaunchGroup(ILaunchMode mode) {
        ILaunchGroup group = null;
        try {
            group = this.getLaunchGroup(mode.getIdentifier());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        if (group == null) {
            group = this.getDefaultLaunchGroup(mode.getIdentifier());
        }
        return group;
    }
}

