/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPushPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImagePushPageModel
extends ImagePullPushPageModel {
    public static final String FORCE_TAGGING = "forceTagging";
    public static final String KEEP_TAGGED_IMAGE = "keepTaggedImage";
    private final IDockerImage image;
    private boolean forceTagging;
    private boolean keepTaggedImage;

    public ImagePushPageModel(IDockerImage image, String selectedImageName) {
        super(selectedImageName);
        this.image = image;
    }

    public IDockerImage getImage() {
        return this.image;
    }

    public boolean isForceTagging() {
        return this.forceTagging;
    }

    public void setForceTagging(boolean forceTagging) {
        this.forceTagging = forceTagging;
        this.firePropertyChange(FORCE_TAGGING, this.forceTagging, this.forceTagging);
    }

    public boolean isKeepTaggedImage() {
        return this.keepTaggedImage;
    }

    public void setKeepTaggedImage(boolean keepTaggedImage) {
        this.keepTaggedImage = keepTaggedImage;
        this.firePropertyChange(KEEP_TAGGED_IMAGE, this.keepTaggedImage, this.keepTaggedImage);
    }

    class ImagePushValidator
    extends MultiValidator {
        private final IObservableValue<String> imageNameObservable;
        private final IObservableValue<IRegistry> registryAccountObservable;

        public ImagePushValidator(IObservableValue<String> imageNameObservable, IObservableValue<IRegistry> registryAccountObservable) {
            this.imageNameObservable = imageNameObservable;
            this.registryAccountObservable = registryAccountObservable;
        }

        protected IStatus validate() {
            String selectedImageName = (String)this.imageNameObservable.getValue();
            IRegistry selectedRegistryAcccount = (IRegistry)this.registryAccountObservable.getValue();
            if (selectedImageName == null || selectedImageName.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("ImagePush.desc"));
            }
            if (selectedRegistryAcccount == null) {
                return ValidationStatus.error((String)WizardMessages.getString("ImagePushPage.empty.registry.account"));
            }
            if (ImagePushPageModel.this.image.repoTags() == null || !ImagePushPageModel.this.image.repoTags().contains(selectedImageName)) {
                return ValidationStatus.warning((String)WizardMessages.getString("ImagePushPage.repotag.unknown.msg"));
            }
            return ValidationStatus.info((String)WizardMessages.getString("ImagePushPage.repotag.default.msg"));
        }

        public IObservableList<?> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.imageNameObservable);
            targets.add(this.registryAccountObservable);
            return targets;
        }
    }
}

