/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.valgrind.launch.ExportWizardConstants;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindExportWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ValgrindExportWizard
extends Wizard
implements IExportWizard {
    private ValgrindExportWizardPage exportPage;

    public boolean performFinish() {
        File[] logs = this.exportPage.getSelectedFiles();
        IPath outputPath = this.exportPage.getOutputPath();
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(monitor -> {
                if (logs.length <= 0) return;
                File outputDir = outputPath.toFile();
                monitor.beginTask(NLS.bind((String)Messages.getString("ValgrindExportWizard.Export_task"), (Object)outputPath.toOSString()), logs.length);
                File[] fileArray2 = logs;
                int n = logs.length;
                int n2 = 0;
                while (true) {
                    block29: {
                        if (n2 >= n) {
                            monitor.done();
                            return;
                        }
                        File log = fileArray2[n2];
                        monitor.subTask(NLS.bind((String)Messages.getString("ValgrindExportWizard.Export_subtask"), (Object)log.getName()));
                        File outLog = new File(outputDir, log.getName());
                        try {
                            Throwable throwable = null;
                            Object var10_12 = null;
                            try {
                                FileInputStream fis = new FileInputStream(log);
                                try {
                                    block28: {
                                        FileChannel inChan = fis.getChannel();
                                        try {
                                            block27: {
                                                FileOutputStream fos = new FileOutputStream(outLog);
                                                try {
                                                    try (FileChannel outChan = fos.getChannel();){
                                                        outChan.transferFrom(inChan, 0L, inChan.size());
                                                    }
                                                    if (fos == null) break block27;
                                                }
                                                catch (Throwable throwable2) {
                                                    if (throwable == null) {
                                                        throwable = throwable2;
                                                    } else if (throwable != throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    if (fos == null) throw throwable;
                                                    fos.close();
                                                    throw throwable;
                                                }
                                                fos.close();
                                            }
                                            if (inChan == null) break block28;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                            } else if (throwable != throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            if (inChan == null) throw throwable;
                                            inChan.close();
                                            throw throwable;
                                        }
                                        inChan.close();
                                    }
                                    if (fis == null) break block29;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    if (fis == null) throw throwable;
                                    fis.close();
                                    throw throwable;
                                }
                                fis.close();
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                    throw throwable;
                                }
                                if (throwable == throwable5) throw throwable;
                                throwable.addSuppressed(throwable5);
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
            });
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.valgrind.launch", Messages.getString("ValgrindExportWizard.Export_fail"), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)ExportWizardConstants.WIZARD_TITLE, null, (IStatus)status);
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ExportWizardConstants.WIZARD_WINDOW_TITLE);
        this.exportPage = this.getWizardPage();
        this.exportPage.setDescription(ExportWizardConstants.WIZARD_DESCRIPTION);
        this.addPage((IWizardPage)this.exportPage);
    }

    private ValgrindExportWizardPage getWizardPage() {
        return new ValgrindExportWizardPage(Messages.getString("ValgrindExportWizard.Page_name"), ExportWizardConstants.WIZARD_TITLE, null);
    }
}

