/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DisableShortcutsWorkaround
implements IStartup {
    private static final String LSP4E_COMMAND_ID_PREFIX = "org.eclipse.lsp4e";

    public void earlyStartup() {
        if (this.isPlatformKeybindingBug517068Fixed()) {
            return;
        }
        final IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (service != null) {
            Binding[] bindings;
            final ArrayList<Binding> newBindings = new ArrayList<Binding>();
            Binding[] bindingArray = bindings = service.getBindings();
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                String commandId = null;
                if (binding != null && binding.getParameterizedCommand() != null && binding.getParameterizedCommand().getCommand() != null) {
                    commandId = binding.getParameterizedCommand().getCommand().getId();
                    if (commandId == null) {
                        newBindings.add(binding);
                    } else if (!commandId.startsWith(LSP4E_COMMAND_ID_PREFIX)) {
                        newBindings.add(binding);
                    } else {
                        Collection conflicts = service.getConflictsFor(binding.getTriggerSequence());
                        if (conflicts == null || conflicts.size() == 0) {
                            newBindings.add(binding);
                        }
                    }
                } else {
                    newBindings.add(binding);
                }
                ++n2;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        service.savePreferences(service.getActiveScheme(), newBindings.toArray(new Binding[newBindings.size()]));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private boolean isPlatformKeybindingBug517068Fixed() {
        Version fixVersion;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.e4.ui.bindings");
        Version currentVersion = bundle.getVersion();
        return currentVersion.compareTo(fixVersion = new Version(0, 12, 1)) >= 0;
    }
}

