/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.diagnostics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class LSPDiagnosticsToMarkers
implements Consumer<PublishDiagnosticsParams> {
    public static final String LSP_DIAGNOSTIC = "lspDiagnostic";
    public static final String LANGUAGE_SERVER_ID = "languageServerId";
    public static final String LS_DIAGNOSTIC_MARKER_TYPE = "org.eclipse.lsp4e.diagnostic";
    private final @NonNull String languageServerId;

    public LSPDiagnosticsToMarkers(@NonNull String serverId) {
        this.languageServerId = serverId;
    }

    @Deprecated
    public LSPDiagnosticsToMarkers(IProject project, @NonNull String serverId) {
        this(serverId);
    }

    @Override
    public void accept(PublishDiagnosticsParams diagnostics) {
        try {
            String uri = diagnostics.getUri();
            final IResource resource = LSPEclipseUtils.findResourceFor(uri);
            if (resource == null || !resource.exists()) {
                return;
            }
            final HashSet<IMarker> toDeleteMarkers = new HashSet<IMarker>(Arrays.asList(resource.findMarkers(LS_DIAGNOSTIC_MARKER_TYPE, false, 1)));
            toDeleteMarkers.removeIf(marker -> !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID, ""), this.languageServerId));
            final ArrayList<Diagnostic> newDiagnostics = new ArrayList<Diagnostic>();
            final HashMap<IMarker, Diagnostic> toUpdate = new HashMap<IMarker, Diagnostic>();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                IMarker associatedMarker = this.getExistingMarkerFor(resource, diagnostic, toDeleteMarkers);
                if (associatedMarker == null) {
                    newDiagnostics.add(diagnostic);
                    continue;
                }
                toDeleteMarkers.remove(associatedMarker);
                toUpdate.put(associatedMarker, diagnostic);
            }
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (Diagnostic diagnostic : newDiagnostics) {
                        IMarker marker = resource.createMarker(LSPDiagnosticsToMarkers.LS_DIAGNOSTIC_MARKER_TYPE);
                        LSPDiagnosticsToMarkers.this.updateMarker(resource, diagnostic, marker);
                    }
                    for (Map.Entry entry : toUpdate.entrySet()) {
                        LSPDiagnosticsToMarkers.this.updateMarker(resource, (Diagnostic)entry.getValue(), (IMarker)entry.getKey());
                    }
                    toDeleteMarkers.forEach(t -> {
                        try {
                            t.delete();
                        }
                        catch (CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    });
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    protected void updateMarker(IResource resource, Diagnostic diagnostic, IMarker marker) {
        try {
            int end;
            if (resource.getType() != 1) {
                return;
            }
            IFile file = (IFile)resource;
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer == null) {
                manager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            }
            IDocument document = textFileBuffer.getDocument();
            int start = Math.min(LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), document), document.getLength());
            if (start == (end = Math.min(LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), document), document.getLength())) && document.getLength() > end && document.getLineOfOffset(++end) != document.getLineOfOffset(start)) {
                --start;
                --end;
            }
            HashMap<String, Object> targetAttributes = new HashMap<String, Object>(7);
            targetAttributes.put(LSP_DIAGNOSTIC, diagnostic);
            targetAttributes.put(LANGUAGE_SERVER_ID, this.languageServerId);
            targetAttributes.put("message", diagnostic.getMessage());
            targetAttributes.put("severity", LSPEclipseUtils.toEclipseMarkerSeverity(diagnostic.getSeverity()));
            targetAttributes.put("charStart", start);
            targetAttributes.put("charEnd", end);
            targetAttributes.put("lineNumber", document.getLineOfOffset(start) + 1);
            if (!targetAttributes.equals(marker.getAttributes())) {
                marker.setAttributes(targetAttributes);
            }
        }
        catch (CoreException | BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private IMarker getExistingMarkerFor(IResource resource, Diagnostic diagnostic, Set<IMarker> remainingMarkers) {
        ITextFileBuffer textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (textFileBuffer == null) {
            return null;
        }
        IDocument document = textFileBuffer.getDocument();
        for (IMarker marker : remainingMarkers) {
            int startOffset = MarkerUtilities.getCharStart((IMarker)marker);
            int endOffset = MarkerUtilities.getCharEnd((IMarker)marker);
            try {
                if (LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), document) != startOffset || LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), document) != endOffset || !Objects.equals(marker.getAttribute("message"), diagnostic.getMessage()) || !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID), this.languageServerId)) continue;
                return marker;
            }
            catch (CoreException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }
}

