/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistryReader<D>
implements IExtensionChangeHandler {
    Set<D> delegates = new HashSet<D>();

    protected RegistryReader() {
    }

    protected final void init(IExtensionTracker tracker, String extensionPointIdentifier) {
        final IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(extensionPointIdentifier);
        if (tracker != null) {
            tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extensionPoint));
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        Arrays.sort(extensions, new Comparator<IExtension>(){

            @Override
            public int compare(IExtension e1, IExtension e2) {
                String ns = extensionPoint.getNamespaceIdentifier();
                if (ns.equals(e1.getNamespaceIdentifier())) {
                    return -1;
                }
                if (ns.equals(e2.getNamespaceIdentifier())) {
                    return 1;
                }
                return 0;
            }
        });
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(tracker, extension);
            ++n2;
        }
    }

    public final void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] configs = extension.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            String name = extension.getNamespaceIdentifier();
            if (!"org.eclipse.mat.eclipse".equals(name) && !"org.eclipse.mat.jetty".equals(name)) {
                try {
                    D delegate = this.createDelegate(configs[i]);
                    if (delegate != null) {
                        this.delegates.add(delegate);
                        if (tracker != null) {
                            tracker.registerObject(extension, delegate, 2);
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format(Messages.RegistryReader_Error_Registry, configs[i]), e);
                }
            }
            ++i;
        }
    }

    public final void removeExtension(IExtension extension, Object[] objects) {
        int ii = 0;
        while (ii < objects.length) {
            if (this.delegates.remove(objects[ii])) {
                this.removeDelegate(objects[ii]);
            }
            ++ii;
        }
    }

    protected abstract D createDelegate(IConfigurationElement var1) throws CoreException;

    protected abstract void removeDelegate(D var1);

    public Collection<D> delegates() {
        return Collections.unmodifiableCollection(this.delegates);
    }
}

