/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.SnapshotArgument;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.mat.ui.snapshot.OpenSnapshot;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class SnapshotSelectionEditor
extends ArgumentEditor {
    private CCombo combo;
    private Button button;
    private SnapshotArgument snapshot;

    public SnapshotSelectionEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        super(parent, context, descriptor, item);
        this.createContents();
    }

    private void createContents() {
        this.setFont(this.getParent().getFont());
        this.setBackground(this.getParent().getBackground());
        this.createComboBox();
        this.button = new Button((Composite)this, 0);
        this.button.setText("...");
        this.button.setFont(this.getParent().getFont());
        this.setLayout(new XLayout());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SnapshotSelectionEditor.this.openDialogBox();
            }
        });
    }

    private void createComboBox() {
        this.combo = new CCombo((Composite)this, 64);
        this.combo.setFont(this.getParent().getFont());
        this.combo.setBackground(this.getParent().getBackground());
        for (SnapshotHistoryService.Entry entry : SnapshotHistoryService.getInstance().getVisitedEntries()) {
            if (!"org.eclipse.mat.ui.editors.HeapEditor".equals(entry.getEditorId())) continue;
            this.combo.add(entry.getFilePath());
        }
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SnapshotSelectionEditor.this.editingDone();
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnapshotSelectionEditor.this.editingDone();
            }
        });
    }

    protected void editingDone() {
        String path = this.combo.getText().trim();
        if (path.length() > 0 && !new File(path).exists()) {
            this.fireErrorEvent(MessageUtil.format((String)Messages.SnapshotSelectionEditor_FileDoesNotExist, (Object[])new Object[]{path}), this);
        } else {
            this.snapshot = path.length() > 0 ? new SnapshotArgument(path) : null;
            this.fireValueChangedEvent(this.snapshot, this);
        }
    }

    private void openDialogBox() {
        boolean successful = new OpenSnapshot.Visitor(){

            public void visit(IFileStore fileStore) {
                String path = fileStore.toString();
                SnapshotSelectionEditor.this.combo.setText(path);
                SnapshotSelectionEditor.this.combo.add(path, 0);
            }
        }.go(this.getShell());
        if (successful) {
            this.editingDone();
        }
    }

    public Object getValue() {
        return this.snapshot;
    }

    public void setValue(Object value) throws SnapshotException {
        this.snapshot = (SnapshotArgument)value;
        this.combo.setText(this.snapshot.getFilename());
    }

    public boolean setFocus() {
        return this.combo.setFocus();
    }

    private class XLayout
    extends Layout {
        private XLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = SnapshotSelectionEditor.this.button.computeSize(-1, -1, force);
            if (SnapshotSelectionEditor.this.combo != null) {
                SnapshotSelectionEditor.this.combo.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            SnapshotSelectionEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = SnapshotSelectionEditor.this.combo.computeSize(-1, -1, force);
            Point buttonSize = SnapshotSelectionEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

