/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2014 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
*******************************************************************************/

package org.eclipse.ocl.parser.backtracking;

/**
 * The backtracking variant of the OCL parser parse table.
 * 
 * @noextend This class is not intended to be subclassed by clients.
 * 
 * @since 1.3
 */
@SuppressWarnings("nls")
public class OCLBacktrackingParserprs implements lpg.runtime.ParseTable, OCLBacktrackingParsersym {
    public final static int ERROR_SYMBOL = 1;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 53;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 54;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 29;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 263;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 80;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 4841;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 1;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 345;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 127;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 207;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 4044;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 7;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 71;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 71;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 4495;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 4496;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return OCLBacktrackingParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,1,0,0,0,1,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,1,0,1,1,0,0,
            0,0,0,1,0,1,0,0,1,0,
            0,0,0,0,0,0,1,0,0,0,
            0,0,0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            12,13,127,9,10,15,17,18,11,29,
            30,31,32,33,38,39,40,41,42,43,
            44,46,47,48,49,50,51,52,53,54,
            59,60,61,86,88,89,90,91,100,83,
            84,85,80,81,82,77,78,79,74,75,
            76,71,72,73,68,69,70,65,66,67,
            24,55,62,63,64,21,125,6,8,14,
            25,56,99,57,16,22,23,58,97,94,
            28,87,113,114,115,116,27,36,37,95,
            96,103,105,26,34,35,98,101,102,109,
            118,119,120,123,124,2,3,4,19,20,
            45,92,93,104,106,107,108,110,111,112,
            117,121,122,126,1,5,7
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,1,0,0,0,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,0,0,0,1,0,0,
            1,1,1,1,1,1,1,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,1,1,1,1,1,1,1,
            1,0,1,1,0,0,1,1,1,1,
            0,0,0,1,0,1,1,1,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,1,
            4,4,0,1,1,3,1,1,3,1,
            1,1,1,1,1,1,4,1,3,1,
            1,1,2,1,1,1,1,1,1,1,
            1,1,1,1,1,8,10,10,8,10,
            1,1,1,5,6,8,8,7,7,5,
            6,9,1,4,6,4,7,5,0,0,
            1,1,3,1,1,1,1,1,1,1,
            1,1,3,1,3,1,1,1,3,1,
            3,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,3,3,1,3,
            3,3,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,1,3,3,1,
            1,1,2,2,1,2,2,1,1,1,
            1,1,1,3,7,4,1,3,1,1,
            1,1,1,0,1,1,1,1,1,1,
            1,1,1,1,1,1,0,1,1,1,
            0,1,7,2,2,1,6,6,0,1,
            1,3,1,3,1,1,1,2,2,1,
            1,4,1,1,1,3,2,1,3,0,
            1,1,2,1,1,1,7,1,2,3,
            3,3,5,1,2,4,4,5,3,3,
            3,1,2,4,4,4,6,8,0,1,
            1,3,1,1,1,1,4,2,1,4,
            7,5,3,3,3,4,4,3,2,2,
            3,3,4,5,2,1,7,3,3,3,
            3,2,2,5,4,-98,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,-105,1,2,3,-2,-3,6,-15,1,
            2,3,-84,-4,6,-14,-85,1,2,3,
            -90,-10,6,88,89,-17,1,2,3,-16,
            95,96,-99,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,83,84,
            85,86,90,83,84,85,86,-18,107,108,
            -103,1,2,3,-104,1,2,3,-87,-20,
            88,89,-106,1,2,3,-156,95,96,-204,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,-19,-21,80,73,
            71,-230,-26,-28,-30,76,-33,-35,-184,-38,
            -41,-45,93,-136,-42,-43,87,-244,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,73,74,73,74,80,72,
            93,-44,91,76,-46,-47,-48,-49,-51,-39,
            -192,1,2,3,87,-197,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,71,-13,1,2,3,-53,77,6,80,
            -54,-55,-56,-57,-58,-59,-60,-61,-62,-63,
            -64,-131,-68,-69,94,-70,-71,92,-72,-153,
            101,-155,-73,98,99,-198,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,80,73,74,73,74,-74,-75,-76,-80,
            -93,-94,-95,-101,-102,-107,-114,-115,-116,-127,
            -128,-129,101,-132,122,-133,-134,92,-189,-135,
            -217,-137,-226,98,99,-138,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,73,74,73,74,73,74,72,-236,-167,
            1,2,3,78,-187,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            71,73,74,-139,-140,-141,72,-256,-240,1,
            2,3,78,-195,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,71,
            73,74,-142,-143,-144,-145,-146,-147,-148,-149,
            -151,-152,-154,-157,-158,-159,-160,-161,-162,-163,
            -164,88,89,-216,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,-165,
            -166,-170,-171,-172,-173,72,-174,-175,-176,-177,
            -178,78,-219,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-183,-190,
            -191,-196,-199,-202,72,-203,-205,-206,-207,-208,
            78,-220,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,-210,-212,-213,
            -214,-215,-218,72,-221,-222,-223,-224,-225,78,
            -247,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,-231,-234,-235,-237,
            -238,-248,72,-249,-250,-251,-252,-253,78,-92,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-254,-255,-257,-261,-262,
            -263,72,-201,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,0,0,
            0,0,0,0,72,-233,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,92,-243,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,0,0,0,0,0,0,
            72,-22,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,-24,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,-25,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,-50,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-52,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,-77,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,-78,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,-79,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,-83,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-125,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,-150,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,-168,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,-179,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,-180,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-188,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,-194,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,-211,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,-239,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,-241,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-258,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,-259,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,-260,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,-108,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,-124,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,-109,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,-123,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,-110,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,-111,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,-119,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,-120,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,-121,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,-122,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,-112,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,-113,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,-65,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,-66,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,0,0,82,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-88,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-209,
            0,0,0,0,0,0,0,0,0,82,
            -117,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            -118,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            91,-5,82,-1,1,2,3,-245,1,2,
            3,4,5,6,7,8,-37,124,0,-193,
            1,2,3,0,-181,1,2,3,0,0,
            121,-185,1,2,3,0,0,0,0,0,
            0,0,82,-6,-27,-246,1,2,3,4,
            5,6,7,8,0,0,-86,1,2,3,
            4,5,-7,1,2,3,4,5,67,66,
            -29,-31,0,-34,71,0,0,0,0,76,
            77,0,75,80,81,66,83,84,85,86,
            66,0,0,90,91,71,93,66,0,0,
            76,77,71,100,97,81,90,76,77,106,
            67,67,81,0,0,0,113,114,115,116,
            75,118,119,120,68,69,70,0,104,105,
            68,69,70,0,0,104,105,67,67,123,
            67,79,97,-8,1,2,3,4,5,-9,
            1,2,3,4,5,-11,1,2,3,4,
            5,-12,1,2,3,4,5,-23,1,2,
            3,4,5,6,7,8,-32,1,2,3,
            4,5,-100,1,2,3,4,5,6,7,
            8,-169,1,2,3,4,5,6,7,8,
            -182,1,2,3,4,5,6,7,8,0,
            0,68,69,70,0,0,0,68,69,70,
            0,0,79,68,69,70,0,-36,79,68,
            69,70,0,0,79,-96,1,2,3,-40,
            79,0,75,0,68,69,70,-89,1,2,
            3,4,5,0,0,79,0,75,-91,1,
            2,3,4,5,0,0,75,-200,1,2,
            3,4,5,0,0,75,-186,1,2,3,
            4,5,6,7,8,-232,1,2,3,4,
            5,6,7,8,67,-228,1,2,3,-82,
            1,2,3,-81,0,0,71,-97,1,2,
            3,-130,77,-227,-229,68,69,70,-126,1,
            2,3,83,84,85,86,68,69,70,94,
            0,-242,1,2,3,68,69,70,0,100,
            -67,1,2,3,0,0,111,0,0,0,
            0,75,0,0,0,0,117,0,0,0,
            75,66,0,0,0,66,71,0,0,0,
            67,76,77,66,0,0,81,0,67,0,
            67,67,0,0,66,0,0,0,0,0,
            0,0,0,0,0,0,0,66,0,0,
            0,102,103,0,0,0,0,76,0,0,
            0,71,0,0,0,0,109,110,87,0,
            102,103,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,112,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            106,107,107,107,107,107,107,107,107,107,
            107,107,107,107,107,107,108,126,126,126,
            126,126,126,126,126,126,126,126,68,127,
            69,69,69,9,1,1,2,2,70,70,
            6,6,5,5,5,5,5,5,5,5,
            4,4,4,4,4,75,75,75,75,7,
            8,109,109,110,110,76,66,77,71,94,
            94,87,87,81,81,81,81,10,10,10,
            10,11,11,95,95,96,96,88,88,89,
            13,13,13,13,13,13,13,12,111,111,
            15,16,17,17,18,18,19,20,21,14,
            14,14,22,22,24,24,25,25,25,26,
            26,23,23,23,28,28,28,28,28,28,
            28,28,28,30,29,29,31,31,31,74,
            78,78,72,72,61,61,33,32,62,62,
            65,65,63,63,64,64,59,59,58,58,
            60,60,56,56,55,55,57,57,53,53,
            52,52,54,54,50,50,49,49,49,51,
            51,51,47,47,46,46,46,46,46,48,
            48,48,48,48,44,44,43,43,43,45,
            45,45,41,41,40,40,40,42,42,42,
            82,82,34,34,34,35,35,35,27,27,
            36,36,36,36,36,38,37,112,112,106,
            106,106,106,106,106,126,126,126,126,126,
            126,126,126,126,126,126,126,79,79,1,
            5,97,97,28,31,73,74,39,39,98,
            98,99,99,92,92,92,36,113,113,113,
            114,114,93,116,118,119,119,120,115,115,
            117,117,100,100,83,83,83,84,121,121,
            91,91,85,85,101,101,80,80,80,102,
            102,86,123,123,90,90,90,103,122,104,
            104,105,105,67,124,3,1,7,12,111,
            31,38,38,38,38,27,39,39,85,102,
            102,80,80,80,103,103,103,122,122,90,
            90,90,91,91,93,93,79,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,1147,144,809,
            149,798,812,812,417,316,743,3,1153,972,
            40,417,316,609,839,4280,105,972,40,417,
            316,1210,432,802,85,87,822,625,417,316,
            39,1146,1148,127,622,417,316,708,109,702,
            707,111,146,222,77,78,79,80,90,91,
            705,93,94,95,96,220,112,113,114,115,
            709,121,122,123,133,795,221,204,207,626,
            215,223,266,787,803,199,792,801,189,791,
            804,179,794,800,172,793,806,166,797,799,
            160,796,807,154,1147,144,809,149,798,283,
            284,285,286,303,283,284,285,286,1071,16,
            810,972,1151,417,316,972,1152,417,316,1016,
            526,85,87,972,537,417,316,1167,1149,1148,
            254,913,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,795,221,204,207,626,215,223,266,
            787,803,199,792,801,189,791,804,179,794,
            800,172,793,806,166,797,799,160,796,807,
            154,1395,1399,809,149,798,1398,256,693,295,
            1316,1396,1130,835,914,1195,71,1201,1211,1079,
            1219,1198,1020,269,1081,1222,789,1397,483,1068,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            795,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,794,800,172,
            793,806,166,797,799,160,796,807,154,142,
            144,809,149,798,72,892,891,256,134,295,
            1547,268,42,289,71,332,963,956,1139,996,
            795,972,1066,417,316,1546,1,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,265,144,809,
            149,798,70,972,620,417,316,846,69,710,
            294,129,816,318,718,836,510,119,408,640,
            1119,1141,1022,1146,873,99,395,714,261,1153,
            1245,529,1076,842,1389,1391,40,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,265,144,809,
            149,798,294,256,1313,256,1314,1202,1223,902,
            1226,1225,1230,356,204,1034,563,1025,561,1231,
            1232,689,1235,619,1154,4057,1051,1236,261,1245,
            1237,394,1035,980,1392,1391,178,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,142,144,809,
            149,798,256,138,256,1469,892,891,1311,1245,
            972,899,417,316,1310,216,622,417,316,708,
            109,702,707,111,146,222,77,78,79,80,
            90,91,705,93,94,95,96,220,112,113,
            114,115,709,121,122,123,133,795,221,204,
            207,626,215,223,266,787,803,199,792,801,
            189,791,804,179,794,800,172,793,806,166,
            797,799,160,796,807,154,142,144,809,149,
            798,228,256,137,739,764,1157,1311,1013,972,
            899,417,316,1388,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,795,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,796,807,154,1147,144,809,149,798,
            1474,892,891,1238,1239,1109,1240,644,1242,1244,
            969,1160,1162,1246,863,1249,945,1247,968,1041,
            1045,1060,86,87,292,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,795,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,796,807,154,142,144,809,149,798,
            1165,1172,1014,1170,1176,1177,1311,1180,957,1147,
            887,1248,1468,330,622,417,316,708,109,702,
            707,111,146,222,77,78,79,80,90,91,
            705,93,94,95,96,220,112,113,114,115,
            709,121,122,123,133,795,221,204,207,626,
            215,223,266,787,803,199,792,801,189,791,
            804,179,794,800,172,793,806,166,797,799,
            160,796,807,154,142,144,809,149,798,1250,
            1251,1252,242,1253,1255,1311,1260,1254,1262,1263,
            1265,1470,368,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,795,221,204,207,626,215,
            223,266,787,803,199,792,801,189,791,804,
            179,794,800,172,793,806,166,797,799,160,
            796,807,154,142,144,809,149,798,1266,1268,
            1275,1281,1278,1148,1311,1282,167,592,1284,1286,
            1471,445,622,417,316,708,109,702,707,111,
            146,222,77,78,79,80,90,91,705,93,
            94,95,96,220,112,113,114,115,709,121,
            122,123,133,795,221,204,207,626,215,223,
            266,787,803,199,792,801,189,791,804,179,
            794,800,172,793,806,166,797,799,160,796,
            807,154,142,144,809,149,798,826,1289,1288,
            1291,1298,1307,1311,1272,1309,1300,1315,843,1548,
            483,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,795,221,204,207,626,215,223,266,
            787,803,199,792,801,189,791,804,179,794,
            800,172,793,806,166,797,799,160,796,807,
            154,142,144,809,149,798,1301,1182,1316,1319,
            1320,1322,912,483,622,417,316,708,109,702,
            707,111,146,222,77,78,79,80,90,91,
            705,93,94,95,96,220,112,113,114,115,
            709,121,122,123,133,795,221,204,207,626,
            215,223,266,787,803,199,792,801,189,791,
            804,179,794,800,172,793,806,166,797,799,
            160,796,807,154,142,144,809,149,798,4496,
            4496,4496,4496,4496,4496,1393,406,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,265,144,809,
            149,798,4496,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,262,483,
            622,417,316,708,109,702,707,111,146,222,
            77,78,79,80,90,91,705,93,94,95,
            96,220,112,113,114,115,709,121,122,123,
            133,795,221,204,207,626,215,223,266,787,
            803,199,792,801,189,791,804,179,794,800,
            172,793,806,166,797,799,160,796,807,154,
            142,144,809,149,798,4496,4496,4496,4496,4496,
            4496,1478,483,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,795,221,204,207,626,215,
            223,266,787,803,199,792,801,189,791,804,
            179,794,800,172,793,806,166,797,799,160,
            796,807,154,67,144,809,149,798,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            795,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,794,800,172,
            793,806,166,797,799,160,796,807,154,291,
            144,809,149,798,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,795,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,796,807,154,290,144,809,149,798,
            521,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,795,221,204,207,626,215,223,266,
            787,803,199,792,801,189,791,804,179,794,
            800,172,793,806,166,797,799,160,796,807,
            154,894,144,809,149,798,483,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,896,144,809,
            149,798,483,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,795,221,204,207,626,215,
            223,266,787,803,199,792,801,189,791,804,
            179,794,800,172,793,806,166,797,799,160,
            796,807,154,306,144,809,149,798,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            795,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,794,800,172,
            793,806,166,797,799,160,796,807,154,305,
            144,809,149,798,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,795,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,796,807,154,304,144,809,149,798,
            483,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,795,221,204,207,626,215,223,266,
            787,803,199,792,801,189,791,804,179,794,
            800,172,793,806,166,797,799,160,796,807,
            154,296,144,809,149,798,483,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,68,144,809,
            149,798,483,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,795,221,204,207,626,215,
            223,266,787,803,199,792,801,189,791,804,
            179,794,800,172,793,806,166,797,799,160,
            796,807,154,1312,144,809,149,798,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            795,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,794,800,172,
            793,806,166,797,799,160,796,807,154,226,
            144,809,149,798,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,795,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,796,807,154,300,144,809,149,798,
            483,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,795,221,204,207,626,215,223,266,
            787,803,199,792,801,189,791,804,179,794,
            800,172,793,806,166,797,799,160,796,807,
            154,299,144,809,149,798,483,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,143,144,809,
            149,798,483,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,795,221,204,207,626,215,
            223,266,787,803,199,792,801,189,791,804,
            179,794,800,172,793,806,166,797,799,160,
            796,807,154,89,144,809,149,798,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            795,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,794,800,172,
            793,806,166,797,799,160,796,807,154,1467,
            144,809,149,798,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,795,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,796,807,154,1472,144,809,149,798,
            483,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,795,221,204,207,626,215,223,266,
            787,803,199,792,801,189,791,804,179,794,
            800,172,793,806,166,797,799,160,796,807,
            154,1475,144,809,149,798,483,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,795,221,
            204,207,626,215,223,266,787,803,199,792,
            801,189,791,804,179,794,800,172,793,806,
            166,797,799,160,796,807,154,1549,144,809,
            149,798,483,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,795,221,204,207,626,215,
            223,266,787,803,199,792,801,189,791,804,
            179,794,800,172,793,806,166,797,799,160,
            796,807,154,1550,144,809,149,798,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            795,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,794,800,172,
            793,806,166,797,799,160,796,807,154,1551,
            144,809,149,798,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,1154,221,204,207,
            626,215,223,266,787,803,199,792,801,189,
            791,804,179,794,800,172,793,806,166,797,
            799,160,156,1155,155,483,622,417,316,708,
            109,702,707,111,146,222,77,78,79,80,
            90,91,705,93,94,95,96,220,112,113,
            114,115,709,121,122,123,133,1240,221,204,
            207,626,215,223,266,787,803,199,792,801,
            189,791,804,179,794,800,172,793,806,166,
            162,1241,161,483,622,417,316,708,109,702,
            707,111,146,222,77,78,79,80,90,91,
            705,93,94,95,96,220,112,113,114,115,
            709,121,122,123,133,1156,221,204,207,626,
            215,223,266,787,803,199,792,801,189,791,
            804,179,794,800,172,168,1157,167,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            1238,221,204,207,626,215,223,266,787,803,
            199,792,801,189,791,804,179,174,1239,173,
            483,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,1158,221,204,207,626,215,223,266,
            787,803,199,792,801,189,182,1159,181,483,
            622,417,316,708,109,702,707,111,146,222,
            77,78,79,80,90,91,705,93,94,95,
            96,220,112,113,114,115,709,121,122,123,
            133,1158,221,204,207,626,215,223,266,787,
            803,199,792,801,189,182,1160,180,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            1232,221,204,207,626,215,223,266,787,803,
            199,194,1233,193,483,622,417,316,708,109,
            702,707,111,146,222,77,78,79,80,90,
            91,705,93,94,95,96,220,112,113,114,
            115,709,121,122,123,133,1232,221,204,207,
            626,215,223,266,787,803,199,194,1234,192,
            483,622,417,316,708,109,702,707,111,146,
            222,77,78,79,80,90,91,705,93,94,
            95,96,220,112,113,114,115,709,121,122,
            123,133,1232,221,204,207,626,215,223,266,
            787,803,199,194,1235,191,483,622,417,316,
            708,109,702,707,111,146,222,77,78,79,
            80,90,91,705,93,94,95,96,220,112,
            113,114,115,709,121,122,123,133,1232,221,
            204,207,626,215,223,266,787,803,199,194,
            1237,190,483,622,417,316,708,109,702,707,
            111,146,222,77,78,79,80,90,91,705,
            93,94,95,96,220,112,113,114,115,709,
            121,122,123,133,1161,221,204,207,626,215,
            223,266,202,1230,201,483,622,417,316,708,
            109,702,707,111,146,222,77,78,79,80,
            90,91,705,93,94,95,96,220,112,113,
            114,115,709,121,122,123,133,1161,221,204,
            207,626,215,223,266,202,1231,200,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            897,221,210,217,626,215,223,266,483,622,
            417,316,708,109,702,707,111,146,222,77,
            78,79,80,90,91,705,93,94,95,96,
            220,112,113,114,115,709,121,122,123,133,
            897,221,210,216,626,215,223,266,4496,4496,
            214,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,547,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            84,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            213,483,622,417,316,708,109,702,707,111,
            146,222,77,78,79,80,90,91,705,93,
            94,95,96,220,112,113,114,115,709,121,
            122,123,133,897,221,210,209,626,215,223,
            266,483,622,417,316,708,109,702,707,111,
            146,222,77,78,79,80,90,91,705,93,
            94,95,96,220,112,113,114,115,709,121,
            122,123,133,897,221,210,208,626,215,223,
            266,288,1094,206,891,424,417,316,735,40,
            417,316,888,55,889,57,58,66,907,4496,
            972,1144,417,316,4496,165,424,417,316,4496,
            4496,612,937,424,417,316,4496,4496,4496,4496,
            4496,4496,4496,205,1098,1112,559,40,417,316,
            888,55,889,57,58,4496,4496,787,38,417,
            906,30,31,584,38,417,316,30,31,343,
            75,1116,1121,4496,1127,76,4496,4496,4496,4496,
            73,74,4496,252,230,233,64,282,284,285,
            286,75,4496,4496,231,232,76,270,75,4496,
            4496,73,74,76,426,307,311,302,73,74,
            416,342,341,311,4496,4496,4496,608,267,530,
            271,252,436,607,440,32,39,904,4496,1318,
            1319,32,39,4085,4496,4496,1320,1319,340,339,
            423,332,613,308,610,38,417,316,30,31,
            635,38,417,316,30,31,660,38,417,316,
            30,31,685,38,417,316,30,31,762,40,
            417,316,888,55,889,57,58,710,38,417,
            316,30,31,762,40,417,316,888,55,889,
            57,58,762,40,417,316,888,55,889,57,
            58,762,40,417,316,888,55,889,57,58,
            4496,4496,32,39,4111,4496,4496,4496,32,39,
            4112,4496,4496,614,32,39,4114,4496,1132,615,
            32,39,4268,4496,4496,617,1043,1066,417,316,
            1105,618,4496,813,4496,32,39,4344,787,38,
            417,316,30,31,4496,4496,890,4496,1150,787,
            38,417,316,30,31,4496,4496,1317,787,38,
            417,316,30,31,4496,4496,66,762,40,417,
            316,888,55,889,57,58,762,40,417,316,
            888,55,889,57,58,331,972,424,417,316,
            1026,4352,417,316,1150,4496,4496,70,117,1144,
            417,316,922,69,1189,1192,32,39,41,1026,
            4352,417,316,282,284,285,286,32,39,624,
            98,4496,972,1477,417,316,32,39,911,4496,
            431,972,899,417,316,4496,4496,1064,4496,4496,
            4496,4496,3950,4496,4496,4496,4496,3934,4496,4496,
            4496,264,75,4496,4496,4496,901,76,4496,4496,
            4496,333,73,74,63,4496,4496,312,4496,330,
            4496,334,337,4496,4496,901,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,72,4496,
            4496,4496,297,900,4496,4496,4496,4496,71,4496,
            4496,4496,227,4496,4496,4496,4496,1143,1145,1476,
            4496,298,900,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,898,4496,0
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,0,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,0,25,28,29,
            30,31,32,33,34,35,36,37,0,0,
            1,0,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,0,66,28,29,30,
            31,32,33,34,35,36,37,39,0,1,
            39,3,4,0,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,0,66,28,29,30,31,
            32,33,34,35,36,37,0,1,0,3,
            55,5,6,7,59,60,0,1,0,3,
            4,53,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,69,70,28,29,30,31,32,33,
            34,35,36,37,0,1,0,3,64,5,
            6,7,54,45,46,47,48,0,1,53,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,0,1,28,29,30,31,32,
            33,34,35,36,37,0,1,51,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,0,1,28,29,30,31,32,33,34,
            35,36,37,0,1,0,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,76,
            25,28,29,30,31,32,33,34,35,36,
            37,0,1,0,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,0,77,28,
            29,30,31,32,33,34,35,36,37,0,
            1,0,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,0,25,28,29,30,
            31,32,33,34,35,36,37,0,1,52,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,0,0,28,29,30,31,32,
            33,34,35,36,37,0,1,0,3,4,
            55,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,0,39,28,29,30,31,32,33,34,
            35,36,37,50,0,1,52,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            63,66,28,29,30,31,32,33,34,35,
            36,37,0,1,0,3,4,56,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,0,0,
            28,29,30,31,32,33,34,35,36,37,
            0,1,0,3,4,0,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,0,1,28,29,
            30,31,32,33,34,35,36,37,0,1,
            0,3,0,1,6,7,57,5,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,0,1,2,3,27,0,6,
            7,0,67,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,0,0,
            1,2,3,55,68,6,7,59,60,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,0,1,2,3,78,0,
            6,7,51,0,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,0,
            1,2,3,55,73,6,7,59,60,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,0,1,2,3,0,1,
            6,7,0,54,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,0,
            1,2,3,0,26,6,7,0,75,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,0,1,0,3,0,0,
            6,7,0,26,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,67,
            26,0,1,0,3,27,49,6,7,0,
            57,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,0,1,0,3,
            27,53,6,7,0,1,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,0,1,71,3,0,53,6,7,8,
            9,0,1,8,3,0,1,6,7,41,
            42,43,44,39,0,0,2,26,0,28,
            2,0,0,8,9,0,25,5,0,38,
            56,40,58,38,9,61,45,46,47,48,
            49,26,0,52,26,54,0,26,57,27,
            8,9,0,38,63,40,41,42,43,44,
            45,46,47,48,49,40,0,52,26,54,
            0,1,57,3,8,9,6,7,63,74,
            38,0,40,41,42,43,44,45,46,47,
            48,49,26,0,52,2,54,45,46,47,
            48,0,1,2,38,4,40,41,42,43,
            44,45,46,47,48,49,0,1,52,3,
            39,5,6,7,0,55,56,0,58,59,
            60,61,8,9,64,0,0,67,0,69,
            70,71,0,1,8,9,4,0,0,1,
            26,0,1,5,3,8,9,6,7,0,
            0,2,38,4,40,41,42,43,44,45,
            46,47,48,49,38,0,40,41,42,43,
            44,45,46,47,48,38,27,40,41,42,
            43,44,0,0,2,0,4,0,39,0,
            65,0,9,4,0,0,1,65,3,50,
            51,6,7,0,0,1,41,42,43,44,
            0,62,0,1,0,3,0,0,6,7,
            0,39,73,40,41,42,43,44,39,0,
            39,27,50,51,0,41,42,43,44,50,
            0,56,2,58,62,0,61,56,0,58,
            0,62,61,0,4,45,46,47,48,45,
            46,47,48,0,1,2,26,0,1,2,
            41,42,43,44,0,55,72,74,0,59,
            60,0,1,2,39,0,1,2,0,39,
            0,1,2,0,0,50,0,1,2,0,
            50,0,1,2,56,27,58,62,0,61,
            0,71,4,39,26,0,0,0,8,0,
            1,2,0,0,9,2,0,4,2,0,
            1,0,1,4,0,4,0,49,64,0,
            4,0,26,9,27,0,0,8,38,0,
            9,0,26,8,8,40,5,8,0,1,
            2,0,1,2,0,49,2,0,69,70,
            0,0,2,65,40,4,9,38,27,0,
            0,40,2,38,38,63,50,38,0,72,
            2,0,0,2,0,0,4,2,4,0,
            0,0,2,4,0,0,0,0,0,0,
            2,0,5,0,0,0,0,0,0,0,
            0,0,0,0,0,5,4,26,4,0,
            26,0,0,4,0,0,5,0,27,5,
            5,0,5,64,0,26,2,0,27,26,
            0,0,5,0,39,0,5,0,0,27,
            0,4,53,5,50,5,53,0,52,0,
            0,54,5,68,68,57,0,27,0,0,
            27,5,27,5,0,0,2,0,0,0,
            5,0,51,5,5,0,5,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            51,51,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            4496,4811,35,4532,2056,259,4745,4530,3878,4602,
            4546,4547,4548,4549,4550,4541,4539,4542,4540,4538,
            706,4543,4545,4544,4746,4598,4496,4533,3838,4596,
            4597,4529,1990,4381,4600,4601,4604,4603,278,4496,
            4811,4496,4532,2056,259,4745,4530,3878,4602,4546,
            4547,4548,4549,4550,4541,4539,4542,4540,4538,706,
            4543,4545,4544,4746,4598,4496,1390,3838,4596,4597,
            4529,1990,4381,4600,4601,4604,4603,621,4496,4811,
            4299,4532,2056,4496,4745,4530,3878,4602,4546,4547,
            4548,4549,4550,4541,4539,4542,4540,4538,706,4543,
            4545,4544,4746,4598,273,1390,3838,4596,4597,4529,
            1990,4381,4600,4601,4604,4603,4496,4811,158,4532,
            4190,61,4745,4530,4184,4103,4496,4811,176,4532,
            2056,83,4745,4530,3878,4602,4546,4547,4548,4549,
            4550,4541,4539,4542,4540,4538,706,4543,4545,4544,
            4746,4598,4042,4084,3838,4596,4597,4529,1990,4381,
            4600,4601,4604,4603,4496,4811,4496,4532,783,309,
            4745,4530,162,182,182,182,182,4496,4811,83,
            4532,2056,140,4745,4530,3878,4602,4546,4547,4548,
            4549,4550,4541,4539,4542,4540,4538,706,4543,4545,
            4544,4746,4598,4496,4819,3838,4596,4597,4529,1990,
            4381,4600,4601,4604,4603,4496,4811,2914,4532,2056,
            140,4745,4530,3878,4602,4546,4547,4548,4549,4550,
            4541,4539,4542,4540,4538,706,4543,4545,4544,4746,
            4598,4496,4818,3838,4596,4597,4529,1990,4381,4600,
            4601,4604,4603,4496,4811,4496,4532,2056,4620,4745,
            4530,3878,4602,4546,4547,4548,4549,4550,4541,4539,
            4542,4540,4538,706,4543,4545,4544,4746,4598,2452,
            4773,3838,4596,4597,4529,1990,4381,4600,4601,4604,
            4603,4496,4811,4496,4532,2056,140,4745,4530,3878,
            4602,4546,4547,4548,4549,4550,4541,4539,4542,4540,
            4538,706,4543,4545,4544,4746,4598,164,2848,3838,
            4596,4597,4529,1990,4381,4600,4601,4604,4603,4496,
            4811,92,4532,2056,140,4745,4530,3878,4602,4546,
            4547,4548,4549,4550,4541,4539,4542,4540,4538,706,
            4543,4545,4544,4746,4598,4496,4599,3838,4596,4597,
            4529,1990,4381,4600,4601,4604,4603,4496,4811,168,
            4532,2056,140,4745,4530,3878,4602,4546,4547,4548,
            4549,4550,4541,4539,4542,4540,4538,706,4543,4545,
            4544,4746,4598,139,4496,3838,4596,4597,4529,1990,
            4381,4600,4601,4604,4603,4496,4811,4496,4532,2056,
            4751,4745,4530,3878,4602,4546,4547,4548,4549,4550,
            4541,4539,4542,4540,4538,706,4543,4545,4544,4746,
            4598,4496,41,3838,4596,4597,4529,1990,4381,4600,
            4601,4604,4603,893,4496,4811,3418,4532,2056,140,
            4745,4530,3878,4602,4546,4547,4548,4549,4550,4541,
            4539,4542,4540,4538,706,4543,4545,4544,4746,4598,
            3244,1390,3838,4596,4597,4529,1990,4381,4600,4601,
            4604,4603,4496,4811,4496,4532,2056,4217,4745,4530,
            3878,4602,4546,4547,4548,4549,4550,4541,4539,4542,
            4540,4538,706,4543,4545,4544,4746,4598,4496,152,
            3838,4596,4597,4529,1990,4381,4600,4601,4604,4603,
            4496,895,4496,4532,2056,4496,4745,4530,3878,4602,
            4546,4547,4548,4549,4550,4541,4539,4542,4540,4538,
            706,4543,4545,4544,4746,4598,4496,910,3838,4596,
            4597,4529,1990,4381,4600,4601,4604,4603,4496,4811,
            4496,4532,4496,4821,4745,4530,156,4720,4546,4547,
            4548,4549,4550,4541,4539,4542,4540,4538,887,4543,
            4545,4544,4746,4496,4811,247,4532,990,4496,4745,
            4530,4496,419,4546,4547,4548,4549,4550,4541,4539,
            4542,4540,4538,4524,4543,4545,4544,4746,301,4496,
            4811,247,4532,251,4768,4745,4530,251,251,4546,
            4547,4548,4549,4550,4541,4539,4542,4540,4538,4524,
            4543,4545,4544,4746,4496,4811,247,4532,2518,4496,
            4745,4530,2980,88,4546,4547,4548,4549,4550,4541,
            4539,4542,4540,4538,4524,4543,4545,4544,4746,4496,
            4811,247,4532,4190,1069,4745,4530,4184,4103,4546,
            4547,4548,4549,4550,4541,4539,4542,4540,4538,4524,
            4543,4545,4544,4746,4496,4811,247,4532,4496,4825,
            4745,4530,229,3363,4546,4547,4548,4549,4550,4541,
            4539,4542,4540,4538,4524,4543,4545,4544,4746,4496,
            4811,247,4532,4496,2650,4745,4530,170,2782,4546,
            4547,4548,4549,4550,4541,4539,4542,4540,4538,4524,
            4543,4545,4544,4746,4496,4811,4496,4532,4496,4496,
            4745,4530,4496,174,4546,4547,4548,4549,4550,4541,
            4539,4542,4540,4538,887,4543,4545,4544,4746,419,
            251,4496,4811,315,4532,711,174,4745,4530,4496,
            3305,4546,4547,4548,4549,4550,4541,4539,4542,4540,
            4538,887,4543,4545,4544,4746,4496,4811,212,4532,
            319,4593,4745,4530,4496,4824,4546,4547,4548,4549,
            4550,4541,4539,4542,4540,4538,4524,4543,4545,4544,
            4746,4496,4811,4495,4532,184,319,4745,4530,4509,
            4510,4496,4811,194,4532,4496,4817,4745,4530,218,
            218,218,218,4097,4496,145,2122,4506,65,4499,
            4208,66,4496,195,203,196,275,4622,4496,4508,
            4196,4511,4202,194,202,432,4505,4502,4504,4503,
            4507,175,157,4497,1792,4500,4496,2386,4501,2716,
            195,203,4496,195,4498,203,219,219,219,219,
            183,183,183,183,175,202,163,169,175,163,
            4496,4811,157,4532,195,203,518,4530,151,4721,
            195,56,203,219,219,219,219,183,183,183,
            183,175,175,4496,169,2188,163,3706,3660,3614,
            3568,4496,1309,4241,195,4065,203,219,219,219,
            219,183,183,183,183,175,4496,4811,169,4532,
            4288,309,4745,4530,169,4190,4196,4496,4202,4184,
            4103,432,195,203,783,110,175,419,4496,4042,
            4084,234,4496,4814,195,203,4348,183,4496,4813,
            175,4496,4811,4555,4532,195,203,4745,4530,147,
            4496,4208,195,139,203,219,219,219,219,183,
            183,183,183,175,195,4496,203,219,219,219,
            219,183,183,183,183,195,628,203,219,219,
            219,219,147,195,4241,292,139,4496,40,147,
            346,4496,203,139,211,4496,902,4276,4532,893,
            65,4745,4530,315,4496,4816,533,412,521,525,
            178,1480,4496,1065,177,4532,4496,4496,4745,4530,
            316,40,65,203,219,219,219,219,40,203,
            4288,2716,893,65,4496,219,219,219,219,893,
            274,4196,249,4202,1480,139,432,4196,293,4202,
            139,1480,432,4496,995,3706,3660,3614,3568,3706,
            3660,3614,3568,4496,4809,1858,249,4496,4809,1924,
            219,219,219,219,280,338,909,4820,62,338,
            338,4496,4809,248,40,4496,4809,248,4496,41,
            4496,4809,248,4496,4496,893,4496,4809,248,287,
            893,4496,4809,248,4196,4060,4202,1553,4496,432,
            4496,249,4223,4288,3519,4496,171,4496,3752,4496,
            4809,248,148,41,4001,4317,4496,4072,4232,4496,
            4823,4496,4822,716,198,816,4496,3470,783,188,
            540,197,3519,4001,2716,187,186,3752,3795,185,
            4001,4496,1792,3752,3752,3961,4623,3752,4496,4809,
            4048,4496,4809,4086,4496,3470,2254,4496,4042,4084,
            4496,4496,4340,443,3961,4348,4775,3795,2716,281,
            4496,3961,2320,3795,3795,150,893,3795,40,989,
            427,4496,4496,4772,4496,4496,4223,4359,916,254,
            4496,4496,4232,256,315,4496,345,4496,4496,4496,
            4241,84,4556,4496,139,4496,165,159,153,313,
            4496,141,4496,4496,136,4626,1164,2584,1243,4496,
            336,4496,310,1322,4496,4496,4354,4496,1074,4355,
            4627,4496,4754,783,263,335,4326,4496,2716,2386,
            260,4496,4753,72,4308,144,4621,135,4496,4336,
            4496,1401,4578,4624,893,4625,4577,4496,3418,4496,
            4496,3363,4749,4840,314,3305,4496,1626,4496,4496,
            4372,4615,1719,4612,65,4496,4241,4496,4496,4496,
            4628,4496,3046,4616,4614,4496,4613,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            4496,4496,4496,4496,4496,4496,4496,4496,4496,4496,
            3112,3178
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            458,166,56,105,536,536,518,518,518,111,
            518,518,246,164,246,113,30,116,34,103,
            102,217,231,217,217,537,536,537,536,537,
            536,518,537,536,537,536,211,366,367,539,
            54,537,63,371,59,125,168,172,169,217,
            349,217,67,71,69,77,75,63,79,78,
            251,253,255,258,217,217,246,53,400,261,
            263,80,275,360,360,268,217,217,217,537,
            536,246,217,206,246,231,96,322,231,321,
            231,217,360,282,213,246,434,1,1,231,
            325,328,246,246,36,246,437,217,217,217,
            217,217,217,63,354,537,217,217,217,217,
            217,217,217,217,217,246,493,492,357,358,
            368,365,362,323,101,60,373,405,442,440,
            122,438,537,108,443,445,442,443,437,217,
            359,359,265,371,59,265,63,79,63,77,
            63,71,71,63,67,67,246,217,231,63,
            69,69,69,69,63,75,63,78,217,217,
            434,231,315,96,434,231,405,217,62,438,
            108,246,246,217,217,449,215,215,360,231,
            217,282,360,405,493,438,108,438,471,438,
            217,438,107,108,438,405,60,374,405,405,
            438,280,279,278,108,377,536,246,536,160,
            452,231,216,438,282,62,438,438,217,246,
            217,246,217,217,474,495,405,438,280,438,
            280,455,108,280,108,378,438,217,217,217,
            438,438,438
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            53,33,8,28,4,32,10,11,12,13,
            14,20,36,37,9,34,35,30,29,19,
            16,18,15,17,21,23,22,24,31,7,
            6,1,3,25,0,3,1,7,6,52,
            63,28,54,57,46,48,47,45,26,49,
            38,8,40,9,0,2,73,25,62,39,
            4,50,41,42,43,44,9,40,38,8,
            45,46,47,48,26,49,52,54,57,63,
            5,53,72,51,27,75,76,77,74,78,
            55,59,60,69,70,64,1,58,56,61,
            68,71,67,0,71,26,2,5,27,0,
            56,0,67,39,0,3,25,6,7,1,
            71,26,2,0,38,8,9,40,45,46,
            26,47,48,49,5,53,72,41,51,27,
            42,75,43,44,76,77,74,52,54,57,
            63,78,58,55,59,56,60,61,25,68,
            1,70,69,67,64,71,0,1,4,65,
            0,38,8,9,40,45,46,26,47,48,
            49,5,53,72,41,51,27,42,75,43,
            44,76,77,74,52,54,57,63,78,58,
            56,69,70,61,65,64,67,68,71,1,
            59,60,55,0,5,66,33,8,28,4,
            32,36,37,9,34,35,25,30,29,31,
            19,16,18,15,17,21,23,22,24,10,
            11,12,13,14,20,7,6,1,3,0,
            63,0,54,0,26,49,0,38,8,0,
            52,0,57,0,4,50,0,55,59,60,
            69,70,1,39,5,71,26,27,73,51,
            0,4,38,8,9,40,45,46,47,48,
            49,5,53,72,41,51,27,42,75,43,
            44,76,77,74,52,54,57,63,78,55,
            59,60,69,70,26,58,67,56,61,71,
            64,1,68,0,76,1,0,38,8,9,
            40,45,46,26,47,48,49,4,62,39,
            50,76,52,54,57,63,1,74,41,42,
            44,43,0,78,27,0,26,2,1,4,
            0,55,59,60,4,2,1,58,56,61,
            39,0,1,72,27,0,73,38,8,9,
            40,26,49,5,41,27,42,43,44,52,
            54,57,63,51,39,4,50,2,62,45,
            46,47,48,0,33,8,28,4,32,10,
            11,12,13,14,20,36,37,9,34,35,
            25,30,29,19,16,18,15,17,21,23,
            22,24,31,7,6,3,1,5,0,26,
            2,27,53,0,53,27,75,0,77,1,
            0,74,1,0,51,2,0,71,6,67,
            64,58,56,61,55,59,60,7,1,3,
            70,69,0,19,16,18,15,17,21,23,
            22,24,3,7,6,10,11,12,13,14,
            20,1,26,0,55,59,60,19,16,18,
            15,17,21,23,22,24,3,1,7,6,
            10,11,12,13,14,20,0,10,11,12,
            13,14,19,16,18,15,17,21,23,22,
            24,20,3,7,6,1,2,0,68,1,
            64,39,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            90,18,18,18,88,88,17,17,17,18,
            17,17,30,6,17,18,17,18,18,10,
            10,14,16,14,14,18,88,18,88,18,
            88,17,18,88,18,88,95,18,25,93,
            18,18,18,18,21,18,18,18,18,14,
            18,14,18,18,18,18,18,18,18,18,
            18,18,18,18,78,78,111,18,18,18,
            18,18,18,18,18,18,14,14,14,18,
            88,103,14,4,17,97,8,84,17,6,
            17,14,18,18,18,100,108,14,14,16,
            18,18,17,17,1,17,18,36,48,60,
            60,72,72,18,18,18,78,78,66,66,
            66,66,54,42,14,103,18,18,18,88,
            25,18,18,18,18,23,18,14,18,18,
            18,18,18,18,18,18,18,18,18,14,
            18,18,23,18,23,21,18,18,18,18,
            18,18,18,18,18,18,33,14,16,18,
            18,18,18,18,18,18,18,18,14,14,
            17,16,18,8,17,16,14,14,23,18,
            18,27,105,14,14,18,14,14,18,17,
            14,18,18,12,18,18,18,18,86,18,
            14,18,18,18,18,14,23,18,14,14,
            18,18,18,18,18,21,88,17,88,19,
            18,16,14,18,18,23,18,18,14,33,
            14,17,14,14,16,16,14,18,18,18,
            18,18,18,18,18,21,18,14,14,14,
            18,18,18
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,108,0,90,0,83,0,80,0,93,
            0,66,71,7,17,4,2,0,91,0,
            73,0,74,0,101,0,2,94,0,2,
            122,0,2,71,0,7,17,4,2,60,
            0,4,7,17,2,57,0,7,17,4,
            2,54,0,4,7,17,2,51,0,7,
            17,4,2,48,0,4,7,17,2,45,
            0,7,17,4,2,42,0,2,7,17,
            4,35,0,124,0,121,0,67,0,118,
            120,2,100,0,123,0,2,3,0,2,
            111,0,103,102,2,66,0,110,2,0,
            2,112,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            81,20,30,11,12,75,78,2,3,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,76,33,7,19,42,31,32,
            34,35,44,46,47,48,49,1,21,4,
            17,23,26,27,5,6,8,9,10,25,
            18,39,14,40,65,70,41,64,66,71,
            74,15,43,67,13,28,68,69,72,73,
            77,16,22,38,24,36,37,45,79,80
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            84,85,155,83,0,87,89,0,0,0,
            0,0,0,0,0,0,99,0,0,0,
            0,0,0,0,0,0,101,0,0,0,
            0,104,0,0,129,130,0,0,0,125,
            126,127,122,123,124,119,120,121,116,117,
            118,113,114,115,110,111,112,107,108,109,
            92,102,105,0,106,91,153,0,0,86,
            93,103,136,0,88,0,0,0,0,133,
            96,128,145,0,0,0,95,98,0,134,
            135,138,139,94,0,97,0,0,137,141,
            147,148,149,0,152,0,0,82,0,90,
            100,131,132,0,140,0,0,142,143,144,
            146,150,151,154,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            215,251,261,149,183,191,237,271,225,18,
            57,18,169,176,43,51,158,209,143,199,
            245,9,164,9,9,35,39,279,285,289,
            293,39,35,1,6,1,64,6,6,6,
            82,82,90,90,98,98,98,98,112,112,
            120,125,130,135
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            49,49,49,49,49,49,49,49,233,4,
            49,70,49,49,49,49,49,49,140,205,
            233,4,49,25,72,4,4,283,283,283,
            49,49,140,4,4,49,67,14,29,76,
            84,87,92,95,100,103,106,109,114,117,
            122,127,132,137
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            26,25,25,28,28,28,26,25,26,38,
            28,38,28,28,39,39,28,28,31,28,
            26,38,28,38,38,31,7,12,11,11,
            8,7,31,27,38,36,37,38,38,38,
            42,42,45,45,48,48,48,48,51,51,
            54,57,60,64
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            5,5,5,5,5,5,5,5,51,1,
            5,74,5,5,5,5,5,5,72,27,
            51,1,5,77,77,1,1,53,53,53,
            5,5,72,1,1,5,78,76,76,76,
            40,9,8,38,48,47,46,45,49,26,
            52,54,57,63
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,1,9,9,9,
            1,1,9,9,9,9,9,9,9,9,
            13,13,15,15,19,19,19,19,21,21,
            22,23,24,25
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            141,4,0,1,0,141,32,0,141,76,
            141,32,0,76,141,1,0,141,77,141,
            76,141,32,0,77,141,1,0,76,141,
            77,141,1,0,152,62,81,0,155,4,
            84,0,178,4,81,43,107,0,5,0,
            178,4,81,44,107,0,158,4,153,81,
            41,107,0,192,33,0,78,141,0,74,
            0,77,141,74,0,76,141,77,141,74,
            0,121,0,40,115,0,9,115,0,124,
            0,8,122,0,38,122,0,127,0,48,
            125,0,47,125,0,46,125,0,45,125,
            0,130,0,49,128,0,26,128,0,133,
            0,52,131,0,136,0,54,134,0,139,
            0,57,137,0,145,0,63,140,0,72,
            154,0,152,62,81,42,107,0,158,4,
            154,150,39,86,42,107,0,158,4,150,
            39,86,0,158,4,154,81,0,158,4,
            154,81,42,107,0,158,4,154,188,42,
            107,0,152,27,81,4,81,41,107,0,
            152,27,142,4,81,41,107,0,142,4,
            81,41,107,0,27,152,5,0,141,4,
            81,41,107,0,141,51,151,73,167,4,
            81,41,107,0,151,73,167,4,81,41,
            107,0,51,141,5,0,141,51,151,4,
            81,41,107,0,151,4,81,41,107,0,
            141,51,167,27,146,4,81,41,107,0,
            141,51,167,27,81,4,81,41,107,0,
            141,51,167,4,81,41,107,0,191,65,
            20,0,53,0,175,65,87,0,175,65,
            84,0,189,4,20,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            4086,4048,4326,4317,4241,4232,4223,4208,4001,3961,
            3878,3838,3795,3752,3706,3660,3614,3568,3519,3470,
            3418,3363,3305,3244,3178,3112,3046,1401,628,1719,
            2980,2914,1626,1322,1243,1164,2848,540,1553,816,
            716,1074,2782,2716,995,2650,2584,2518,2452,916,
            2386,443,346,1480,2320,2254,2188,2122,2056,1990,
            1924,1858,1792,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,186,82,81,69,70,60,59,55,61,
            56,58,64,180,67,200,198,6,199,195,
            193,26,2,2,2,159,150,159,150,159,
            150,56,159,150,159,150,202,81,86,86,
            39,81,116,86,81,97,20,87,84,32,
            107,4,120,126,123,132,129,112,138,135,
            145,136,130,124,28,8,33,121,127,133,
            139,143,155,20,84,86,2,2,2,159,
            150,2,2,203,2,39,181,197,39,180,
            39,62,154,153,50,65,4,65,65,4,
            141,1,43,44,42,41,141,63,54,49,
            26,8,38,112,192,81,40,9,48,47,
            46,45,52,57,26,2,183,146,1,81,
            86,150,83,204,1,150,152,4,191,1,
            81,189,81,190,175,141,176,175,155,76,
            81,81,188,86,81,81,112,139,112,133,
            112,127,127,112,121,121,27,78,2,112,
            124,124,124,124,112,130,112,136,26,26,
            4,2,1,181,4,2,4,27,72,158,
            152,27,27,75,27,141,4,4,154,39,
            62,154,153,4,155,184,185,184,155,158,
            77,178,66,179,178,4,150,152,4,4,
            141,151,167,146,142,81,5,27,5,201,
            141,2,27,158,154,72,158,158,51,73,
            51,27,27,27,2,2,4,141,151,141,
            167,81,152,167,152,81,158,51,51,51,
            141,141,141
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@",
            "^",
            "^^",
            "?",
            "$empty",
            "QUOTED_IDENTIFIER",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "STRING_LITERAL",
            "self",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "null",
            "invalid",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "OclInvalid",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "body",
            "derive",
            "init",
            "static",
            "import",
            "OclMessage",
            "EOF_TOKEN",
            "IDENTIFIER",
            "SINGLE_LINE_COMMENT",
            "MULTI_LINE_COMMENT",
            "ERROR_TOKEN",
            "conceptualOperationNameCS",
            "CollectionTypeIdentifierCS",
            "simpleNameCS",
            "QuotedSimpleNameCS",
            "unreservedSimpleNameCS",
            "pathNameCS",
            "typeCS",
            "collectionTypeCS",
            "tupleTypePartsCS",
            "typedUninitializedVariableCS",
            "OclExpressionCS",
            "typedInitializedVariableCS",
            "initializedVariableCS",
            "uninitializedVariableCS",
            "VariableDeclarationCS",
            "CollectionLiteralPartsCS",
            "CollectionLiteralPartCS",
            "StringLiteralExpCS",
            "TupleLiteralPartsCS",
            "primaryExpCS",
            "notNameExpressionCS",
            "argumentsCS",
            "SimpleNameExpCS",
            "impliesNotNameNotLetCS",
            "impliesNotLetCS",
            "xorNotNameNotLetCS",
            "xorNotLetCS",
            "xorWithLetCS",
            "orNotNameNotLetCS",
            "orNotLetCS",
            "orWithLetCS",
            "andNotNameNotLetCS",
            "andNotLetCS",
            "andWithLetCS",
            "equalityNotNameNotLetCS",
            "equalityNotLetCS",
            "equalityWithLetCS",
            "relationalNotNameNotLetCS",
            "relationalNotLetCS",
            "relationalWithLetCS",
            "additiveNotNameNotLetCS",
            "additiveNotLetCS",
            "additiveWithLetCS",
            "multiplicativeNotNameNotLetCS",
            "multiplicativeNotLetCS",
            "multiplicativeWithLetCS",
            "unaryNotLetCS",
            "unaryWithLetCS",
            "primaryNotNameCS",
            "letVariablesCS",
            "packageDeclarationsCS",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "isMarkedPreCS",
            "OclMessageArgumentsCS",
            "OclMessageArgCS",
            "packageDeclarationCS_A",
            "importCS",
            "contextDeclsCS",
            "importCS_0",
            "importCS_1",
            "importCS_2",
            "contextDeclCS",
            "initOrDerValuesCS",
            "invOrDefsCS",
            "defExpressionCS",
            "operationCS1",
            "operationCS2",
            "prePostOrBodyDeclsCS",
            "parametersCS",
            "ERROR_Colon",
            "ERROR_Empty",
            "ERROR_SimpleNameCS"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
