/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.equinox.p2.metadata.Version;

public final class VersionGenerator {
    private static final String QUALIFIER = "qualifier";
    private static final String QUALIFIER_SUFFIX = ".qualifier";
    private static final int QUALIFIER_LENGTH = "qualifier".length();

    public static String generateQualifierReplacement() {
        return new SimpleDateFormat("'v'yyyyMMdd-HHmmss").format(new Date());
    }

    public static String replaceQualifier(String version, String qualifierReplacement) {
        if (version != null && qualifierReplacement != null && version.endsWith(QUALIFIER_SUFFIX)) {
            int length = version.length();
            StringBuilder result = new StringBuilder(length - QUALIFIER_LENGTH + qualifierReplacement.length());
            result.append(version, 0, length - QUALIFIER_LENGTH);
            result.append(qualifierReplacement);
            version = result.toString();
        }
        return version;
    }

    public static Version replaceQualifier(Version version, String qualifierReplacement) {
        if (version != null && version.isOSGiCompatible()) {
            version = Version.create((String)VersionGenerator.replaceQualifier(version.toString(), qualifierReplacement));
        }
        return version;
    }
}

