/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.operations;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrus.infra.editor.welcome.SashColumn;
import org.eclipse.papyrus.infra.editor.welcome.SashRow;
import org.eclipse.papyrus.infra.editor.welcome.WelcomePage;
import org.eclipse.papyrus.infra.editor.welcome.WelcomeSection;
import org.eclipse.uml2.common.util.DerivedSubsetEObjectEList;

public class WelcomePageOperations {
    protected static final int[] VISIBLE_SECTION_ESUPERSETS = new int[1];

    protected WelcomePageOperations() {
    }

    public static EList<WelcomeSection> getVisibleSections(WelcomePage welcomePage) {
        return new VisibleSectionsList((InternalEObject)welcomePage, 1, VISIBLE_SECTION_ESUPERSETS);
    }

    public static WelcomeSection getSection(WelcomePage welcomePage, String identifier) {
        return welcomePage.getSections().stream().filter(s -> s.isIdentifiedBy(identifier)).findFirst().orElse(null);
    }

    public static SashColumn getSashColumn(WelcomePage welcomePage, int index) {
        SashColumn result = null;
        EList<SashColumn> columns = welcomePage.getSashColumns();
        if (index >= 0 && index < columns.size()) {
            result = (SashColumn)columns.get(index);
        }
        return result;
    }

    public static SashRow getSashRow(WelcomePage welcomePage, int column, int row) {
        SashColumn sashColumn = welcomePage.getSashColumn(column);
        return sashColumn == null ? null : sashColumn.getSashRow(row);
    }

    private static class VisibleSectionsList
    extends DerivedSubsetEObjectEList<WelcomeSection> {
        protected VisibleSectionsList(InternalEObject owner, int featureID, int[] sourceFeatureIDs) {
            super(WelcomeSection.class, owner, featureID, sourceFeatureIDs);
        }

        public List<WelcomeSection> basicList() {
            return new VisibleSectionsList(this.owner, this.featureID, this.sourceFeatureIDs){

                public ListIterator<WelcomeSection> listIterator(int index) {
                    return this.basicListIterator(index);
                }
            };
        }

        protected boolean isIncluded(EStructuralFeature feature) {
            return false;
        }

        protected boolean isIncluded(Object object) {
            return super.isIncluded(object) && !((WelcomeSection)object).isHidden();
        }

        protected WelcomeSection validate(int index, WelcomeSection object) {
            WelcomeSection result = (WelcomeSection)super.validate(index, (Object)object);
            if (object.isHidden()) {
                throw new IllegalArgumentException(String.valueOf(object));
            }
            return result;
        }
    }
}

