/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.environment.Namespace;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;

public class PropertiesUtil {
    public static String firstToUpper(String source) {
        if (source.length() == 0) {
            return source;
        }
        return String.valueOf(source.substring(0, 1).toUpperCase()) + source.substring(1);
    }

    public static String firstToLower(String source) {
        if (source.length() == 0) {
            return source;
        }
        return String.valueOf(source.substring(0, 1).toLowerCase()) + source.substring(1);
    }

    public static String getLabel(Property property) {
        if (property.getLabel() == null || property.getLabel().trim().equals("")) {
            return PropertiesUtil.getLabel(property.getName());
        }
        return property.getLabel();
    }

    public static String getLabel(String variableName) {
        String formattedValue = variableName;
        formattedValue = formattedValue.replaceAll("([a-z])([A-Z])", "$1 $2");
        formattedValue = formattedValue.replaceAll("([A-Z]+)([A-Z])([a-z])", "$1 $2$3");
        String[] words = formattedValue.split("\\s+");
        formattedValue = PropertiesUtil.firstToUpper(words[0]);
        int i = 1;
        while (i < words.length) {
            formattedValue = String.valueOf(formattedValue) + " ";
            formattedValue = words[i].matches("^[A-Z]{2,}") ? String.valueOf(formattedValue) + words[i] : String.valueOf(formattedValue) + PropertiesUtil.firstToLower(words[i]);
            ++i;
        }
        Activator.log.debug("\"" + formattedValue + "\"");
        return formattedValue;
    }

    public static boolean namespaceEquals(Namespace namespace, String value) {
        if (namespace == null) {
            return value == null || value.trim().equals("");
        }
        return namespace.getValue().equals(value);
    }

    public static boolean namespaceEqualsByName(Namespace namespace, String name) {
        if (namespace == null) {
            return name == null || name.trim().equals("");
        }
        return namespace.getName().equals(name);
    }

    public static String getPrefixedValue(Namespace namespace) {
        String prefixedValue = "";
        if (namespace.getPrefix() != null && !namespace.getPrefix().trim().equals("")) {
            prefixedValue = String.valueOf(namespace.getPrefix()) + ":";
        }
        prefixedValue = String.valueOf(prefixedValue) + namespace.getValue();
        return prefixedValue;
    }

    public static String getQualifiedName(Namespace namespace) {
        if (namespace.getName() == null || namespace.getName().trim().equals("")) {
            return "xmlns";
        }
        return "xmlns:" + namespace.getName();
    }

    public static DataContextElement getContextElementByQualifiedName(String qualifiedName, Collection<? extends DataContextElement> fromContextElements) {
        int index = qualifiedName.indexOf(":");
        if (index >= 0) {
            String string = qualifiedName.substring(0, index);
            qualifiedName = qualifiedName.substring(qualifiedName.indexOf(":") + 1, qualifiedName.length());
            for (DataContextElement dataContextElement : fromContextElements) {
                DataContextElement result;
                if (!(dataContextElement instanceof DataContextPackage) || !dataContextElement.getName().equals(string) || (result = PropertiesUtil.getContextElementByQualifiedName(qualifiedName, (Collection<? extends DataContextElement>)((DataContextPackage)dataContextElement).getElements())) == null) continue;
                return result;
            }
        } else {
            for (DataContextElement dataContextElement : fromContextElements) {
                if (!dataContextElement.getName().equals(qualifiedName)) continue;
                return dataContextElement;
            }
        }
        return null;
    }

    public static List<Context> getDependencies(Context context) {
        LinkedList<Context> result = new LinkedList<Context>();
        if (context == null) {
            return result;
        }
        result.add(context);
        PropertiesUtil.findDependencies(context, result);
        return result;
    }

    private static void findDependencies(Context context, List<Context> result) {
        for (Context dependency : context.getDependencies()) {
            if (result.contains(dependency)) continue;
            result.add(dependency);
            PropertiesUtil.findDependencies(dependency, result);
        }
    }

    public static Set<DataContextElement> getAllContextElements(Collection<DataContextElement> source) {
        HashSet<DataContextElement> result = new HashSet<DataContextElement>();
        PropertiesUtil.getAllContextElements(source, result);
        return result;
    }

    private static void getAllContextElements(Collection<DataContextElement> source, Set<DataContextElement> result) {
        for (DataContextElement element : source) {
            if (result.contains(element)) continue;
            result.add(element);
            PropertiesUtil.getAllContextElements((Collection<DataContextElement>)element.getSupertypes(), result);
        }
    }

    public static String resizeString(String string, int maxCharPerLine) {
        if (string.trim().length() <= maxCharPerLine) {
            return string.trim();
        }
        String[] stringChunks = string.split("\n|\r|\r\n|\n\r");
        LinkedList<String> chunks = new LinkedList<String>();
        String[] stringArray = stringChunks;
        int n = stringChunks.length;
        int n2 = 0;
        while (n2 < n) {
            String chunk = stringArray[n2];
            if ((chunk = chunk.trim()).length() > maxCharPerLine) {
                Matcher matcher = Pattern.compile("(.{0," + maxCharPerLine + "}\\b\\p{Punct}?)").matcher(chunk);
                while (matcher.find()) {
                    String group = matcher.group(1);
                    chunks.add(group);
                }
            } else {
                chunks.add(chunk);
            }
            ++n2;
        }
        String result = "";
        for (String chunk : chunks) {
            result = String.valueOf(result) + chunk.trim() + "\n";
        }
        return result.trim();
    }
}

