/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.CustomMessages;
import org.eclipse.papyrus.uml.diagram.sequence.command.DropDestructionOccurenceSpecification;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers.MessageRouter;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CInteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageAsyncEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageSyncEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.MessageCreate;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageDeleteHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class MessageConnectionLineSegEditPolicy
extends ConnectionBendpointEditPolicy {
    private static final String MOVE_LINE_ORIENTATION_DATA = "Move line orientation";
    private static final String MOVED_UP = "Moved Up";
    private static final String MOVED_DOWN = "Moved Down";
    private static final String MOVED_HORIZONTAL = "Moved Horizontal";
    private static final int LIFELINE_MIN_HEIGHT = 100;
    private ConnectionRouter router;

    public MessageConnectionLineSegEditPolicy() {
        super(LineMode.ORTHOGONAL_FREE);
    }

    protected List<?> createManualHandles() {
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
        if (kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.HORIZONTAL || this.getConnection() instanceof MessageCreate) {
            return Collections.emptyList();
        }
        return super.createManualHandles();
    }

    public Command getCommand(Request request) {
        IEditCommandRequest editCommandRequest;
        if (request instanceof EditCommandRequestWrapper && this.getHost() instanceof AbstractMessageEditPart && !(this.getHost() instanceof MessageDeleteEditPart) && !(this.getHost() instanceof MessageCreateEditPart) && (editCommandRequest = ((EditCommandRequestWrapper)request).getEditCommandRequest()) instanceof DestroyElementRequest && ((DestroyElementRequest)editCommandRequest).getElementToDestroy() instanceof Message) {
            return this.getUpdateWeakRefForMessageDelete((EditCommandRequestWrapper)request);
        }
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
        if (kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.HORIZONTAL || kind == MessageRouter.RouterKind.OBLIQUE || this.getConnection() instanceof MessageCreate) {
            return super.getCommand(request);
        }
        if (request instanceof BendpointRequest) {
            return this.getMoveMessageCommand((BendpointRequest)request);
        }
        return null;
    }

    private Command getUpdateWeakRefForMessageDelete(EditCommandRequestWrapper request) {
        CompoundCommand command = null;
        ConnectionEditPart hostConnectionEditPart = (ConnectionEditPart)this.getHost();
        Point moveDelta = new Point(0, -UpdateWeakReferenceEditPolicy.deltaMoveAtCreationAndDeletion);
        if (moveDelta.y < 0 && hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
            SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
            if (!SenderRequestUtils.isASender((Request)request, this.getHost())) {
                CompoundCommand compoundCommand = new CompoundCommand();
                ArrayList weakReferences = new ArrayList();
                HashMap<EditPart, String> allWeakReferences = references.getWeakReferences();
                allWeakReferences.forEach((editPart, value) -> {
                    if ("FINISH" != value) {
                        weakReferences.add(editPart);
                    }
                });
                for (EditPart editPart2 : weakReferences) {
                    if (!SenderRequestUtils.isASender((Request)request, editPart2)) {
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move " + editPart2);
                        ArrayList<EditPart> senderList = SenderRequestUtils.getSenders((Request)request);
                        if (editPart2 instanceof ConnectionEditPart) {
                            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart2;
                            UpdateWeakReferenceEditPolicy.moveSourceConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, (org.eclipse.gef.ConnectionEditPart)connectionEditPart, senderList);
                            UpdateWeakReferenceEditPolicy.moveTargetConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, (org.eclipse.gef.ConnectionEditPart)connectionEditPart, senderList);
                        }
                        if (editPart2 instanceof RoundedCompartmentEditPart) {
                            UpdateWeakReferenceEditPolicy.moveRoundedEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, editPart2, senderList);
                        }
                    }
                    if (compoundCommand.isEmpty()) continue;
                    command = compoundCommand;
                }
            }
        }
        return command != null && command.canExecute() ? command : null;
    }

    protected Command getMoveMessageCommand(BendpointRequest request) {
        if (this.getHost() instanceof MessageLostEditPart || this.getHost() instanceof MessageFoundEditPart) {
            PointList points = this.getConnection().getPoints().getCopy();
            CompoundCommand command = new CompoundCommand("Move");
            AbstractMessageEditPart messageEditPart = (AbstractMessageEditPart)this.getHost();
            Point sourceLocation = points.getFirstPoint().getCopy();
            this.getConnection().translateToAbsolute((Translatable)sourceLocation);
            sourceLocation = SequenceUtil.getSnappedLocation(this.getHost(), sourceLocation);
            Point targetLocation = points.getLastPoint().getCopy();
            this.getConnection().translateToAbsolute((Translatable)targetLocation);
            targetLocation = SequenceUtil.getSnappedLocation(this.getHost(), targetLocation);
            EditPart source = messageEditPart.getSource();
            EditPart target = messageEditPart.getTarget();
            HashSet<EditPart> editParts = new HashSet<EditPart>(2);
            editParts.add(source);
            editParts.add(target);
            int maxY = -1;
            for (EditPart editPart : editParts) {
                LifelineEditPart lifeLineEditPart = SequenceUtil.getParentLifelinePart(editPart);
                if (lifeLineEditPart == null || !(lifeLineEditPart.getModel() instanceof Shape)) continue;
                ShapeImpl view = (ShapeImpl)lifeLineEditPart.getModel();
                Bounds bounds = BoundForEditPart.getBounds((Node)view);
                if (sourceLocation.y > bounds.getY() + bounds.getHeight()) {
                    maxY = sourceLocation.y;
                }
                if (targetLocation.y <= bounds.getY() + bounds.getHeight()) continue;
                maxY = targetLocation.y;
            }
            if (maxY > -1) {
                LifelineEditPartUtil.resizeAllLifeLines(command, (EditPart)messageEditPart, maxY, null);
            }
            ReconnectRequest sourceReq = new ReconnectRequest((Object)"Reconnection source");
            sourceReq.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)messageEditPart);
            sourceReq.setLocation(sourceLocation);
            sourceReq.setTargetEditPart(source);
            Command moveSourceCommand = source.getCommand((Request)sourceReq);
            command.add(moveSourceCommand);
            ReconnectRequest targetReq = new ReconnectRequest((Object)"Reconnection target");
            targetReq.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)messageEditPart);
            targetReq.setLocation(targetLocation);
            targetReq.setTargetEditPart(target);
            Command moveTargetCommand = target.getCommand((Request)targetReq);
            command.add(moveTargetCommand);
            return command.unwrap();
        }
        return null;
    }

    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        ConnectionNodeEditPart connectionPart;
        EObject message;
        request.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation()));
        if (this.getHost().getViewer() instanceof ScrollingGraphicalViewer && this.getHost().getViewer().getControl() instanceof FigureCanvas) {
            SelectInDiagramHelper.exposeLocation((FigureCanvas)((FigureCanvas)this.getHost().getViewer().getControl()), (Point)request.getLocation().getCopy());
        }
        if (this.getHost() instanceof ConnectionNodeEditPart && (message = (connectionPart = (ConnectionNodeEditPart)this.getHost()).resolveSemanticElement()) instanceof Message) {
            MessageEnd send = ((Message)message).getSendEvent();
            MessageEnd rcv = ((Message)message).getReceiveEvent();
            EditPart srcPart = connectionPart.getSource();
            CLifeLineEditPart srcLifelinePart = (CLifeLineEditPart)SequenceUtil.getParentLifelinePart(srcPart);
            EditPart tgtPart = connectionPart.getTarget();
            CLifeLineEditPart targetLifelinePart = (CLifeLineEditPart)SequenceUtil.getParentLifelinePart(tgtPart);
            if (srcLifelinePart != null && targetLifelinePart != null) {
                MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
                if ((this.getHost() instanceof MessageSyncEditPart || this.getHost() instanceof MessageAsyncEditPart) && kind == MessageRouter.RouterKind.SELF) {
                    return this.getSelfLinkMoveCommand(request, connectionPart, send, rcv, srcLifelinePart);
                }
                if (this.getHost() instanceof MessageCreateEditPart) {
                    int y = request.getLocation().y;
                    Command srcCmd = this.createMoveMessageEndCommand((Message)message, srcPart, send, y, srcLifelinePart, (Request)request);
                    Command tgtCmd = this.createMoveMessageEndCommand((Message)message, tgtPart, rcv, y, targetLifelinePart, (Request)request);
                    CompoundCommand compoudCmd = new CompoundCommand(CustomMessages.MoveMessageCommand_Label);
                    Point oldLocation = SequenceUtil.getAbsoluteEdgeExtremity(connectionPart, true);
                    if (oldLocation != null) {
                        int oldY = oldLocation.y;
                        int yMoveDelta = y - oldY;
                        Command updateLifeLinesBounds = this.getUpdateLifeLinesBounds(request, (ConnectionEditPart)connectionPart, yMoveDelta);
                        if (updateLifeLinesBounds != null) {
                            compoudCmd.add(updateLifeLinesBounds);
                        }
                        if (oldY < y) {
                            compoudCmd.add(tgtCmd);
                            compoudCmd.add(srcCmd);
                        } else {
                            compoudCmd.add(srcCmd);
                            compoudCmd.add(tgtCmd);
                        }
                        return compoudCmd;
                    }
                } else {
                    if (this.getHost() instanceof MessageDeleteEditPart) {
                        LifelineFigure targetFigure = targetLifelinePart.getPrimaryShape();
                        PrecisionPoint refPoint = SequenceUtil.getSnappedLocation((EditPart)targetLifelinePart, request.getLocation().getCopy());
                        targetFigure.getParent().translateToRelative((Translatable)refPoint);
                        Bounds bounds = (Bounds)((Node)targetLifelinePart.getModel()).getLayoutConstraint();
                        SetResizeCommand setSizeCommand = new SetResizeCommand(targetLifelinePart.getEditingDomain(), "Size LifeLine", (IAdaptable)new EObjectAdapter((EObject)targetLifelinePart.getNotationView()), new Dimension(bounds.getWidth(), refPoint.y - bounds.getY()));
                        CompoundCommand compoudCmd = new CompoundCommand(CustomMessages.MoveMessageCommand_Label);
                        if (kind == MessageRouter.RouterKind.SELF) {
                            if (MOVED_DOWN.equals(request.getExtendedData().get(MOVE_LINE_ORIENTATION_DATA))) {
                                compoudCmd.add((Command)new ICommandProxy((ICommand)setSizeCommand));
                            }
                        } else {
                            int y = request.getLocation().y;
                            Command srcCmd = this.createMoveMessageEndCommand((Message)message, srcPart, send, y, srcLifelinePart, (Request)request);
                            Command tgtCmd = this.createMoveMessageEndCommand((Message)message, tgtPart, rcv, y, targetLifelinePart, (Request)request);
                            DropDestructionOccurenceSpecification dropDestructionOccurenceSpecification = new DropDestructionOccurenceSpecification(((ConnectionEditPart)this.getHost()).getEditingDomain(), (Request)request, (EditPart)targetLifelinePart, request.getLocation().getCopy());
                            Point oldLocation = SequenceUtil.getAbsoluteEdgeExtremity(connectionPart, true);
                            if (oldLocation != null) {
                                int oldY = oldLocation.y;
                                int yMoveDelta = y - oldY;
                                Command updateLifeLinesBounds = this.getUpdateLifeLinesBounds(request, (ConnectionEditPart)connectionPart, yMoveDelta);
                                if (updateLifeLinesBounds != null) {
                                    compoudCmd.add(updateLifeLinesBounds);
                                }
                                if (oldY < y) {
                                    compoudCmd.add(tgtCmd);
                                    compoudCmd.add(srcCmd);
                                    compoudCmd.add((Command)new ICommandProxy((ICommand)dropDestructionOccurenceSpecification));
                                } else {
                                    compoudCmd.add(srcCmd);
                                    compoudCmd.add(tgtCmd);
                                    compoudCmd.add((Command)new ICommandProxy((ICommand)dropDestructionOccurenceSpecification));
                                }
                            }
                        }
                        return compoudCmd;
                    }
                    int y = request.getLocation().y;
                    int yDelta = 0;
                    PolylineConnectionEx polyline = (PolylineConnectionEx)connectionPart.getFigure();
                    Point sourceAnchorPosition = polyline.getSourceAnchor().getReferencePoint();
                    Point targetAnchorPosition = polyline.getTargetAnchor().getReferencePoint();
                    if (kind == MessageRouter.RouterKind.OBLIQUE) {
                        yDelta = targetAnchorPosition.y - sourceAnchorPosition.y;
                    }
                    Command srcCmd = this.createMoveMessageEndCommand((Message)message, srcPart, send, y, srcLifelinePart, (Request)request);
                    Command tgtCmd = this.createMoveMessageEndCommand((Message)message, tgtPart, rcv, y + yDelta, targetLifelinePart, (Request)request);
                    CompoundCommand compoudCmd = new CompoundCommand(CustomMessages.MoveMessageCommand_Label);
                    Point oldLocation = SequenceUtil.getAbsoluteEdgeExtremity(connectionPart, true);
                    if (oldLocation != null) {
                        int oldY = oldLocation.y;
                        int yMoveDelta = y - oldY;
                        Command updateLifeLinesBounds = this.getUpdateLifeLinesBounds(request, (ConnectionEditPart)connectionPart, yMoveDelta);
                        if (updateLifeLinesBounds != null) {
                            compoudCmd.add(updateLifeLinesBounds);
                        }
                        if (oldY < y) {
                            compoudCmd.add(tgtCmd);
                            compoudCmd.add(srcCmd);
                        } else {
                            compoudCmd.add(srcCmd);
                            compoudCmd.add(tgtCmd);
                        }
                        return compoudCmd;
                    }
                }
            } else if (srcLifelinePart == null && targetLifelinePart != null || srcLifelinePart != null && targetLifelinePart == null) {
                return this.getMoveMessageCommand(request);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getUpdateLifeLinesBounds(BendpointRequest request, ConnectionEditPart hostConnectionEditPart, int yMoveDelta) {
        CompoundCommand command = null;
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ Calculate lifelines height modification for " + hostConnectionEditPart.getClass().getName());
        boolean mustMoveBelowAtMovingDown = UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("PREF_MOVE_BELOW_ELEMENTS_AT_MESSAGE_DOWN");
        if (yMoveDelta != 0) {
            if (yMoveDelta > 0 && mustMoveBelowAtMovingDown && hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
                if (!SenderRequestUtils.isASender((Request)request, this.getHost())) {
                    ArrayList<EditPart> weakAndStrongReferences = new ArrayList<EditPart>();
                    weakAndStrongReferences.addAll(references.getWeakReferences().keySet());
                    weakAndStrongReferences.addAll(references.getStrongReferences().keySet());
                    PolylineConnectionEx polyline = (PolylineConnectionEx)hostConnectionEditPart.getFigure();
                    Point initialSourcePosition = polyline.getSourceAnchor().getReferencePoint();
                    Point initialTargetPosition = polyline.getTargetAnchor().getReferencePoint();
                    HashSet<LifelineEditPart> lifelineEditParts = new HashSet<LifelineEditPart>();
                    if (hostConnectionEditPart.getSource() instanceof LifelineEditPart) {
                        lifelineEditParts.add((LifelineEditPart)hostConnectionEditPart.getSource());
                    }
                    if (hostConnectionEditPart.getTarget() instanceof LifelineEditPart) {
                        lifelineEditParts.add((LifelineEditPart)hostConnectionEditPart.getTarget());
                    }
                    int maxY = initialTargetPosition.y > initialSourcePosition.y ? initialTargetPosition.y + yMoveDelta : initialTargetPosition.y + yMoveDelta;
                    int index = 0;
                    while (index < weakAndStrongReferences.size()) {
                        EditPart editPart = (EditPart)weakAndStrongReferences.get(index);
                        if (!SenderRequestUtils.isASender((Request)request, editPart)) {
                            if (editPart instanceof ConnectionEditPart) {
                                ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                                if (yMoveDelta > 0) {
                                    PolylineConnectionEx subPolyline = (PolylineConnectionEx)connectionEditPart.getFigure();
                                    Point targetPositionOnScreen = subPolyline.getTargetAnchor().getReferencePoint();
                                    int newYTargetPoint = targetPositionOnScreen.y + yMoveDelta;
                                    Point sourcePositionOnScreen = subPolyline.getSourceAnchor().getReferencePoint();
                                    int newYSourcePoint = sourcePositionOnScreen.y + yMoveDelta;
                                    if (maxY < newYTargetPoint) {
                                        maxY = newYTargetPoint;
                                    }
                                    if (maxY < newYSourcePoint) {
                                        maxY = newYSourcePoint;
                                    }
                                    if (connectionEditPart.getSource() instanceof LifelineEditPart) {
                                        lifelineEditParts.add((LifelineEditPart)connectionEditPart.getSource());
                                    }
                                    if (connectionEditPart.getTarget() instanceof LifelineEditPart) {
                                        lifelineEditParts.add((LifelineEditPart)connectionEditPart.getTarget());
                                    }
                                }
                            } else if (editPart instanceof IGraphicalEditPart && editPart.getModel() instanceof Node) {
                                LifelineEditPart parentLifeline;
                                Rectangle absoluteBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)editPart);
                                if (absoluteBounds.height == -1) {
                                    absoluteBounds.setHeight(BoundForEditPart.getDefaultHeightFromView((Node)editPart.getModel()));
                                }
                                if ((parentLifeline = SequenceUtil.getParentLifelinePart(editPart)) != null) {
                                    lifelineEditParts.add(parentLifeline);
                                }
                                if (maxY < absoluteBounds.y + absoluteBounds.height + yMoveDelta) {
                                    maxY = absoluteBounds.y + absoluteBounds.height + yMoveDelta;
                                }
                            }
                            if (editPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                                SequenceReferenceEditPolicy subReferences = (SequenceReferenceEditPolicy)editPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
                                for (EditPart refEditPart : subReferences.getWeakReferences().keySet()) {
                                    if (weakAndStrongReferences.contains(refEditPart)) continue;
                                    weakAndStrongReferences.add(refEditPart);
                                }
                                for (EditPart refEditPart : subReferences.getStrongReferences().keySet()) {
                                    if (weakAndStrongReferences.contains(refEditPart)) continue;
                                    weakAndStrongReferences.add(refEditPart);
                                }
                            }
                        }
                        ++index;
                    }
                    if (!weakAndStrongReferences.isEmpty() || !(hostConnectionEditPart instanceof MessageCreateEditPart) && !(hostConnectionEditPart instanceof MessageDeleteEditPart)) {
                        Set<LifelineEditPart> lifeLinesToResize = SequenceUtil.getLifeLinesFromEditPart((EditPart)hostConnectionEditPart);
                        CompoundCommand compoundCommand = new CompoundCommand();
                        for (LifelineEditPart lifeLineEP : lifeLinesToResize) {
                            Bounds bounds;
                            boolean hasIncomingMessageCreate;
                            if (!(lifeLineEP.getModel() instanceof Shape)) continue;
                            ShapeImpl view = (ShapeImpl)lifeLineEP.getModel();
                            boolean hasIncomingMessageDelete = LifelineMessageDeleteHelper.hasIncomingMessageDelete((EditPart)lifeLineEP);
                            List<?> incomingMessagesCreate = LifelineMessageCreateHelper.getIncomingMessageCreate((EditPart)lifeLineEP);
                            boolean bl = hasIncomingMessageCreate = incomingMessagesCreate.size() > 0;
                            if (hasIncomingMessageCreate) {
                                hasIncomingMessageCreate = false;
                                Iterator<?> incomingMessagesCreateIt = incomingMessagesCreate.iterator();
                                while (incomingMessagesCreateIt.hasNext() && !hasIncomingMessageCreate) {
                                    Object incomingMessageCreate = incomingMessagesCreateIt.next();
                                    if (!(incomingMessageCreate instanceof ConnectionEditPart)) continue;
                                    PolylineConnectionEx subPolyline = (PolylineConnectionEx)((ConnectionEditPart)incomingMessageCreate).getFigure();
                                    Point targetPositionOnScreen = subPolyline.getTargetAnchor().getReferencePoint();
                                    Point sourcePositionOnScreen = subPolyline.getSourceAnchor().getReferencePoint();
                                    if (sourcePositionOnScreen.y < initialSourcePosition.y && targetPositionOnScreen.y < initialTargetPosition.y) continue;
                                    hasIncomingMessageCreate = true;
                                }
                            }
                            Rectangle absoluteBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)lifeLineEP);
                            if (absoluteBounds.height == -1) {
                                absoluteBounds.setHeight(CLifeLineEditPart.DEFAUT_HEIGHT);
                            }
                            if (!hasIncomingMessageDelete && !hasIncomingMessageCreate) {
                                if (maxY <= absoluteBounds.y + absoluteBounds.height || !(view.getLayoutConstraint() instanceof Bounds)) continue;
                                bounds = (Bounds)view.getLayoutConstraint();
                                Point newLocation = new Point(bounds.getX(), bounds.getY());
                                Dimension newDimension = new Dimension(bounds.getWidth(), maxY - absoluteBounds.y);
                                SetResizeCommand heightCommand = new SetResizeCommand(lifeLineEP.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newDimension);
                                compoundCommand.add((Command)new ICommandProxy((ICommand)heightCommand));
                                SetLocationCommand locationCommand = new SetLocationCommand(lifeLineEP.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newLocation);
                                compoundCommand.add((Command)new ICommandProxy((ICommand)locationCommand));
                                continue;
                            }
                            if (!lifelineEditParts.contains((Object)lifeLineEP) || !(view.getLayoutConstraint() instanceof Bounds)) continue;
                            bounds = (Bounds)view.getLayoutConstraint();
                            int newY = bounds.getY();
                            int newHeight = bounds.getHeight();
                            if (hasIncomingMessageCreate) {
                                newY = bounds.getY() + yMoveDelta;
                                if (!hasIncomingMessageDelete && maxY > newY + (newHeight = absoluteBounds.y + absoluteBounds.height - newY)) {
                                    newHeight = maxY - newY;
                                }
                            } else if (hasIncomingMessageDelete) {
                                newHeight = absoluteBounds.height + yMoveDelta;
                            }
                            Point newLocation = new Point(bounds.getX(), newY);
                            Dimension newDimension = new Dimension(bounds.getWidth(), newHeight);
                            SetResizeCommand heightCommand = new SetResizeCommand(lifeLineEP.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newDimension);
                            compoundCommand.add((Command)new ICommandProxy((ICommand)heightCommand));
                            SetLocationCommand locationCommand = new SetLocationCommand(lifeLineEP.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newLocation);
                            compoundCommand.add((Command)new ICommandProxy((ICommand)locationCommand));
                        }
                        if (!compoundCommand.isEmpty()) {
                            command = compoundCommand;
                        }
                    }
                }
            }
            if (command == null) {
                CompoundCommand updateLifeLinesBoundsForOnlyOneMessageDelete;
                if (hostConnectionEditPart instanceof MessageCreateEditPart) {
                    CompoundCommand updateLifeLinesBoundsForOnlyOneMessageCreate = this.getUpdateLifeLinesBoundsForOnlyOneMessageCreate(request, hostConnectionEditPart, yMoveDelta);
                    if (!updateLifeLinesBoundsForOnlyOneMessageCreate.isEmpty()) {
                        command = updateLifeLinesBoundsForOnlyOneMessageCreate;
                    }
                } else if (hostConnectionEditPart instanceof MessageDeleteEditPart && !(updateLifeLinesBoundsForOnlyOneMessageDelete = this.getUpdateLifeLinesBoundsForOnlyOneMessageDelete(request, hostConnectionEditPart, yMoveDelta)).isEmpty()) {
                    command = updateLifeLinesBoundsForOnlyOneMessageDelete;
                }
            }
        }
        return command;
    }

    protected CompoundCommand getUpdateLifeLinesBoundsForOnlyOneMessageCreate(BendpointRequest request, ConnectionEditPart hostConnectionEditPart, int yMoveDelta) {
        LifelineEditPart targetLifeLine;
        CompoundCommand compoundCommand = new CompoundCommand();
        if (hostConnectionEditPart.getTarget() instanceof LifelineEditPart && (targetLifeLine = (LifelineEditPart)hostConnectionEditPart.getTarget()).getModel() instanceof Shape) {
            ShapeImpl view = (ShapeImpl)targetLifeLine.getModel();
            Bounds bounds = (Bounds)view.getLayoutConstraint();
            Point newLocation = new Point(bounds.getX(), bounds.getY() + yMoveDelta);
            int initialHeight = bounds.getHeight() == -1 ? BoundForEditPart.getDefaultHeightFromView((Node)view) : bounds.getHeight();
            Dimension newDimension = new Dimension(bounds.getWidth(), initialHeight - yMoveDelta);
            if (yMoveDelta > 0 && initialHeight < yMoveDelta) {
                newDimension.height = 100;
                int maxY = newLocation.y + newDimension.height;
                HashSet<LifelineEditPart> lifeLineEditPartsToSkip = new HashSet<LifelineEditPart>(1);
                lifeLineEditPartsToSkip.add(targetLifeLine);
                LifelineEditPartUtil.resizeAllLifeLines(compoundCommand, (EditPart)hostConnectionEditPart, maxY, lifeLineEditPartsToSkip);
            }
            SetResizeCommand heightCommand = new SetResizeCommand(targetLifeLine.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newDimension);
            compoundCommand.add((Command)new ICommandProxy((ICommand)heightCommand));
            SetLocationCommand locationCommand = new SetLocationCommand(targetLifeLine.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newLocation);
            compoundCommand.add((Command)new ICommandProxy((ICommand)locationCommand));
        }
        return compoundCommand;
    }

    protected CompoundCommand getUpdateLifeLinesBoundsForOnlyOneMessageDelete(BendpointRequest request, ConnectionEditPart hostConnectionEditPart, int yMoveDelta) {
        LifelineEditPart targetLifeLine;
        CompoundCommand compoundCommand = new CompoundCommand();
        if (hostConnectionEditPart.getTarget() instanceof LifelineEditPart && (targetLifeLine = (LifelineEditPart)hostConnectionEditPart.getTarget()).getModel() instanceof Shape) {
            ShapeImpl view = (ShapeImpl)targetLifeLine.getModel();
            Bounds bounds = (Bounds)view.getLayoutConstraint();
            Dimension newDimension = new Dimension(bounds.getWidth(), bounds.getHeight() + yMoveDelta);
            if (yMoveDelta > 0) {
                int maxY = bounds.getY() + newDimension.height();
                HashSet<LifelineEditPart> lifeLineEditPartsToSkip = new HashSet<LifelineEditPart>(1);
                lifeLineEditPartsToSkip.add(targetLifeLine);
                LifelineEditPartUtil.resizeAllLifeLines(compoundCommand, (EditPart)hostConnectionEditPart, maxY, lifeLineEditPartsToSkip);
            }
            SetResizeCommand boundsCommand = new SetResizeCommand(targetLifeLine.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), newDimension);
            compoundCommand.add((Command)new ICommandProxy((ICommand)boundsCommand));
        }
        return compoundCommand;
    }

    protected Command createMoveMessageEndCommand(Message message, EditPart endEditPart, MessageEnd end, int yLocation, LifelineEditPart lifeline, Request request) {
        if (end instanceof OccurrenceSpecification) {
            List<EditPart> empty = Collections.emptyList();
            return OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand((OccurrenceSpecification)end, null, yLocation, -1, lifeline, empty, request);
        }
        if (end instanceof Gate) {
            boolean isSource = end == message.getSendEvent();
            ConnectionNodeEditPart connection = (ConnectionNodeEditPart)this.getHost();
            if (isSource) {
                ReconnectRequest req = new ReconnectRequest((Object)"Reconnection source");
                req.getExtendedData().put("do not check horizontality", true);
                req.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)connection);
                req.setTargetEditPart(endEditPart);
                Point location = SequenceUtil.getAbsoluteEdgeExtremity(connection, true);
                location.setY(yLocation);
                req.setLocation(location);
                Command command = endEditPart.getCommand((Request)req);
                return command;
            }
            ReconnectRequest req = new ReconnectRequest((Object)"Reconnection target");
            req.getExtendedData().put("do not check horizontality", true);
            req.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)connection);
            req.setTargetEditPart(endEditPart);
            Point location = SequenceUtil.getAbsoluteEdgeExtremity(connection, false);
            location.setY(yLocation);
            req.setLocation(location);
            Command command = endEditPart.getCommand((Request)req);
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getSelfLinkMoveCommand(BendpointRequest request, ConnectionNodeEditPart connectionPart, MessageEnd send, MessageEnd rcv, LifelineEditPart srcLifelinePart) {
        Object moveData = request.getExtendedData().get(MOVE_LINE_ORIENTATION_DATA);
        CompoundCommand compoudCmd = new CompoundCommand(CustomMessages.MoveMessageCommand_Label);
        compoudCmd.add(super.getBendpointsChangedCommand(request));
        PointList points = this.getConnection().getPoints();
        if (MOVED_UP.equals(moveData)) {
            Point sourceRefPoint = points.getFirstPoint();
            this.getConnection().translateToAbsolute((Translatable)sourceRefPoint);
            Command srcCmd = this.getReconnectCommand(connectionPart, connectionPart.getSource(), sourceRefPoint, "Reconnection source");
            compoudCmd.add(srcCmd);
        } else if (MOVED_DOWN.equals(moveData)) {
            Point targetRefPoint = points.getLastPoint();
            this.getConnection().translateToAbsolute((Translatable)targetRefPoint);
            Command tgtCmd = this.getReconnectCommand(connectionPart, connectionPart.getTarget(), targetRefPoint, "Reconnection target");
            compoudCmd.add(tgtCmd);
        }
        return compoudCmd.unwrap();
    }

    protected Command getReconnectCommand(ConnectionNodeEditPart connectionPart, EditPart targetPart, Point location, String requestType) {
        ReconnectRequest reconnReq = new ReconnectRequest();
        reconnReq.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)connectionPart);
        reconnReq.setLocation(location);
        reconnReq.setTargetEditPart(targetPart);
        reconnReq.setType((Object)requestType);
        reconnReq.getExtendedData().put("Do not move these edit parts", true);
        Command cmd = targetPart.getCommand((Request)reconnReq);
        return cmd;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof BendpointRequest) {
            MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
            if (this.getHost() instanceof MessageFoundEditPart || this.getHost() instanceof MessageLostEditPart) {
                this.showMoveLineSegFeedback((BendpointRequest)request);
            } else if (kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.HORIZONTAL || kind == MessageRouter.RouterKind.OBLIQUE || this.getConnection() instanceof MessageCreate) {
                if (this.getLineSegMode() != LineMode.OBLIQUE && "move bendpoint".equals(request.getType())) {
                    List constraint = (List)this.getConnection().getRoutingConstraint();
                    if (constraint.size() > 2) {
                        super.showSourceFeedback(request);
                    }
                } else {
                    super.showSourceFeedback(request);
                }
                if (this.getLineSegMode() != LineMode.OBLIQUE && "move bendpoint".equals(request.getType())) {
                    this.showMoveLineSegFeedback((BendpointRequest)request);
                }
            }
        }
    }

    protected void showMoveLineSegFeedback(BendpointRequest request) {
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
        if ((this.getHost() instanceof MessageSyncEditPart || this.getHost() instanceof MessageAsyncEditPart || this.getHost() instanceof MessageDeleteEditPart) && kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.OBLIQUE) {
            if (this.router == null) {
                this.router = this.getConnection().getConnectionRouter();
                this.getConnection().setConnectionRouter((ConnectionRouter)new DummyRouter());
            }
            PointList linkPoints = this.getConnection().getPoints().getCopy();
            PrecisionPoint ptLoc = SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation());
            this.getConnection().translateToRelative((Translatable)ptLoc);
            int dy = 0;
            int dx = 0;
            int from = 0;
            int to = 0;
            int index = request.getIndex();
            if (index == 0) {
                dy = ptLoc.y - linkPoints.getFirstPoint().y;
                from = 0;
                to = 1;
                request.getExtendedData().put(MOVE_LINE_ORIENTATION_DATA, MOVED_UP);
            } else if (index == 1) {
                dx = ptLoc.x - linkPoints.getMidpoint().x;
                from = 1;
                to = 2;
                request.getExtendedData().put(MOVE_LINE_ORIENTATION_DATA, MOVED_HORIZONTAL);
            } else if (index == 2) {
                dy = ptLoc.y - linkPoints.getLastPoint().y;
                from = 2;
                to = 3;
                request.getExtendedData().put(MOVE_LINE_ORIENTATION_DATA, MOVED_DOWN);
            }
            if (this.getHost() instanceof MessageSyncEditPart && index > 1) {
                dy = 0;
            }
            int size = linkPoints.size();
            if (from >= 0 && from < size && to >= 0 && to < size && from <= to) {
                int i = from;
                while (i <= to) {
                    Point p = linkPoints.getPoint(i);
                    p.translate(dx, dy);
                    linkPoints.setPoint(p, i);
                    ++i;
                }
            }
            this.getConnection().setPoints(linkPoints);
            this.getConnection().getLayoutManager().layout((IFigure)this.getConnection());
            return;
        }
        if (this.getHost() instanceof MessageCreateEditPart || this.getHost() instanceof MessageDeleteEditPart || this.getHost() instanceof MessageLostEditPart || this.getHost() instanceof MessageFoundEditPart) {
            if (this.router == null) {
                this.router = this.getConnection().getConnectionRouter();
                this.getConnection().setConnectionRouter((ConnectionRouter)new DummyRouter());
            }
            PointList linkPoints = this.getConnection().getPoints().getCopy();
            Point ptLoc = new Point(request.getLocation());
            ptLoc = SequenceUtil.getSnappedLocation(this.getHost(), ptLoc);
            this.getConnection().translateToRelative((Translatable)ptLoc);
            int dy = ptLoc.y - linkPoints.getFirstPoint().y;
            int size = linkPoints.size();
            int i = 0;
            while (i < size) {
                Point p = linkPoints.getPoint(i).translate(0, dy);
                linkPoints.setPoint(p, i);
                ++i;
            }
            if (this.checkBounds(linkPoints)) {
                this.getConnection().setPoints(linkPoints);
                this.getConnection().getLayoutManager().layout((IFigure)this.getConnection());
            }
            return;
        }
        super.showMoveLineSegFeedback(request);
    }

    protected boolean checkBounds(PointList linkPoints) {
        if (linkPoints.getFirstPoint().y > linkPoints.getLastPoint().y) {
            return false;
        }
        EditPart sourcePart = ((ConnectionNodeEditPart)this.getHost()).getSource();
        if (sourcePart instanceof CInteractionEditPart && this.getHost() instanceof MessageFoundEditPart) {
            sourcePart = ((ConnectionNodeEditPart)this.getHost()).getTarget();
        }
        if (sourcePart instanceof CLifeLineEditPart) {
            NodeFigure targetFigure;
            int bottom;
            CLifeLineEditPart sourceLifelineEditPart = (CLifeLineEditPart)sourcePart;
            LifelineFigure sourceFigure = sourceLifelineEditPart.getPrimaryShape();
            Rectangle boundsToMatch = sourceFigure.getBounds().getCopy();
            EditPart targetPart = ((ConnectionNodeEditPart)this.getHost()).getTarget();
            if (sourceLifelineEditPart.getStickerHeight() != -1) {
                boundsToMatch.setHeight(boundsToMatch.height - sourceLifelineEditPart.getStickerHeight());
                boundsToMatch.setY(boundsToMatch.y + sourceLifelineEditPart.getStickerHeight());
            }
            if (this.getHost() instanceof MessageCreateEditPart && targetPart instanceof CLifeLineEditPart && (bottom = (targetFigure = (NodeFigure)((NodeEditPart)targetPart).getPrimaryShape()).getBounds().bottom()) < boundsToMatch.bottom()) {
                int delta = boundsToMatch.bottom() - bottom + 100;
                boundsToMatch.setHeight(boundsToMatch.height - delta);
            }
            sourceFigure.translateToAbsolute((Translatable)boundsToMatch);
            Rectangle boundsToCheck = linkPoints.getBounds();
            this.getConnection().translateToAbsolute((Translatable)boundsToCheck);
            if (boundsToCheck.getTop().y <= boundsToMatch.getTop().y) {
                return false;
            }
        } else if (sourcePart instanceof AbstractExecutionSpecificationEditPart) {
            AbstractExecutionSpecificationEditPart esep = (AbstractExecutionSpecificationEditPart)sourcePart;
            IFigure fig = esep.getFigure();
            Rectangle bounds = fig.getBounds().getCopy();
            fig.translateToAbsolute((Translatable)bounds);
            Rectangle conBounds = linkPoints.getBounds().getCopy();
            this.getConnection().translateToAbsolute((Translatable)conBounds);
            if (this.getHost() instanceof MessageSyncEditPart ? conBounds.width < 2 || conBounds.height < 2 || conBounds.y <= bounds.y : bounds.intersects(conBounds.getShrinked(1, 1)) || conBounds.width < 2 || conBounds.height < 2 || conBounds.y <= bounds.y || conBounds.getBottom().y >= bounds.getBottom().y) {
                return false;
            }
        }
        return true;
    }

    protected void eraseConnectionFeedback(BendpointRequest request, boolean removeFeedbackFigure) {
        this.getConnection().setVisible(true);
        super.eraseConnectionFeedback(request, removeFeedbackFigure);
        if (this.router != null) {
            this.getConnection().setConnectionRouter(this.router);
        }
        this.router = null;
    }

    static class DummyRouter
    extends AbstractRouter {
        DummyRouter() {
        }

        public void route(Connection conn) {
        }
    }
}

