/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.internal.ui.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.uml.service.types.Activator;
import org.eclipse.papyrus.uml.service.types.internal.ui.dialogs.InformationItemElementTreeSelectionDialog;
import org.eclipse.papyrus.uml.service.types.internal.ui.dialogs.InformationItemValidator;
import org.eclipse.papyrus.uml.service.types.internal.ui.dialogs.NameLabelValidator;
import org.eclipse.papyrus.uml.service.types.internal.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class InformationFlowCreateCommand
extends CreateElementCommand {
    EObject source;
    EObject target;

    public InformationFlowCreateCommand(CreateRelationshipRequest request) {
        super((CreateElementRequest)request);
        this.source = request.getSource();
        this.target = request.getTarget();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Shell currentShell = new Shell(Display.getCurrent(), 67680);
        InformationItemElementTreeSelectionDialog dialog = new InformationItemElementTreeSelectionDialog(currentShell, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory), (ITreeContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        try {
            dialog.setTitle(Messages.InformationFlowCreateCommand_0);
            dialog.setMessage(Messages.InformationFlowCreateCommand_1);
            dialog.setAllowMultiple(true);
            dialog.setHelpAvailable(false);
            dialog.setInput(this.getSource().getModel());
            dialog.setValidator(new InformationItemValidator());
            ArrayList<InformationItem> initialSelection = new ArrayList<InformationItem>();
            while (dialog.open() != 1) {
                if (dialog.getReturnCode() == 0) {
                    Object[] conveyedClassified = dialog.getResult();
                    InformationFlow newInformationFlow = UMLFactory.eINSTANCE.createInformationFlow();
                    ((Package)((CreateElementRequest)this.getRequest()).getContainer()).getPackagedElements().add((Object)newInformationFlow);
                    newInformationFlow.getInformationSources().add((Object)this.getSource());
                    newInformationFlow.getInformationTargets().add((Object)this.getTarget());
                    int i = 0;
                    while (i < conveyedClassified.length) {
                        newInformationFlow.getConveyeds().add((Object)((Classifier)conveyedClassified[i]));
                        ++i;
                    }
                    ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newInformationFlow);
                    CommandResult commandResult = CommandResult.newOKCommandResult((Object)newInformationFlow);
                    return commandResult;
                }
                if (dialog.getReturnCode() != 1025) continue;
                initialSelection.add(this.createNewInformationItem());
                dialog.setInitialElementSelections(initialSelection);
            }
        }
        finally {
            adapterFactory.dispose();
        }
        return CommandResult.newCancelledCommandResult();
    }

    private NamedElement getSource() {
        if (this.source instanceof Element) {
            return (NamedElement)this.source;
        }
        return null;
    }

    private NamedElement getTarget() {
        if (this.target instanceof Element) {
            return (NamedElement)this.target;
        }
        return null;
    }

    private InformationItem createNewInformationItem() {
        InformationItem infoItem = UMLFactory.eINSTANCE.createInformationItem();
        ((Package)((CreateElementRequest)this.getRequest()).getContainer()).getPackagedElements().add((Object)infoItem);
        Shell currentShell = new Shell(Display.getCurrent(), 67680);
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + infoItem.eClass().getInstanceClassName());
        IDirectEditorConfiguration configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (EObject)infoItem);
        configuration.preEditAction((Object)infoItem);
        configuration.setInputValidator((IInputValidator)new NameLabelValidator(Messages.InformationFlowCreateCommand_2));
        ExtendedDirectEditionDialog dialog = new ExtendedDirectEditionDialog(currentShell, (Object)infoItem, infoItem.getName(), configuration);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            int index = ((Package)((CreateElementRequest)this.getRequest()).getContainer()).getPackagedElements().indexOf((Object)infoItem);
            ((Package)((CreateElementRequest)this.getRequest()).getContainer()).getPackagedElements().remove(index);
            return null;
        }
        infoItem.setName(dialog.getValue());
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)infoItem);
        return infoItem;
    }
}

