/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class ConnectorUtils {
    public static final String PART_WITH_PORT = "partWithPort";
    public static final String OPPOSITE_PART_WITH_PORT = "oppositePartWithPort";

    public View deduceViewContainer(View source, View target) {
        List<View> sourceProposedContainers = this.getStructureContainers(source);
        List<View> targetProposedContainers = this.getStructureContainers(target);
        View deducedContainer = null;
        for (View container : sourceProposedContainers) {
            if (!targetProposedContainers.contains(container)) continue;
            deducedContainer = container;
            break;
        }
        return deducedContainer;
    }

    public Property getPartWithPort(View checkedView, View oppositeView) {
        View parentView;
        EObject semanticParent;
        Property result = null;
        EObject targetPort = checkedView.getElement();
        if (targetPort instanceof Port && (semanticParent = (parentView = ViewUtil.getContainerView((View)checkedView)).getElement()) instanceof Property && !(semanticParent instanceof Port) && !EcoreUtil.isAncestor((EObject)parentView, (EObject)oppositeView)) {
            result = (Property)semanticParent;
        }
        return result;
    }

    public StructuredClassifier deduceContainer(View source, View target) {
        return this.deduceViewContainer(source, target) != null ? this.getStructuredClassifier(this.deduceViewContainer(source, target)) : null;
    }

    public List<View> getStructureContainers(View view) {
        ArrayList<View> containerViews = new ArrayList<View>();
        View currentView = view;
        while (currentView != null) {
            if (currentView instanceof Shape && this.getStructuredClassifier(currentView) != null) {
                containerViews.add(currentView);
            }
            currentView = ViewUtil.getContainerView((View)currentView);
        }
        return containerViews;
    }

    public StructuredClassifier getStructuredClassifier(View view) {
        Property property;
        StructuredClassifier structuredClassifier = null;
        EObject semanticElement = view.getElement();
        if (semanticElement instanceof StructuredClassifier) {
            structuredClassifier = (StructuredClassifier)semanticElement;
        } else if (semanticElement instanceof Property && (property = (Property)semanticElement).getType() instanceof StructuredClassifier) {
            structuredClassifier = (StructuredClassifier)property.getType();
        }
        return structuredClassifier;
    }

    public ConnectorEnd getSourceConnectorEnd(Connector connector) {
        return (ConnectorEnd)connector.getEnds().get(0);
    }

    public ConnectorEnd getTargetConnectorEnd(Connector connector) {
        return (ConnectorEnd)connector.getEnds().get(1);
    }

    public final Set<View> getViewsRepresentingConnector(Connector connector) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (View view : CrossReferencerUtil.getCrossReferencingViews((EObject)connector, null)) {
            viewsToDestroy.add(view);
        }
        return viewsToDestroy;
    }

    public static final boolean applyUMLRulesForConnector(Connector connector) {
        Element element = connector.getOwner();
        return element.getAppliedStereotype("SysML::Blocks::Block") == null && element.getAppliedStereotype("SysML::ConstraintBlocks::ConstraintBlock") == null;
    }

    public static final Collection<Property> getUMLPossibleRoles(StructuredClassifier connectorOwner) {
        HashSet<EncapsulatedClassifier> availableClassifiers = new HashSet<EncapsulatedClassifier>();
        availableClassifiers.addAll(ConnectorUtils.collectEncapsulatedClassifiers((List<Property>)connectorOwner.getAllAttributes()));
        availableClassifiers.addAll(ConnectorUtils.collectEncapsulatedClassifiers((EList<Element>)connectorOwner.getOwnedElements()));
        Iterator iterator = availableClassifiers.iterator();
        HashSet<Property> result = new HashSet<Property>();
        while (iterator.hasNext()) {
            EncapsulatedClassifier nextClassifier = (EncapsulatedClassifier)iterator.next();
            result.addAll((Collection<Property>)nextClassifier.getOwnedPorts());
        }
        return result;
    }

    private static List<EncapsulatedClassifier> collectEncapsulatedClassifiers(List<Property> properties) {
        ArrayList<EncapsulatedClassifier> result = new ArrayList<EncapsulatedClassifier>();
        for (Property nextProp : properties) {
            Type type = nextProp.getType();
            if (!(type instanceof EncapsulatedClassifier)) continue;
            result.add((EncapsulatedClassifier)type);
        }
        return result;
    }

    private static List<EncapsulatedClassifier> collectEncapsulatedClassifiers(EList<Element> ownedElements) {
        if (ownedElements == null) {
            return Collections.emptyList();
        }
        ArrayList<EncapsulatedClassifier> result = new ArrayList<EncapsulatedClassifier>();
        for (Element next : ownedElements) {
            if (!(next instanceof EncapsulatedClassifier)) continue;
            result.add((EncapsulatedClassifier)next);
        }
        return result;
    }
}

