/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.ui;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.etfw.ETFWUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.IToolUITab;
import org.eclipse.ptp.etfw.toolopts.ToolPaneListener;
import org.eclipse.ptp.internal.etfw.Activator;
import org.eclipse.ptp.internal.etfw.messages.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class ExternalToolSelectionTab
extends AbstractLaunchConfigurationTab
implements IToolLaunchConfigurationConstants,
IExecutableExtension {
    protected boolean noPTP = false;
    protected final ExternalToolProcess[] tools = ETFWUtils.getTools();
    protected Combo toolTypes;
    protected Button buildonlyCheck;
    protected Button analyzeonlyCheck;
    protected Button noParallelRun;
    protected Button addWorkflowB;
    protected Button removeWorkflowB;
    protected Button keepprofsCheck;
    protected final IToolUITab[] panes = ETFWUtils.getToolPanes();
    protected WidgetListener listener = new WidgetListener();
    private TabFolder tabParent = null;
    ILaunchConfiguration localConfig = null;

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    public ExternalToolSelectionTab(boolean noPar) {
        this.noPTP = noPar;
    }

    public ExternalToolSelectionTab() {
    }

    private void addWorkflow() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(Messages.ExternalToolSelectionTab_SelectToolDefXMLFile);
        String out = this.getFieldContent(dialog.open());
        if (out == null) {
            return;
        }
        IFileStore test = null;
        test = EFS.getLocalFileSystem().getStore(new File(out).toURI());
        if (test == null || !test.fetchInfo().exists() || test.fetchInfo().isDirectory()) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.etfw");
        IPreferencesService service = Platform.getPreferencesService();
        String fiList = service.getString("org.eclipse.ptp.etfw", "tool_def_xml_location", "", null);
        String[] x = fiList.split(",,,");
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        String[] stringArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            files.add(element);
            ++n2;
        }
        files.add(out);
        fiList = "";
        Iterator fit = files.iterator();
        while (fit.hasNext()) {
            fiList = String.valueOf(fiList) + (String)fit.next();
            if (!fit.hasNext()) continue;
            fiList = String.valueOf(fiList) + ",,,";
        }
        preferences.put("tool_def_xml_location", fiList);
        ETFWUtils.refreshTools(Activator.getDefault().getPreferenceStore());
        this.warnXMLChange();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        FillLayout topLayout = new FillLayout();
        comp.setLayout((Layout)topLayout);
        this.tabParent = new TabFolder(comp, 2048);
        TabItem toolTab = new TabItem(this.tabParent, 0);
        toolTab.setText(Messages.ExternalToolSelectionTab_ToolSelection);
        ScrolledComposite scrollTool = new ScrolledComposite((Composite)this.tabParent, 512);
        Composite toolComp = new Composite((Composite)scrollTool, 0);
        toolTab.setControl((Control)scrollTool);
        toolComp.setLayout((Layout)ExternalToolSelectionTab.createGridLayout(1, false, 0, 0));
        toolComp.setLayoutData((Object)ExternalToolSelectionTab.spanGridData(768, 5));
        this.createVerticalSpacer(toolComp, 1);
        Composite toolComboComp = new Composite(toolComp, 0);
        toolComboComp.setLayout((Layout)ExternalToolSelectionTab.createGridLayout(2, false, 0, 0));
        toolComboComp.setLayoutData((Object)new GridData(768));
        Label makeLab = new Label(toolComboComp, 0);
        makeLab.setText(Messages.ExternalToolSelectionTab_SelectTool);
        this.toolTypes = new Combo(toolComboComp, 2060);
        this.toolTypes.addSelectionListener((SelectionListener)this.listener);
        this.addWorkflowB = new Button(toolComboComp, 0);
        this.addWorkflowB.setText(Messages.ExternalToolSelectionTab_AddWorkflowXMLFile);
        this.addWorkflowB.addSelectionListener((SelectionListener)this.listener);
        this.removeWorkflowB = new Button(toolComboComp, 0);
        this.removeWorkflowB.setText(Messages.ExternalToolSelectionTab_RemoveWorkflowXMLFile);
        this.removeWorkflowB.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(toolComp, 1);
        this.buildonlyCheck = this.createCheckButton(toolComp, Messages.ExternalToolSelectionTab_BuildInstrumentedExecutable);
        this.buildonlyCheck.addSelectionListener((SelectionListener)this.listener);
        this.analyzeonlyCheck = this.createCheckButton(toolComp, Messages.ExternalToolSelectionTab_SelectExistingPerfData);
        this.analyzeonlyCheck.addSelectionListener((SelectionListener)this.listener);
        toolComp.pack();
        int toolCompHeight = toolComp.computeSize((int)-1, (int)-1).y;
        scrollTool.setContent((Control)toolComp);
        scrollTool.setMinSize(400, toolCompHeight);
        scrollTool.setExpandHorizontal(true);
        scrollTool.setExpandVertical(true);
    }

    protected String getFieldContent(IntegerFieldEditor editorField) {
        return this.getFieldContent(editorField.getStringValue());
    }

    protected String getFieldContent(String text) {
        if (text == null || text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    public String getName() {
        return Messages.ExternalToolSelectionTab_PerfAnalysis;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.toolTypes.removeAll();
        if (this.tools == null || this.tools.length == 0) {
            this.toolTypes.add(Messages.ExternalToolSelectionTab_SpecValidToolConfFile);
            if (this.tools == null) {
                this.toolTypes.select(0);
                return;
            }
        }
        ExternalToolProcess[] externalToolProcessArray = this.tools;
        int n = this.tools.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalToolProcess tool = externalToolProcessArray[n2];
            this.toolTypes.add(tool.toolName);
            ++n2;
        }
        this.toolTypes.select(0);
        try {
            int toolDex = this.toolTypes.indexOf(configuration.getAttribute("selected_performance_tool", ""));
            if (toolDex >= 0) {
                this.toolTypes.select(toolDex);
            } else {
                this.toolTypes.select(0);
                if (configuration.getAttribute("selected_performance_tool", "").equals("")) {
                    if (this.tools.length > 0) {
                        this.loadPanesForTool(this.toolTypes.getItem(this.toolTypes.getSelectionIndex()));
                        this.initializePanesForTool(this.toolTypes.getItem(this.toolTypes.getSelectionIndex()), configuration);
                        this.localConfig = configuration;
                    }
                    this.updateLaunchConfigurationDialog();
                }
            }
            this.buildonlyCheck.setSelection(configuration.getAttribute("build_but_do_not_run_instrumented_executable", false));
            this.analyzeonlyCheck.setSelection(configuration.getAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.loadPanesForTool(this.toolTypes.getItem(this.toolTypes.getSelectionIndex()));
        this.initializePanesForTool(this.toolTypes.getItem(this.toolTypes.getSelectionIndex()), configuration);
        this.localConfig = configuration;
    }

    private void initializePanesForTool(String tool, ILaunchConfiguration configuration) {
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                if (this.panes[i].getToolName() != null && this.panes[i].getToolName().equals(tool)) {
                    this.panes[i].OptUpdate();
                    try {
                        this.panes[i].initializePane(configuration);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private void loadPanesForTool(String tool) {
        TabItem optionTab = null;
        ScrolledComposite scrollOption = null;
        Composite optionComp = null;
        int optionCompHeight = 400;
        if (this.panes != null) {
            TabItem[] tabs = null;
            if (this.tabParent != null) {
                tabs = this.tabParent.getItems();
            }
            int i = 0;
            while (i < tabs.length) {
                if (!tabs[i].getText().equals(Messages.ExternalToolSelectionTab_ToolSelection)) {
                    tabs[i].dispose();
                }
                ++i;
            }
            i = 0;
            while (i < this.panes.length) {
                if (this.panes[i] != null && !this.panes[i].isVirtual() && !this.panes[i].isEmbedded() && this.panes[i].getToolName() != null && this.panes[i].getToolName().equals(tool)) {
                    optionTab = new TabItem(this.tabParent, 0);
                    optionTab.setText(this.panes[i].getName());
                    scrollOption = new ScrolledComposite((Composite)this.tabParent, 512);
                    optionComp = new Composite((Composite)scrollOption, 0);
                    optionTab.setControl((Control)scrollOption);
                    optionComp.setLayout((Layout)ExternalToolSelectionTab.createGridLayout(1, false, 0, 0));
                    optionComp.setLayoutData((Object)ExternalToolSelectionTab.spanGridData(768, 5));
                    this.panes[i].makeToolPane(optionComp, (ToolPaneListener)new OptionsPaneListener(this.panes[i]));
                    optionComp.pack();
                    optionCompHeight = optionComp.computeSize((int)-1, (int)-1).y;
                    scrollOption.setContent((Control)optionComp);
                    scrollOption.setMinSize(400, optionCompHeight);
                    scrollOption.setExpandHorizontal(true);
                    scrollOption.setExpandVertical(true);
                    this.panes[i].OptUpdate();
                }
                ++i;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String selectedtool = this.toolTypes.getItem(this.toolTypes.getSelectionIndex());
        configuration.setAttribute("selected_performance_tool", selectedtool);
        if (this.tools != null && this.tools.length >= 1) {
            configuration.setAttribute("true_if_using_performance_analysis_execution_utility", this.tools[this.toolTypes.getSelectionIndex()].prependExecution);
            configuration.setAttribute("true_if_recompiling_for_analysis", this.tools[this.toolTypes.getSelectionIndex()].recompile);
        }
        configuration.setAttribute("build_but_do_not_run_instrumented_executable", this.buildonlyCheck.getSelection());
        configuration.setAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", this.analyzeonlyCheck.getSelection());
        if (this.panes != null) {
            int i = 0;
            while (i < this.panes.length) {
                if (this.panes[i].getToolName() != null && this.panes[i].getToolName().equals(selectedtool)) {
                    this.panes[i].performApply(configuration);
                    String paneOpts = this.panes[i].getOptionString();
                    if (paneOpts == null) {
                        paneOpts = "";
                    }
                    configuration.setAttribute(this.panes[i].getConfigID(), paneOpts);
                    configuration.setAttribute(this.panes[i].getConfigVarID(), this.panes[i].getVarMap());
                }
                ++i;
            }
        }
        this.localConfig = configuration;
    }

    private void removeWorkflow() {
        Object[] y;
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.etfw");
        IPreferencesService service = Platform.getPreferencesService();
        String fiList = service.getString("org.eclipse.ptp.etfw", "tool_def_xml_location", "", null);
        String[] x = fiList.split(",,,");
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        String[] stringArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            files.add(element);
            ++n2;
        }
        ArrayContentProvider acp = new ArrayContentProvider();
        ListDialog ld = new ListDialog(this.getShell());
        ld.setContentProvider((IStructuredContentProvider)acp);
        ld.setBlockOnOpen(true);
        ld.setLabelProvider((ILabelProvider)new LabelProvider());
        ld.setInput((Object)x);
        ld.setHelpAvailable(false);
        ld.setTitle(Messages.ExternalToolSelectionTab_RemoveWorkflowFiles);
        ld.open();
        if (ld.getReturnCode() == 1) {
            return;
        }
        Object[] objectArray = y = ld.getResult();
        int n3 = y.length;
        int n4 = 0;
        while (n4 < n3) {
            Object element = objectArray[n4];
            files.remove(element);
            ++n4;
        }
        fiList = "";
        Iterator fit = files.iterator();
        while (fit.hasNext()) {
            fiList = String.valueOf(fiList) + (String)fit.next();
            if (!fit.hasNext()) continue;
            fiList = String.valueOf(fiList) + ",,,";
        }
        preferences.put("tool_def_xml_location", fiList);
        ETFWUtils.refreshTools(Activator.getDefault().getPreferenceStore());
        this.warnXMLChange();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.panes != null) {
            IToolUITab[] iToolUITabArray = this.panes;
            int n = this.panes.length;
            int n2 = 0;
            while (n2 < n) {
                IToolUITab pane = iToolUITabArray[n2];
                pane.setDefaults(configuration);
                ++n2;
            }
        }
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    public void updateComboFromSelection() {
        System.out.println("change startup");
    }

    private void warnXMLChange() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.ExternalToolSelectionTab_TAUWarning, (String)Messages.ExternalToolSelectionTab_ChancesNotEffectUntil);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null) {
            Map parameters = (Map)data;
            this.noPTP = Boolean.valueOf((String)parameters.get("noPTP"));
        }
    }

    protected class OptionsPaneListener
    extends ToolPaneListener {
        OptionsPaneListener(IToolUITab tool) {
            super(tool);
        }

        protected void localAction() {
            ExternalToolSelectionTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            ExternalToolSelectionTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            ExternalToolSelectionTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(ExternalToolSelectionTab.this.addWorkflowB)) {
                ExternalToolSelectionTab.this.addWorkflow();
            }
            if (source.equals(ExternalToolSelectionTab.this.removeWorkflowB)) {
                ExternalToolSelectionTab.this.removeWorkflow();
            }
            if (source.equals(ExternalToolSelectionTab.this.toolTypes)) {
                String selectedTool = ExternalToolSelectionTab.this.toolTypes.getItem(ExternalToolSelectionTab.this.toolTypes.getSelectionIndex());
                ExternalToolSelectionTab.this.loadPanesForTool(selectedTool);
                ExternalToolSelectionTab.this.initializePanesForTool(selectedTool, ExternalToolSelectionTab.this.localConfig);
            }
            ExternalToolSelectionTab.this.updateLaunchConfigurationDialog();
        }
    }
}

