/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.gem.views;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.internal.gem.GemPlugin;
import org.eclipse.ptp.internal.gem.messages.Messages;
import org.eclipse.ptp.internal.gem.util.Envelope;
import org.eclipse.ptp.internal.gem.util.GemUtilities;
import org.eclipse.ptp.internal.gem.util.Transitions;
import org.eclipse.ptp.internal.gem.views.GemAnalyzer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class GemBrowser
extends ViewPart {
    public static final String ID = "org.eclipse.ptp.gem.views.GemBrowser";
    private Transitions transitions;
    private Composite parent;
    private Action getHelpAction;
    private Action terminateOperationAction;
    private Action writeToLocalFileAction;
    private Button runGemButton;
    private Combo setNumProcsComboList;
    private CTabFolder tabFolder;
    private CLabel summaryLabel;
    private Thread browserUpdateThread;
    private Thread clearBrowserThread;
    private Thread disableTerminateButtonThread;
    private int errorCount;
    private int warningCount;
    SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TreeItem selectionItem;
            String eventText = null;
            IFile sourceFile = null;
            Integer lineNumber = null;
            Object o = event.getSource();
            if (o instanceof Tree && (selectionItem = (TreeItem)event.item).getParentItem() != null) {
                eventText = selectionItem.toString();
                Pattern browserLinePattern = Pattern.compile("^(.+?)\\s+(.+?)\\s+(.+?)\\s+(.+?)\\s+(.+?)");
                Matcher browserLineMatcher = browserLinePattern.matcher(eventText);
                if (browserLineMatcher.matches()) {
                    String filePathString = browserLineMatcher.group(3);
                    String lineNumStr = browserLineMatcher.group(5);
                    Pattern lineNumberPattern = Pattern.compile("(^[0-9]+)?+(.+?)");
                    Matcher lineNumberMatcher = lineNumberPattern.matcher(lineNumStr);
                    if (lineNumberMatcher.matches()) {
                        lineNumStr = lineNumberMatcher.group(1);
                        lineNumber = Integer.parseInt(lineNumStr);
                        sourceFile = GemUtilities.getSourceFile(filePathString, (IResource)GemUtilities.getProjectLogFile());
                        if (sourceFile != null) {
                            GemBrowser.this.openEditor(lineNumber, sourceFile);
                        } else {
                            String message = String.valueOf(Messages.GemBrowser_0) + filePathString;
                            GemUtilities.showErrorDialog(message);
                            return;
                        }
                    }
                }
            }
        }
    };

    public void activate() {
        Thread activationThread = new Thread(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    page.activate((IWorkbenchPart)GemBrowser.this);
                }
            }
        };
        Display.getDefault().syncExec((Runnable)activationThread);
    }

    public void clear() {
        Display.getDefault().syncExec((Runnable)this.clearBrowserThread);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private String createBrowserSummary() {
        String result = "";
        String newline = System.getProperty("line.separator");
        try {
            int tabCount = this.tabFolder.getItemCount();
            int tabIndex = 0;
            while (tabIndex < tabCount) {
                CTabItem currentTab = this.tabFolder.getItem(tabIndex);
                String tabTitle = currentTab.getText();
                Tree tree = (Tree)currentTab.getControl();
                result = String.valueOf(result) + tabTitle + newline;
                int numInterleavings = tree.getItemCount();
                int interIndex = 0;
                while (interIndex < numInterleavings) {
                    TreeItem currInter = tree.getItem(interIndex);
                    String interleavingName = "\t" + currInter.getText() + newline;
                    result = String.valueOf(result) + interleavingName;
                    int itemCount = currInter.getItemCount();
                    int itemIndex = 0;
                    while (itemIndex < itemCount) {
                        TreeItem item = currInter.getItem(itemIndex);
                        String line = String.valueOf(item.getText()) + newline;
                        line = "\t\t" + line;
                        result = String.valueOf(result) + line;
                        ++itemIndex;
                    }
                    ++interIndex;
                }
                result = String.valueOf(result) + newline;
                ++tabIndex;
            }
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
            result = Messages.GemBrowser_6;
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 1;
        parentLayout.marginHeight = 10;
        parentLayout.marginWidth = 10;
        parent.setLayout((Layout)parentLayout);
        this.createRuntimeComposite(parent);
        this.createSelectionListeners();
        this.makeActions();
        this.contributeToActionBars();
        this.tabFolder = new CTabFolder(parent, 128);
        this.tabFolder.setSimple(false);
        this.tabFolder.setSingle(false);
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
    }

    private void createRuntimeComposite(Composite parent) {
        Image trident = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/trident.gif"));
        Composite runtimeComposite = new Composite(parent, 0);
        runtimeComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        runtimeComposite.setLayout((Layout)new FormLayout());
        this.runGemButton = new Button(runtimeComposite, 8);
        this.runGemButton.setImage(trident);
        this.runGemButton.setToolTipText(Messages.GemBrowser_7);
        this.runGemButton.setEnabled(true);
        FormData launchIspUIFormData = new FormData();
        launchIspUIFormData.right = new FormAttachment(100, -5);
        launchIspUIFormData.bottom = new FormAttachment(100, -5);
        this.runGemButton.setLayoutData((Object)launchIspUIFormData);
        this.setNumProcsComboList = new Combo(runtimeComposite, 4);
        Font setRankComboFont = this.setFontSize(this.setNumProcsComboList.getFont(), 9);
        this.setNumProcsComboList.setFont(setRankComboFont);
        String[] items = new String[]{};
        this.setNumProcsComboList.setItems(items);
        this.setNumProcsComboList.setText(" ");
        this.setNumProcsComboList.setToolTipText(Messages.GemBrowser_8);
        FormData setRankFormData = new FormData();
        setRankFormData.width = 50;
        setRankFormData.right = new FormAttachment((Control)this.runGemButton, -5);
        setRankFormData.bottom = new FormAttachment(100, -5);
        this.setNumProcsComboList.setLayoutData((Object)setRankFormData);
        this.setNumProcsComboList.setEnabled(true);
        this.setNumProcItems();
        this.updateDropDown();
        this.summaryLabel = new CLabel(runtimeComposite, 1);
        this.summaryLabel.setRightMargin(275);
        FormData labelData = new FormData();
        labelData.width = 200;
        labelData.right = new FormAttachment((Control)this.setNumProcsComboList, -5);
        labelData.bottom = new FormAttachment(0, 0);
        this.setNumProcsComboList.setLayoutData((Object)setRankFormData);
    }

    private void createSelectionListeners() {
        this.runGemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
                URI inputLocation = null;
                Path path = null;
                try {
                    inputLocation = new URI(pstore.getString("mostRecentFile"));
                }
                catch (URISyntaxException e) {
                    GemUtilities.logExceptionDetail(e);
                }
                if (inputLocation != null) {
                    path = new Path(inputLocation.getPath());
                }
                if (!GemUtilities.isProjectActive()) {
                    GemUtilities.setTaskStatus(GemUtilities.TaskStatus.ABORTED);
                    return;
                }
                IFile file = GemUtilities.getCurrentProject().getFile(path.lastSegment());
                path = file.getFullPath();
                String extension = file.getFileExtension();
                boolean isSourceFile = false;
                if (extension != null) {
                    isSourceFile = extension.equals("c") || extension.equals("cpp") || extension.equals("c++") || extension.equals("cc") || extension.equals("cp");
                }
                GemUtilities.setCommandLineArgs();
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    String activeView = pstore.getString("activeViewPreference");
                    if (activeView.equals("analyzer")) {
                        page.showView(GemBrowser.ID);
                        page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                    } else {
                        page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                        page.showView(GemBrowser.ID);
                    }
                    GemUtilities.initGemViews((IResource)file, isSourceFile, true);
                }
                catch (PartInitException e) {
                    GemUtilities.logExceptionDetail((Exception)((Object)e));
                }
            }
        });
        this.setNumProcsComboList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GemBrowser.this.setNumProcsComboList.getText() == null) {
                    return;
                }
                String nprocsStr = GemBrowser.this.setNumProcsComboList.getItems()[GemBrowser.this.setNumProcsComboList.getSelectionIndex()];
                int newNumProcs = Integer.parseInt(nprocsStr);
                GemPlugin.getDefault().getPreferenceStore().setValue("numprocsPreference", newNumProcs);
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IViewPart gemViewPart = window.getActivePage().findView("org.eclipse.ptp.gem.views.GemAnalyzer");
                    GemAnalyzer analyzer = (GemAnalyzer)gemViewPart;
                    analyzer.updateDropDown();
                }
                catch (Exception e) {
                    GemUtilities.logExceptionDetail(e);
                }
            }
        });
    }

    private void fillAssertionViolationTab(CTabFolder tabFolder, int tabIndex) {
        new CTabItem(tabFolder, 0, tabIndex).setText(Messages.GemBrowser_11);
        CTabItem assertTab = tabFolder.getItem(tabIndex);
        assertTab.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
        assertTab.setToolTipText(Messages.GemBrowser_12);
        Tree tree = new Tree((Composite)tabFolder, 2048);
        assertTab.setControl((Control)tree);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(this.setFontSize(tree.getFont(), 8));
        TreeItem interleavingItem = null;
        TreeItem fileItem = null;
        int totalInterleavings = this.transitions.getTotalInterleavings();
        boolean errorFound = false;
        int j = 0;
        while (j <= totalInterleavings) {
            if (this.transitions.getErrorCalls() != null && this.transitions.getErrorCalls().get(j) != null) {
                int listSize = this.transitions.getErrorCalls().get(j).size();
                HashMap<String, Envelope> map = this.transitions.getErrorCalls().get(j);
                if (map != null) {
                    interleavingItem = new TreeItem(tree, 0);
                    interleavingItem.setText("Interleaving: " + j);
                    int i = 0;
                    while (i < listSize) {
                        Collection<Envelope> collection = map.values();
                        Object[] calls = new Object[collection.size()];
                        calls = collection.toArray();
                        Envelope env = (Envelope)calls[i];
                        if (env.getFunctionName().equalsIgnoreCase("mpi_assert")) {
                            errorFound = true;
                            IFile sourceFile = GemUtilities.getSourceFile(env.getFilePath(), (IResource)GemUtilities.getProjectLogFile());
                            if (sourceFile != null) {
                                String basePath = sourceFile.getFullPath().toPortableString();
                                fileItem = new TreeItem(interleavingItem, 0);
                                fileItem.setText(String.valueOf(env.getFunctionName()) + "\t" + basePath + "\tLine: " + env.getLinenumber());
                                ++this.errorCount;
                            } else {
                                this.clear();
                                GemUtilities.showErrorDialog(Messages.GemBrowser_1);
                                break;
                            }
                        }
                        ++i;
                    }
                    if (interleavingItem.getItemCount() < 1) {
                        interleavingItem.dispose();
                    }
                }
            }
            ++j;
        }
        if (!errorFound) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText(Messages.GemBrowser_14);
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif"));
            assertTab.setImage(noErrorImage);
        }
        tree.addSelectionListener(this.listener);
    }

    private void fillBrowserTabs() {
        Boolean FIB = GemPlugin.getDefault().getPreferenceStore().getBoolean("fibPreference");
        int tabIndex = 0;
        this.fillDeadlockTab(this.tabFolder, tabIndex++);
        this.fillAssertionViolationTab(this.tabFolder, tabIndex++);
        this.fillResourceLeaksTab(this.tabFolder, tabIndex++);
        if (FIB.booleanValue()) {
            this.fillIrrelevantBarrierTab(this.tabFolder, tabIndex++);
        }
        this.fillTypeMismatchTab(this.tabFolder, tabIndex++);
        this.tabFolder.setSelection(this.tabFolder.getItem(0));
        this.tabFolder.showSelection();
        String errString = this.errorCount == 1 ? Messages.GemBrowser_15 : Messages.GemBrowser_16;
        String warnString = this.warningCount == 1 ? Messages.GemBrowser_17 : Messages.GemBrowser_18;
        this.summaryLabel.setText(String.valueOf(this.errorCount) + " " + errString + " " + this.warningCount + " " + warnString);
        if (this.errorCount == 0 && this.warningCount == 0) {
            this.summaryLabel.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif")));
        } else {
            this.summaryLabel.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
        }
    }

    private void fillDeadlockTab(CTabFolder tabFolder, int tabIndex) {
        new CTabItem(tabFolder, 0, tabIndex).setText(Messages.GemBrowser_19);
        CTabItem errorTab = tabFolder.getItem(tabIndex);
        errorTab.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
        errorTab.setToolTipText(Messages.GemBrowser_20);
        Tree tree = new Tree((Composite)tabFolder, 2048);
        errorTab.setControl((Control)tree);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(this.setFontSize(tree.getFont(), 8));
        TreeItem interleavingItem = null;
        TreeItem fileItem = null;
        int totalInterleavings = this.transitions.getTotalInterleavings();
        boolean errorFound = false;
        int i = 0;
        while (i <= totalInterleavings) {
            HashMap<String, Envelope> map;
            if (this.transitions.getErrorCalls() != null && this.transitions.getErrorCalls().get(i) != null && (map = this.transitions.getErrorCalls().get(i)) != null) {
                interleavingItem = new TreeItem(tree, 0);
                interleavingItem.setText("Interleaving: " + i);
                Collection<Envelope> collection = map.values();
                for (Envelope env : collection) {
                    if (env.getFunctionName().equalsIgnoreCase("mpi_assert")) continue;
                    errorFound = true;
                    IFile sourceFile = GemUtilities.getSourceFile(env.getFilePath(), (IResource)GemUtilities.getProjectLogFile());
                    if (sourceFile != null) {
                        String basePath = sourceFile.getFullPath().toPortableString();
                        fileItem = new TreeItem(interleavingItem, 0);
                        fileItem.setText(String.valueOf(env.getFunctionName()) + "\t" + basePath + "\tLine: " + env.getLinenumber());
                        ++this.errorCount;
                        continue;
                    }
                    this.clear();
                    GemUtilities.showErrorDialog(Messages.GemBrowser_2);
                    break;
                }
                if (interleavingItem.getItemCount() < 1) {
                    interleavingItem.dispose();
                }
            }
            ++i;
        }
        if (!errorFound) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText(Messages.GemBrowser_22);
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif"));
            errorTab.setImage(noErrorImage);
        }
        tree.addSelectionListener(this.listener);
    }

    private void fillIrrelevantBarrierTab(CTabFolder tabFolder, int tabIndex) {
        new CTabItem(tabFolder, 0, tabIndex).setText(Messages.GemBrowser_23);
        CTabItem IBTab = tabFolder.getItem(tabIndex);
        IBTab.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
        IBTab.setToolTipText(Messages.GemBrowser_24);
        Tree tree = new Tree((Composite)tabFolder, 2048);
        IBTab.setControl((Control)tree);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(this.setFontSize(tree.getFont(), 8));
        TreeItem interleavingItem = null;
        TreeItem fileItem = null;
        Boolean FIB = GemPlugin.getDefault().getPreferenceStore().getBoolean("fibPreference");
        if (!FIB.booleanValue()) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText(Messages.GemBrowser_25);
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/help-contents.gif"));
            IBTab.setImage(noErrorImage);
        } else if (this.transitions.hasDeadlock()) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText(Messages.GemBrowser_26);
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/help-contents.gif"));
            IBTab.setImage(noErrorImage);
        } else if (this.transitions.getIrrelevantBarriers() == null) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText(Messages.GemBrowser_27);
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif"));
            IBTab.setImage(noErrorImage);
        } else {
            HashMap<Integer, String> fibs = this.transitions.getIrrelevantBarriers();
            TreeItem group = null;
            int groupNumber = 0;
            Collection<String> fibList = fibs.values();
            for (String line : fibList) {
                if (group == null) {
                    group = new TreeItem(tree, 0);
                    group.setText("Interleaving: " + ++groupNumber);
                }
                StringTokenizer tokenizer = new StringTokenizer(line);
                String filePathString = tokenizer.nextToken();
                String lineNumber = tokenizer.nextToken();
                IFile sourceFile = GemUtilities.getSourceFile(filePathString, (IResource)GemUtilities.getProjectLogFile());
                if (sourceFile != null) {
                    String basePath = sourceFile.getFullPath().toPortableString();
                    String text = "FIB\t" + basePath + "\tLine: " + lineNumber;
                    fileItem = new TreeItem(group, 0);
                    fileItem.setText(text);
                    ++this.warningCount;
                    continue;
                }
                this.clear();
                GemUtilities.showErrorDialog(Messages.GemBrowser_3);
                break;
            }
            tree.addSelectionListener(this.listener);
        }
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.terminateOperationAction);
        this.terminateOperationAction.setText(Messages.GemBrowser_29);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.writeToLocalFileAction);
        this.writeToLocalFileAction.setText(Messages.GemBrowser_30);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getHelpAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.terminateOperationAction);
        manager.add((IAction)this.writeToLocalFileAction);
        manager.add((IAction)this.getHelpAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillResourceLeaksTab(CTabFolder tabFolder, int tabIndex) {
        new CTabItem(tabFolder, 0, tabIndex).setText(Messages.GemBrowser_31);
        CTabItem leakTab = tabFolder.getItem(tabIndex);
        leakTab.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
        leakTab.setToolTipText(Messages.GemBrowser_32);
        Tree tree = new Tree((Composite)tabFolder, 2048);
        leakTab.setControl((Control)tree);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(this.setFontSize(tree.getFont(), 8));
        TreeItem interleavingItem = null;
        TreeItem fileItem = null;
        int prevInterleaving = -1;
        HashMap<Integer, Envelope> leaks = this.transitions.getResourceLeaks();
        if (leaks == null) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText(Messages.GemBrowser_33);
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif"));
            leakTab.setImage(noErrorImage);
        } else {
            Collection<Envelope> leakList = leaks.values();
            for (Envelope env : leakList) {
                IFile sourceFile;
                if (prevInterleaving != env.getInterleaving()) {
                    interleavingItem = new TreeItem(tree, 0);
                    interleavingItem.setText("Interleaving: " + env.getInterleaving());
                    prevInterleaving = env.getInterleaving();
                }
                if ((sourceFile = GemUtilities.getSourceFile(env.getFilePath(), (IResource)GemUtilities.getProjectLogFile())) != null) {
                    String basePath = sourceFile.getFullPath().toPortableString();
                    String text = String.valueOf(env.getLeakResource()) + "\t" + basePath + "\tLine: " + env.getLinenumber();
                    fileItem = new TreeItem(interleavingItem, 0);
                    fileItem.setText(text);
                    ++this.warningCount;
                    continue;
                }
                this.clear();
                GemUtilities.showErrorDialog(Messages.GemBrowser_4);
                break;
            }
        }
        tree.addSelectionListener(this.listener);
    }

    private void fillTypeMismatchTab(CTabFolder tabFolder, int tabIndex) {
        new CTabItem(tabFolder, 0, tabIndex).setText("Type Mismatches");
        CTabItem IBTab = tabFolder.getItem(tabIndex);
        IBTab.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
        IBTab.setToolTipText("Browse Type Mismatches");
        Tree tree = new Tree((Composite)tabFolder, 2048);
        IBTab.setControl((Control)tree);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(this.setFontSize(tree.getFont(), 8));
        TreeItem interleavingItem = null;
        TreeItem fileItem = null;
        if (this.transitions.getTypeMismatches() == null) {
            interleavingItem = new TreeItem(tree, 0);
            interleavingItem.setText("No Type Mismatches Found");
            Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif"));
            IBTab.setImage(noErrorImage);
        } else {
            HashMap<Integer, String> mismatches = this.transitions.getTypeMismatches();
            TreeItem group = null;
            int groupNumber = 0;
            Collection<String> mismatchList = mismatches.values();
            for (String line : mismatchList) {
                if (group == null) {
                    group = new TreeItem(tree, 0);
                    group.setText("Interleaving: " + ++groupNumber);
                }
                StringTokenizer tokenizer = new StringTokenizer(line);
                String filePathString = tokenizer.nextToken();
                String lineNumber = tokenizer.nextToken();
                IFile sourceFile = GemUtilities.getSourceFile(filePathString, (IResource)GemUtilities.getProjectLogFile());
                if (sourceFile != null) {
                    String basePath = sourceFile.getFullPath().toPortableString();
                    String text = "Type_Mismatch\t" + basePath + "\tLine: " + lineNumber;
                    fileItem = new TreeItem(group, 0);
                    fileItem.setText(text);
                    ++this.warningCount;
                    continue;
                }
                this.clear();
                GemUtilities.showErrorDialog(Messages.GemBrowser_5);
                break;
            }
            tree.addSelectionListener(this.listener);
        }
    }

    public void init() {
        this.browserUpdateThread = new Thread(){

            public void run() {
                GemBrowser.this.reset();
                GemBrowser.this.fillBrowserTabs();
                Display.getDefault().syncExec((Runnable)GemBrowser.this.disableTerminateButtonThread);
            }
        };
        this.clearBrowserThread = new Thread(){

            public void run() {
                GemBrowser.this.terminateOperationAction.setEnabled(false);
                GemBrowser.this.writeToLocalFileAction.setEnabled(false);
                GemBrowser.this.runGemButton.setEnabled(true);
                GemBrowser.this.transitions = null;
                GemBrowser.this.errorCount = 0;
                GemBrowser.this.warningCount = 0;
                GemBrowser.this.summaryLabel.setText("");
                GemBrowser.this.summaryLabel.setImage(null);
                GemBrowser.this.removeTabs();
                GemUtilities.setTaskStatus(GemUtilities.TaskStatus.IDLE);
            }
        };
        this.disableTerminateButtonThread = new Thread(){

            public void run() {
                GemBrowser.this.terminateOperationAction.setEnabled(false);
                GemBrowser.this.writeToLocalFileAction.setEnabled(true);
                GemBrowser.this.runGemButton.setEnabled(true);
            }
        };
        this.writeToLocalFileAction.setEnabled(false);
        this.terminateOperationAction.setEnabled(true);
        this.runGemButton.setEnabled(false);
    }

    private void makeActions() {
        this.getHelpAction = new Action(){

            public void run() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.ptp.gem.help/html/browserView.html");
            }
        };
        this.getHelpAction.setToolTipText(Messages.GemBrowser_39);
        this.getHelpAction.setImageDescriptor(GemPlugin.getImageDescriptor("icons/help-contents.gif"));
        this.terminateOperationAction = new Action(){

            public void run() {
                GemUtilities.terminateOperation();
            }
        };
        this.terminateOperationAction.setImageDescriptor(GemPlugin.getImageDescriptor("icons/progress_stop.gif"));
        this.terminateOperationAction.setToolTipText(Messages.GemBrowser_40);
        this.terminateOperationAction.setEnabled(false);
        this.writeToLocalFileAction = new Action(){

            public void run() {
                JFileChooser fc = new JFileChooser();
                JFrame frame = new JFrame();
                int result = fc.showSaveDialog(frame);
                if (result == 0) {
                    File file = fc.getSelectedFile();
                    if (file.exists()) {
                        result = fc.showDialog(frame, Messages.GemBrowser_41);
                    }
                    if (result == 0) {
                        GemUtilities.saveToLocalFile(file, GemBrowser.this.createBrowserSummary());
                    }
                } else if (result == -1) {
                    GemUtilities.showErrorDialog(Messages.GemBrowser_42);
                }
            }
        };
        this.writeToLocalFileAction.setToolTipText(Messages.GemBrowser_43);
        this.writeToLocalFileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.writeToLocalFileAction.setEnabled(false);
    }

    private void openEditor(int lineNumber, IFile sourceFile) {
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)sourceFile, (boolean)true);
            IMarker marker = sourceFile.createMarker("org.eclipse.core.resources.marker");
            marker.setAttribute("lineNumber", lineNumber);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
        }
    }

    private void removeTabs() {
        CTabItem[] items = this.tabFolder.getItems();
        int numItems = items.length;
        int i = 0;
        while (i < numItems) {
            items[i].dispose();
            ++i;
        }
    }

    private void reset() {
        this.setNumProcItems();
        this.removeTabs();
        GemUtilities.setTaskStatus(GemUtilities.TaskStatus.IDLE);
        Display.getDefault().syncExec((Runnable)this.disableTerminateButtonThread);
    }

    public void setFocus() {
        this.runGemButton.setFocus();
    }

    private Font setFontSize(Font font, int size) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = font.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight(size);
            ++n2;
        }
        return new Font((Device)this.parent.getDisplay(), fontData);
    }

    private void setNumProcItems() {
        String[] ranks = new String[16];
        int i = 1;
        while (i <= 16) {
            ranks[i - 1] = Integer.valueOf(i).toString();
            ++i;
        }
        this.setNumProcsComboList.setItems(ranks);
        Integer numProcs = GemPlugin.getDefault().getPreferenceStore().getInt("numprocsPreference");
        this.setNumProcsComboList.setText(numProcs.toString());
    }

    public void update(Transitions transitions) {
        this.transitions = transitions;
        this.errorCount = 0;
        this.warningCount = 0;
        Display.getDefault().syncExec((Runnable)this.browserUpdateThread);
    }

    public void updateDropDown() {
        Integer nprocs = GemPlugin.getDefault().getPreferenceStore().getInt("numprocsPreference");
        this.setNumProcsComboList.setText(nprocs.toString());
    }
}

