/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.coordinates.rcp;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.internal.coordinates.rcp.AdvisorDescriptor;

public final class AdvisorDescriptors {
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String DEFAULT_PRIORITY_ATTRIBUTE = "defaultPriority";
    private static final char DISABLED_FLAG = '!';
    private static final char SEPARATOR = ';';
    private static final String EXT_ID_PROVIDER = "org.eclipse.recommenders.coordinates.rcp.advisors";

    private AdvisorDescriptors() {
    }

    public static List<AdvisorDescriptor> getRegisteredAdvisors() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_PROVIDER);
        Arrays.sort(elements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement lhs, IConfigurationElement rhs) {
                Integer lhsPriority = Integer.valueOf(lhs.getAttribute(AdvisorDescriptors.DEFAULT_PRIORITY_ATTRIBUTE));
                Integer rhsPriority = Integer.valueOf(rhs.getAttribute(AdvisorDescriptors.DEFAULT_PRIORITY_ATTRIBUTE));
                return lhsPriority.compareTo(rhsPriority);
            }
        });
        ArrayList<AdvisorDescriptor> descriptors = new ArrayList<AdvisorDescriptor>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            boolean enabled = Boolean.valueOf((String)Objects.firstNonNull((Object)element.getAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE), (Object)Boolean.TRUE.toString()));
            descriptors.add(new AdvisorDescriptor(element, enabled));
            ++n2;
        }
        return descriptors;
    }

    public static List<AdvisorDescriptor> load(String string, List<AdvisorDescriptor> available) {
        ArrayList<AdvisorDescriptor> result = new ArrayList<AdvisorDescriptor>();
        String[] stringArray = StringUtils.split((String)string, (char)';');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean enabled;
            String id = stringArray[n2];
            if (id.charAt(0) == '!') {
                enabled = false;
                id = id.substring(1);
            } else {
                enabled = true;
            }
            AdvisorDescriptor found = AdvisorDescriptors.find(available, id);
            if (found != null) {
                AdvisorDescriptor descriptor = new AdvisorDescriptor(found);
                descriptor.setEnabled(enabled);
                result.add(descriptor);
            }
            ++n2;
        }
        for (AdvisorDescriptor descriptor : available) {
            if (AdvisorDescriptors.find(result, descriptor.getId()) != null) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static String store(List<AdvisorDescriptor> descriptors) {
        StringBuilder sb = new StringBuilder();
        Iterator<AdvisorDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            AdvisorDescriptor descriptor = it.next();
            if (!descriptor.isEnabled()) {
                sb.append('!');
            }
            sb.append(descriptor.getId());
            if (!it.hasNext()) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    private static AdvisorDescriptor find(List<AdvisorDescriptor> descriptors, String id) {
        for (AdvisorDescriptor descriptor : descriptors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }
}

