/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.utils.Logs;

public class ModelsRcpPreferences {
    @Inject
    @Preference(value="repository.auto.download")
    public boolean autoDownloadEnabled;
    public String[] remotes;
    private final EventBus bus;
    static final String URL_SEPARATOR = "\t";
    private final ISecurePreferences securePreferencesRoot;

    @Inject
    public ModelsRcpPreferences(EventBus bus) {
        this.bus = bus;
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        this.securePreferencesRoot = root == null ? null : root.node("org.eclipse.recommenders.models.rcp");
    }

    @Inject
    public void setRemote(@Preference(value="repository.url.list") String newRemote) throws Exception {
        String[] old = this.remotes;
        this.remotes = ModelsRcpPreferences.splitRemoteRepositoryString(newRemote);
        if (!ArrayUtils.isEquals((Object)this.remotes, (Object)old)) {
            this.bus.post((Object)new ModelEvents.ModelRepositoryUrlChangedEvent());
        }
    }

    public void setServerUsername(String serverUri, String username) {
        ISecurePreferences securePreferences = (ISecurePreferences)this.getSecurePreferencesForServer(serverUri, true).orNull();
        if (securePreferences == null) {
            return;
        }
        try {
            if (Strings.isNullOrEmpty((String)username)) {
                securePreferences.remove("username");
            } else {
                securePreferences.put("username", username, false);
            }
            securePreferences.flush();
        }
        catch (IOException | StorageException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_STORE_SECURE_PREFERENCE, (Throwable)e);
        }
    }

    public Optional<String> getServerUsername(String serverUri) {
        ISecurePreferences securePreferences = (ISecurePreferences)this.getSecurePreferencesForServer(serverUri, false).orNull();
        if (securePreferences == null) {
            return Optional.absent();
        }
        try {
            return Optional.fromNullable((Object)securePreferences.get("username", null));
        }
        catch (StorageException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_LOAD_SECURE_PREFERENCE, (Throwable)e);
            return Optional.absent();
        }
    }

    public void setServerPassword(String serverUri, String password) {
        ISecurePreferences securePreferences = (ISecurePreferences)this.getSecurePreferencesForServer(serverUri, true).orNull();
        if (securePreferences == null) {
            return;
        }
        try {
            if (Strings.isNullOrEmpty((String)password)) {
                securePreferences.remove("password");
            } else {
                securePreferences.put("password", password, true);
            }
            securePreferences.flush();
        }
        catch (IOException | StorageException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_STORE_SECURE_PREFERENCE, (Throwable)e);
        }
    }

    public Optional<String> getServerPassword(String serverUri) {
        ISecurePreferences securePreferences = (ISecurePreferences)this.getSecurePreferencesForServer(serverUri, false).orNull();
        if (securePreferences == null) {
            return Optional.absent();
        }
        try {
            return Optional.fromNullable((Object)securePreferences.get("password", null));
        }
        catch (StorageException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_LOAD_SECURE_PREFERENCE, (Throwable)e);
            return Optional.absent();
        }
    }

    public boolean hasPassword(String serverUri) {
        ISecurePreferences securePreferences = (ISecurePreferences)this.getSecurePreferencesForServer(serverUri, false).orNull();
        if (securePreferences == null) {
            return false;
        }
        try {
            return securePreferences.isEncrypted("password");
        }
        catch (StorageException storageException) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_LOAD_SECURE_PREFERENCE);
            return false;
        }
    }

    private Optional<ISecurePreferences> getSecurePreferencesForServer(String uri, boolean create) {
        if (Strings.isNullOrEmpty((String)uri)) {
            return Optional.absent();
        }
        if (this.securePreferencesRoot == null) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_LOAD_SECURE_PREFERENCE);
            return Optional.absent();
        }
        String nodeName = EncodingUtils.encodeSlashes((String)uri);
        if (create || this.securePreferencesRoot.nodeExists(nodeName)) {
            return Optional.of((Object)this.securePreferencesRoot.node(nodeName));
        }
        return Optional.absent();
    }

    public static String[] splitRemoteRepositoryString(String remoteUrls) {
        Iterable split = Splitter.on((String)URL_SEPARATOR).omitEmptyStrings().split((CharSequence)remoteUrls);
        return (String[])Iterables.toArray((Iterable)split, String.class);
    }

    public static String joinRemoteRepositoriesToString(String[] remotes) {
        return Joiner.on((String)URL_SEPARATOR).join((Object[])remotes);
    }

    public static String joinRemoteRepositoriesToString(Iterable<String> remotes) {
        return ModelsRcpPreferences.joinRemoteRepositoriesToString((String[])Iterables.toArray(remotes, String.class));
    }
}

