/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.ListenerContext;

public class Event {
    private static final int TRACE_SOURCE_STACK_DEPTH = 1;

    public boolean supersedes(Event event) {
        return false;
    }

    final void trace(int listeners) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        this.fillTracingInfo(info);
        info.put("listeners", String.valueOf(listeners));
        System.err.println(this.toString(info, Thread.currentThread().getStackTrace()));
    }

    public String toString() {
        return this.toString(this.fillTracingInfo(), null);
    }

    private final String toString(Map<String, String> info, StackTraceElement[] source) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        if (!info.isEmpty() || source != null) {
            buf.append("\n{\n");
            for (Map.Entry<String, String> entry : info.entrySet()) {
                buf.append("    ");
                buf.append(entry.getKey());
                buf.append(" = ");
                buf.append(entry.getValue());
                buf.append('\n');
            }
            if (source != null) {
                int i = 0;
                while (i < source.length) {
                    StackTraceElement entry = source[i];
                    String cl = entry.getClassName();
                    String method = entry.getMethodName();
                    if (!(cl.equals(Event.class.getName()) || cl.equals(ListenerContext.class.getName()) || cl.equals(Thread.class.getName()) || method.equals("broadcast") || method.equals("post"))) {
                        int j = i;
                        int n = Math.min(i + 1, source.length);
                        while (j < n) {
                            entry = source[j];
                            cl = entry.getClassName();
                            method = entry.getMethodName();
                            buf.append("    ");
                            buf.append(j == i ? "source = " : "         ");
                            buf.append(cl);
                            buf.append('.');
                            buf.append(method);
                            buf.append('(');
                            buf.append(entry.getLineNumber());
                            buf.append(")\n");
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            buf.append('}');
        }
        return buf.toString();
    }

    private final Map<String, String> fillTracingInfo() {
        return this.fillTracingInfo(new LinkedHashMap<String, String>());
    }

    protected Map<String, String> fillTracingInfo(Map<String, String> info) {
        return info;
    }
}

