/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.Observable;

public final class ObservableMap<K, V>
extends AbstractMap<K, V>
implements Observable {
    private final Map<K, V> base;
    private Set<Map.Entry<K, V>> entries;
    private ListenerContext listeners;

    public ObservableMap() {
        this(null);
    }

    public ObservableMap(Map<K, V> base) {
        this.base = base == null ? new HashMap() : base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            if (this.listeners == null) {
                this.listeners = new ListenerContext();
            }
            this.listeners.attach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            if (this.listeners != null) {
                this.listeners.detach(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast() {
        ListenerContext listeners;
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            listeners = this.listeners;
        }
        if (listeners != null) {
            listeners.broadcast(new Event());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            return this.base.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            return this.base.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            return this.base.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            return this.base.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            return this.base.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V previous;
        boolean broadcast = false;
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            if (this.base.containsKey(key)) {
                previous = this.base.put(key, value);
                if (previous != value) {
                    broadcast = true;
                }
            } else {
                this.base.put(key, value);
                previous = null;
                broadcast = true;
            }
        }
        if (broadcast) {
            this.broadcast();
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        boolean broadcast = false;
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                if (this.base.containsKey(key)) {
                    V previous = this.base.put(key, value);
                    if (value == previous) continue;
                    broadcast = true;
                    continue;
                }
                this.base.put(key, value);
                broadcast = true;
            }
        }
        if (broadcast) {
            this.broadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        V removed;
        boolean broadcast = false;
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            if (this.base.containsKey(key)) {
                broadcast = true;
            }
            removed = this.base.remove(key);
        }
        if (broadcast) {
            this.broadcast();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        boolean broadcast = false;
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            if (!this.base.isEmpty()) {
                broadcast = true;
            }
            this.base.clear();
        }
        if (broadcast) {
            this.broadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ObservableMap observableMap = this;
        synchronized (observableMap) {
            if (this.entries == null) {
                this.entries = new AbstractSet<Map.Entry<K, V>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        ObservableMap observableMap = ObservableMap.this;
                        synchronized (observableMap) {
                            return new Iterator<Map.Entry<K, V>>(){
                                private final Iterator<Map.Entry<K, V>> base;
                                {
                                    this.base = ObservableMap.this.base.entrySet().iterator();
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public boolean hasNext() {
                                    ObservableMap observableMap = ObservableMap.this;
                                    synchronized (observableMap) {
                                        return this.base.hasNext();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public Map.Entry<K, V> next() {
                                    ObservableMap observableMap = ObservableMap.this;
                                    synchronized (observableMap) {
                                        return this.base.next();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void remove() {
                                    ObservableMap observableMap = ObservableMap.this;
                                    synchronized (observableMap) {
                                        this.base.remove();
                                        ObservableMap.this.broadcast();
                                    }
                                }
                            };
                        }
                    }

                    @Override
                    public int size() {
                        return ObservableMap.this.size();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean contains(Object obj) {
                        ObservableMap observableMap = ObservableMap.this;
                        synchronized (observableMap) {
                            return ObservableMap.this.base.entrySet().contains(obj);
                        }
                    }
                };
            }
            return this.entries;
        }
    }
}

