/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Length;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class LengthFactsServiceForValue
extends FactsService {
    @Text(value="Minimum length is {0}")
    public static LocalizableText minLengthStatement;
    @Text(value="Maximum length is {0}")
    public static LocalizableText maxLengthStatement;
    private int min;
    private int max;

    static {
        LocalizableText.init(LengthFactsServiceForValue.class);
    }

    @Override
    protected void init() {
        PropertyDef property = this.context(PropertyDef.class);
        Length annotation = property.getAnnotation(Length.class);
        this.min = annotation.min();
        this.max = annotation.max();
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        if (this.min != 0) {
            facts.add(minLengthStatement.format(this.min));
        }
        if (this.max != Integer.MAX_VALUE) {
            facts.add(maxLengthStatement.format(this.max));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                Length annotation = property.getAnnotation(Length.class);
                return annotation != null && (annotation.min() > 0 || annotation.max() < Integer.MAX_VALUE);
            }
            return false;
        }
    }
}

