/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.Collection;
import java.util.List;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.util.ListFactory;

public final class AndFunction
extends Function {
    public static Function create(Function ... operands) {
        return AndFunction.create(ListFactory.start().add(operands));
    }

    public static Function create(List<Function> operands) {
        return AndFunction.create(ListFactory.start().add((Collection<Function>)operands));
    }

    private static Function create(ListFactory<Function> operands) {
        int cardinality = operands.size();
        if (cardinality == 0) {
            return null;
        }
        if (cardinality == 1) {
            return operands.get(0);
        }
        AndFunction function = new AndFunction();
        function.init(operands.result());
        return function;
    }

    @Override
    public String name() {
        return "&&";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 6;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                boolean result = true;
                for (FunctionResult operand : this.operands()) {
                    boolean bl = result = result && this.cast(operand.value(), Boolean.class) != false;
                }
                return result;
            }
        };
    }
}

