/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.ValueSnapshot;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DefaultValueFactsService
extends FactsService {
    @Text(value="Default value is {0}")
    private static LocalizableText statement;
    @Text(value="Has default value")
    private static LocalizableText statementForSensitive;

    static {
        LocalizableText.init(DefaultValueFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        Value value = this.context(Value.class);
        String def = value.getDefaultText();
        if (def != null) {
            if (value.definition().hasAnnotation(SensitiveData.class)) {
                facts.add(statementForSensitive.text());
            } else {
                facts.add(statement.format(new ValueSnapshot(value.definition(), def)));
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return context.find(ValueProperty.class) != null;
        }
    }
}

